/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.ComposedLastHttpContent;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public abstract class HttpContentEncoder
extends MessageToMessageCodec<HttpRequest, HttpObject> {
    private static final CharSequence ZERO_LENGTH_HEAD = "HEAD";
    private static final CharSequence ZERO_LENGTH_CONNECT = "CONNECT";
    private final Queue<CharSequence> acceptEncodingQueue = new ArrayDeque<CharSequence>();
    private EmbeddedChannel encoder;
    private State state = State.AWAIT_HEADERS;

    public boolean acceptOutboundMessage(Object object) {
        return object instanceof HttpContent || object instanceof HttpResponse;
    }

    protected void decode(ChannelHandlerContext object, HttpRequest httpRequest, List<Object> list) {
        object = httpRequest.headers().getAll((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
        switch (object.size()) {
            case 0: {
                object = HttpContentDecoder.IDENTITY;
                break;
            }
            case 1: {
                object = (CharSequence)object.get(0);
                break;
            }
            default: {
                object = StringUtil.join((CharSequence)",", (Iterable)object);
            }
        }
        HttpMethod httpMethod = httpRequest.method();
        if (HttpMethod.HEAD.equals(httpMethod)) {
            object = ZERO_LENGTH_HEAD;
        } else if (HttpMethod.CONNECT.equals(httpMethod)) {
            object = ZERO_LENGTH_CONNECT;
        }
        this.acceptEncodingQueue.add((CharSequence)object);
        list.add(ReferenceCountUtil.retain((Object)httpRequest));
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        boolean bl = httpObject instanceof HttpResponse && httpObject instanceof LastHttpContent;
        switch (this.state) {
            case AWAIT_HEADERS: {
                HttpContentEncoder.ensureHeaders(httpObject);
                assert (this.encoder == null);
                HttpResponse httpResponse = (HttpResponse)httpObject;
                int n = httpResponse.status().code();
                Object object = httpResponse.status().codeClass();
                if (object == HttpStatusClass.INFORMATIONAL) {
                    object = null;
                } else {
                    object = this.acceptEncodingQueue.poll();
                    if (object == null) {
                        throw new IllegalStateException("cannot send more responses than requests");
                    }
                }
                if (HttpContentEncoder.isPassthru(httpResponse.protocolVersion(), n, (CharSequence)object)) {
                    if (bl) {
                        list.add(ReferenceCountUtil.retain((Object)httpResponse));
                        return;
                    }
                    list.add(ReferenceCountUtil.retain((Object)httpResponse));
                    this.state = State.PASS_THROUGH;
                    return;
                }
                if (bl && !((ByteBufHolder)httpResponse).content().isReadable()) {
                    list.add(ReferenceCountUtil.retain((Object)httpResponse));
                    return;
                }
                Result result = this.beginEncode(httpResponse, object.toString());
                if (result == null) {
                    if (bl) {
                        list.add(ReferenceCountUtil.retain((Object)httpResponse));
                        return;
                    }
                    list.add(ReferenceCountUtil.retain((Object)httpResponse));
                    this.state = State.PASS_THROUGH;
                    return;
                }
                this.encoder = result.contentEncoder();
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)result.targetContentEncoding());
                if (bl) {
                    DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(httpResponse.protocolVersion(), httpResponse.status());
                    defaultHttpResponse.headers().set(httpResponse.headers());
                    list.add(defaultHttpResponse);
                    HttpContentEncoder.ensureContent(httpResponse);
                    this.encodeFullResponse(defaultHttpResponse, (HttpContent)((Object)httpResponse), list);
                    return;
                }
                httpResponse.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                httpResponse.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                list.add(ReferenceCountUtil.retain((Object)httpResponse));
                this.state = State.AWAIT_CONTENT;
                if (!(httpObject instanceof HttpContent)) break;
            }
            case AWAIT_CONTENT: {
                HttpContentEncoder.ensureContent(httpObject);
                if (this.encodeContent((HttpContent)httpObject, list)) {
                    this.state = State.AWAIT_HEADERS;
                    return;
                }
                if (!list.isEmpty()) break;
                list.add(new DefaultHttpContent(Unpooled.EMPTY_BUFFER));
                return;
            }
            case PASS_THROUGH: {
                HttpContentEncoder.ensureContent(httpObject);
                list.add(ReferenceCountUtil.retain((Object)httpObject));
                if (!(httpObject instanceof LastHttpContent)) break;
                this.state = State.AWAIT_HEADERS;
            }
        }
    }

    private void encodeFullResponse(HttpResponse httpResponse, HttpContent httpContent, List<Object> list) {
        int n = list.size();
        this.encodeContent(httpContent, list);
        if (HttpUtil.isContentLengthSet(httpResponse)) {
            int n2 = 0;
            while (n < list.size()) {
                Object object = list.get(n);
                if (object instanceof HttpContent) {
                    n2 += ((HttpContent)object).content().readableBytes();
                }
                ++n;
            }
            HttpUtil.setContentLength(httpResponse, n2);
            return;
        }
        httpResponse.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
    }

    private static boolean isPassthru(HttpVersion httpVersion, int n, CharSequence charSequence) {
        return n < 200 || n == 204 || n == 304 || charSequence == ZERO_LENGTH_HEAD || charSequence == ZERO_LENGTH_CONNECT && n == 200 || httpVersion == HttpVersion.HTTP_1_0;
    }

    private static void ensureHeaders(HttpObject httpObject) {
        if (!(httpObject instanceof HttpResponse)) {
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpResponse.class.getSimpleName() + ')');
        }
    }

    private static void ensureContent(HttpObject httpObject) {
        if (!(httpObject instanceof HttpContent)) {
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpContent.class.getSimpleName() + ')');
        }
    }

    private boolean encodeContent(HttpContent object, List<Object> list) {
        ByteBuf byteBuf = object.content();
        this.encode(byteBuf, list);
        if (object instanceof LastHttpContent) {
            this.finishEncode(list);
            object = (LastHttpContent)object;
            object = object.trailingHeaders();
            if (((HttpHeaders)object).isEmpty()) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                list.add(new ComposedLastHttpContent((HttpHeaders)object, DecoderResult.SUCCESS));
            }
            return true;
        }
        return false;
    }

    protected abstract Result beginEncode(HttpResponse var1, String var2);

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanupSafely(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.cleanupSafely(channelHandlerContext);
        super.channelInactive(channelHandlerContext);
    }

    private void cleanup() {
        if (this.encoder != null) {
            this.encoder.finishAndReleaseAll();
            this.encoder = null;
        }
    }

    private void cleanupSafely(ChannelHandlerContext channelHandlerContext) {
        try {
            this.cleanup();
            return;
        }
        catch (Throwable throwable) {
            channelHandlerContext.fireExceptionCaught(throwable);
            return;
        }
    }

    private void encode(ByteBuf byteBuf, List<Object> list) {
        this.encoder.writeOutbound(new Object[]{byteBuf.retain()});
        this.fetchEncoderOutput(list);
    }

    private void finishEncode(List<Object> list) {
        if (this.encoder.finish()) {
            this.fetchEncoderOutput(list);
        }
        this.encoder = null;
    }

    private void fetchEncoderOutput(List<Object> list) {
        ByteBuf byteBuf;
        while ((byteBuf = (ByteBuf)this.encoder.readOutbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            list.add(new DefaultHttpContent(byteBuf));
        }
    }

    public static final class Result {
        private final String targetContentEncoding;
        private final EmbeddedChannel contentEncoder;

        public Result(String string, EmbeddedChannel embeddedChannel) {
            this.targetContentEncoding = (String)ObjectUtil.checkNotNull((Object)string, (String)"targetContentEncoding");
            this.contentEncoder = (EmbeddedChannel)ObjectUtil.checkNotNull((Object)embeddedChannel, (String)"contentEncoder");
        }

        public final String targetContentEncoding() {
            return this.targetContentEncoding;
        }

        public final EmbeddedChannel contentEncoder() {
            return this.contentEncoder;
        }
    }

    private static enum State {
        PASS_THROUGH,
        AWAIT_HEADERS,
        AWAIT_CONTENT;

    }
}

