/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;

public class CloseWebSocketFrame
extends WebSocketFrame {
    public CloseWebSocketFrame() {
        super(Unpooled.buffer((int)0));
    }

    public CloseWebSocketFrame(WebSocketCloseStatus webSocketCloseStatus) {
        this(CloseWebSocketFrame.requireValidStatusCode(webSocketCloseStatus.code()), webSocketCloseStatus.reasonText());
    }

    public CloseWebSocketFrame(WebSocketCloseStatus webSocketCloseStatus, String string) {
        this(CloseWebSocketFrame.requireValidStatusCode(webSocketCloseStatus.code()), string);
    }

    public CloseWebSocketFrame(int n, String string) {
        this(true, 0, CloseWebSocketFrame.requireValidStatusCode(n), string);
    }

    public CloseWebSocketFrame(boolean bl, int n) {
        this(bl, n, Unpooled.buffer((int)0));
    }

    public CloseWebSocketFrame(boolean bl, int n, int n2, String string) {
        super(bl, n, CloseWebSocketFrame.newBinaryData(CloseWebSocketFrame.requireValidStatusCode(n2), string));
    }

    private static ByteBuf newBinaryData(int n, String string) {
        if (string == null) {
            string = "";
        }
        ByteBuf byteBuf = Unpooled.buffer((int)(2 + string.length()));
        byteBuf.writeShort(n);
        if (!string.isEmpty()) {
            byteBuf.writeCharSequence((CharSequence)string, CharsetUtil.UTF_8);
        }
        return byteBuf;
    }

    public CloseWebSocketFrame(boolean bl, int n, ByteBuf byteBuf) {
        super(bl, n, byteBuf);
    }

    public int statusCode() {
        ByteBuf byteBuf = this.content();
        if (byteBuf == null || byteBuf.readableBytes() < 2) {
            return -1;
        }
        ByteBuf byteBuf2 = byteBuf;
        return byteBuf2.getUnsignedShort(byteBuf2.readerIndex());
    }

    public String reasonText() {
        ByteBuf byteBuf = this.content();
        if (byteBuf == null || byteBuf.readableBytes() <= 2) {
            return "";
        }
        ByteBuf byteBuf2 = byteBuf;
        return byteBuf2.toString(byteBuf2.readerIndex() + 2, byteBuf.readableBytes() - 2, CharsetUtil.UTF_8);
    }

    @Override
    public CloseWebSocketFrame copy() {
        return (CloseWebSocketFrame)super.copy();
    }

    @Override
    public CloseWebSocketFrame duplicate() {
        return (CloseWebSocketFrame)super.duplicate();
    }

    @Override
    public CloseWebSocketFrame retainedDuplicate() {
        return (CloseWebSocketFrame)super.retainedDuplicate();
    }

    @Override
    public CloseWebSocketFrame replace(ByteBuf byteBuf) {
        return new CloseWebSocketFrame(this.isFinalFragment(), this.rsv(), byteBuf);
    }

    @Override
    public CloseWebSocketFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public CloseWebSocketFrame retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public CloseWebSocketFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public CloseWebSocketFrame touch(Object object) {
        super.touch(object);
        return this;
    }

    static int requireValidStatusCode(int n) {
        if (WebSocketCloseStatus.isValidStatusCode(n)) {
            return n;
        }
        throw new IllegalArgumentException("WebSocket close status code does NOT comply with RFC-6455: " + n);
    }
}

