/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectPool;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledDuplicatedByteBuf
extends AbstractPooledDerivedByteBuf {
    private static final ObjectPool<PooledDuplicatedByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledDuplicatedByteBuf>(){

        public final PooledDuplicatedByteBuf newObject(ObjectPool.Handle<PooledDuplicatedByteBuf> handle) {
            return new PooledDuplicatedByteBuf(handle);
        }
    });

    static PooledDuplicatedByteBuf newInstance(AbstractByteBuf abstractByteBuf, ByteBuf byteBuf, int n, int n2) {
        PooledDuplicatedByteBuf pooledDuplicatedByteBuf = (PooledDuplicatedByteBuf)RECYCLER.get();
        pooledDuplicatedByteBuf.init(abstractByteBuf, byteBuf, n, n2, ((ByteBuf)abstractByteBuf).maxCapacity());
        ((ByteBuf)pooledDuplicatedByteBuf).markReaderIndex();
        ((ByteBuf)pooledDuplicatedByteBuf).markWriterIndex();
        return pooledDuplicatedByteBuf;
    }

    private PooledDuplicatedByteBuf(ObjectPool.Handle<PooledDuplicatedByteBuf> handle) {
        super(handle);
    }

    @Override
    public final int capacity() {
        return this.unwrap().capacity();
    }

    @Override
    public final ByteBuf capacity(int n) {
        this.unwrap().capacity(n);
        return this;
    }

    @Override
    public final int arrayOffset() {
        return this.unwrap().arrayOffset();
    }

    @Override
    public final long memoryAddress() {
        return this.unwrap().memoryAddress();
    }

    @Override
    public final ByteBuffer nioBuffer(int n, int n2) {
        return this.unwrap().nioBuffer(n, n2);
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n, int n2) {
        return this.unwrap().nioBuffers(n, n2);
    }

    @Override
    public final ByteBuf copy(int n, int n2) {
        return this.unwrap().copy(n, n2);
    }

    @Override
    public final ByteBuf retainedSlice(int n, int n2) {
        return PooledSlicedByteBuf.newInstance(this.unwrap(), this, n, n2);
    }

    @Override
    public final ByteBuf duplicate() {
        return this.duplicate0().setIndex(((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        PooledDuplicatedByteBuf pooledDuplicatedByteBuf = this;
        return PooledDuplicatedByteBuf.newInstance(this.unwrap(), pooledDuplicatedByteBuf, ((ByteBuf)pooledDuplicatedByteBuf).readerIndex(), ((ByteBuf)this).writerIndex());
    }

    @Override
    public final byte getByte(int n) {
        return ((ByteBuf)this.unwrap()).getByte(n);
    }

    @Override
    protected final byte _getByte(int n) {
        return this.unwrap()._getByte(n);
    }

    @Override
    public final short getShort(int n) {
        return ((ByteBuf)this.unwrap()).getShort(n);
    }

    @Override
    protected final short _getShort(int n) {
        return this.unwrap()._getShort(n);
    }

    @Override
    public final short getShortLE(int n) {
        return ((ByteBuf)this.unwrap()).getShortLE(n);
    }

    @Override
    protected final short _getShortLE(int n) {
        return this.unwrap()._getShortLE(n);
    }

    @Override
    public final int getUnsignedMedium(int n) {
        return ((ByteBuf)this.unwrap()).getUnsignedMedium(n);
    }

    @Override
    protected final int _getUnsignedMedium(int n) {
        return this.unwrap()._getUnsignedMedium(n);
    }

    @Override
    public final int getUnsignedMediumLE(int n) {
        return ((ByteBuf)this.unwrap()).getUnsignedMediumLE(n);
    }

    @Override
    protected final int _getUnsignedMediumLE(int n) {
        return this.unwrap()._getUnsignedMediumLE(n);
    }

    @Override
    public final int getInt(int n) {
        return ((ByteBuf)this.unwrap()).getInt(n);
    }

    @Override
    protected final int _getInt(int n) {
        return this.unwrap()._getInt(n);
    }

    @Override
    public final int getIntLE(int n) {
        return ((ByteBuf)this.unwrap()).getIntLE(n);
    }

    @Override
    protected final int _getIntLE(int n) {
        return this.unwrap()._getIntLE(n);
    }

    @Override
    public final long getLong(int n) {
        return ((ByteBuf)this.unwrap()).getLong(n);
    }

    @Override
    protected final long _getLong(int n) {
        return this.unwrap()._getLong(n);
    }

    @Override
    public final long getLongLE(int n) {
        return ((ByteBuf)this.unwrap()).getLongLE(n);
    }

    @Override
    protected final long _getLongLE(int n) {
        return this.unwrap()._getLongLE(n);
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.unwrap().getBytes(n, byteBuf, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.unwrap().getBytes(n, byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        this.unwrap().getBytes(n, byteBuffer);
        return this;
    }

    @Override
    public final ByteBuf setByte(int n, int n2) {
        ((ByteBuf)this.unwrap()).setByte(n, n2);
        return this;
    }

    @Override
    protected final void _setByte(int n, int n2) {
        this.unwrap()._setByte(n, n2);
    }

    @Override
    public final ByteBuf setShort(int n, int n2) {
        ((ByteBuf)this.unwrap()).setShort(n, n2);
        return this;
    }

    @Override
    protected final void _setShort(int n, int n2) {
        this.unwrap()._setShort(n, n2);
    }

    @Override
    public final ByteBuf setShortLE(int n, int n2) {
        ((ByteBuf)this.unwrap()).setShortLE(n, n2);
        return this;
    }

    @Override
    protected final void _setShortLE(int n, int n2) {
        this.unwrap()._setShortLE(n, n2);
    }

    @Override
    public final ByteBuf setMedium(int n, int n2) {
        ((ByteBuf)this.unwrap()).setMedium(n, n2);
        return this;
    }

    @Override
    protected final void _setMedium(int n, int n2) {
        this.unwrap()._setMedium(n, n2);
    }

    @Override
    public final ByteBuf setMediumLE(int n, int n2) {
        ((ByteBuf)this.unwrap()).setMediumLE(n, n2);
        return this;
    }

    @Override
    protected final void _setMediumLE(int n, int n2) {
        this.unwrap()._setMediumLE(n, n2);
    }

    @Override
    public final ByteBuf setInt(int n, int n2) {
        ((ByteBuf)this.unwrap()).setInt(n, n2);
        return this;
    }

    @Override
    protected final void _setInt(int n, int n2) {
        this.unwrap()._setInt(n, n2);
    }

    @Override
    public final ByteBuf setIntLE(int n, int n2) {
        ((ByteBuf)this.unwrap()).setIntLE(n, n2);
        return this;
    }

    @Override
    protected final void _setIntLE(int n, int n2) {
        this.unwrap()._setIntLE(n, n2);
    }

    @Override
    public final ByteBuf setLong(int n, long l) {
        ((ByteBuf)this.unwrap()).setLong(n, l);
        return this;
    }

    @Override
    protected final void _setLong(int n, long l) {
        this.unwrap()._setLong(n, l);
    }

    @Override
    public final ByteBuf setLongLE(int n, long l) {
        ((ByteBuf)this.unwrap()).setLongLE(n, l);
        return this;
    }

    @Override
    protected final void _setLongLE(int n, long l) {
        ((ByteBuf)this.unwrap()).setLongLE(n, l);
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        this.unwrap().setBytes(n, byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.unwrap().setBytes(n, byteBuf, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        this.unwrap().setBytes(n, byteBuffer);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        this.unwrap().getBytes(n, outputStream, n2);
        return this;
    }

    @Override
    public final int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        return this.unwrap().getBytes(n, gatheringByteChannel, n2);
    }

    @Override
    public final int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        return this.unwrap().getBytes(n, fileChannel, l, n2);
    }

    @Override
    public final int setBytes(int n, InputStream inputStream, int n2) {
        return this.unwrap().setBytes(n, inputStream, n2);
    }

    @Override
    public final int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        return this.unwrap().setBytes(n, scatteringByteChannel, n2);
    }

    @Override
    public final int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        return this.unwrap().setBytes(n, fileChannel, l, n2);
    }

    @Override
    public final int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
        return ((ByteBuf)this.unwrap()).forEachByte(n, n2, byteProcessor);
    }

    @Override
    public final int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
        return ((ByteBuf)this.unwrap()).forEachByteDesc(n, n2, byteProcessor);
    }
}

