/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf;
import io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectPool;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledSlicedByteBuf
extends AbstractPooledDerivedByteBuf {
    private static final ObjectPool<PooledSlicedByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledSlicedByteBuf>(){

        public final PooledSlicedByteBuf newObject(ObjectPool.Handle<PooledSlicedByteBuf> handle) {
            return new PooledSlicedByteBuf(handle);
        }
    });
    int adjustment;

    static PooledSlicedByteBuf newInstance(AbstractByteBuf abstractByteBuf, ByteBuf byteBuf, int n, int n2) {
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(n, n2, abstractByteBuf);
        return PooledSlicedByteBuf.newInstance0(abstractByteBuf, byteBuf, n, n2);
    }

    private static PooledSlicedByteBuf newInstance0(AbstractByteBuf abstractByteBuf, ByteBuf byteBuf, int n, int n2) {
        PooledSlicedByteBuf pooledSlicedByteBuf = (PooledSlicedByteBuf)RECYCLER.get();
        int n3 = n2;
        pooledSlicedByteBuf.init(abstractByteBuf, byteBuf, 0, n3, n3);
        pooledSlicedByteBuf.discardMarks();
        pooledSlicedByteBuf.adjustment = n;
        return pooledSlicedByteBuf;
    }

    private PooledSlicedByteBuf(ObjectPool.Handle<PooledSlicedByteBuf> handle) {
        super(handle);
    }

    @Override
    public final int capacity() {
        return ((ByteBuf)this).maxCapacity();
    }

    @Override
    public final ByteBuf capacity(int n) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public final int arrayOffset() {
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        return pooledSlicedByteBuf.idx(pooledSlicedByteBuf.unwrap().arrayOffset());
    }

    @Override
    public final long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    @Override
    public final ByteBuffer nioBuffer(int n, int n2) {
        this.checkIndex0(n, n2);
        return this.unwrap().nioBuffer(this.idx(n), n2);
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n, int n2) {
        this.checkIndex0(n, n2);
        return this.unwrap().nioBuffers(this.idx(n), n2);
    }

    @Override
    public final ByteBuf copy(int n, int n2) {
        this.checkIndex0(n, n2);
        return this.unwrap().copy(this.idx(n), n2);
    }

    @Override
    public final ByteBuf slice(int n, int n2) {
        this.checkIndex0(n, n2);
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        return super.slice(pooledSlicedByteBuf.idx(n), n2);
    }

    @Override
    public final ByteBuf retainedSlice(int n, int n2) {
        this.checkIndex0(n, n2);
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        return PooledSlicedByteBuf.newInstance0(this.unwrap(), pooledSlicedByteBuf, pooledSlicedByteBuf.idx(n), n2);
    }

    @Override
    public final ByteBuf duplicate() {
        return ((ByteBuf)this).slice(0, ((ByteBuf)this).capacity()).setIndex(((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return ((ByteBuf)this).retainedSlice(0, ((ByteBuf)this).capacity()).setIndex(((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
    }

    @Override
    public final byte getByte(int n) {
        this.checkIndex0(n, 1);
        return ((ByteBuf)this.unwrap()).getByte(this.idx(n));
    }

    @Override
    protected final byte _getByte(int n) {
        return this.unwrap()._getByte(this.idx(n));
    }

    @Override
    public final short getShort(int n) {
        this.checkIndex0(n, 2);
        return ((ByteBuf)this.unwrap()).getShort(this.idx(n));
    }

    @Override
    protected final short _getShort(int n) {
        return this.unwrap()._getShort(this.idx(n));
    }

    @Override
    public final short getShortLE(int n) {
        this.checkIndex0(n, 2);
        return ((ByteBuf)this.unwrap()).getShortLE(this.idx(n));
    }

    @Override
    protected final short _getShortLE(int n) {
        return this.unwrap()._getShortLE(this.idx(n));
    }

    @Override
    public final int getUnsignedMedium(int n) {
        this.checkIndex0(n, 3);
        return ((ByteBuf)this.unwrap()).getUnsignedMedium(this.idx(n));
    }

    @Override
    protected final int _getUnsignedMedium(int n) {
        return this.unwrap()._getUnsignedMedium(this.idx(n));
    }

    @Override
    public final int getUnsignedMediumLE(int n) {
        this.checkIndex0(n, 3);
        return ((ByteBuf)this.unwrap()).getUnsignedMediumLE(this.idx(n));
    }

    @Override
    protected final int _getUnsignedMediumLE(int n) {
        return this.unwrap()._getUnsignedMediumLE(this.idx(n));
    }

    @Override
    public final int getInt(int n) {
        this.checkIndex0(n, 4);
        return ((ByteBuf)this.unwrap()).getInt(this.idx(n));
    }

    @Override
    protected final int _getInt(int n) {
        return this.unwrap()._getInt(this.idx(n));
    }

    @Override
    public final int getIntLE(int n) {
        this.checkIndex0(n, 4);
        return ((ByteBuf)this.unwrap()).getIntLE(this.idx(n));
    }

    @Override
    protected final int _getIntLE(int n) {
        return this.unwrap()._getIntLE(this.idx(n));
    }

    @Override
    public final long getLong(int n) {
        this.checkIndex0(n, 8);
        return ((ByteBuf)this.unwrap()).getLong(this.idx(n));
    }

    @Override
    protected final long _getLong(int n) {
        return this.unwrap()._getLong(this.idx(n));
    }

    @Override
    public final long getLongLE(int n) {
        this.checkIndex0(n, 8);
        return ((ByteBuf)this.unwrap()).getLongLE(this.idx(n));
    }

    @Override
    protected final long _getLongLE(int n) {
        return this.unwrap()._getLongLE(this.idx(n));
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkIndex0(n, n3);
        this.unwrap().getBytes(this.idx(n), byteBuf, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkIndex0(n, n3);
        this.unwrap().getBytes(this.idx(n), byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        this.checkIndex0(n, byteBuffer.remaining());
        this.unwrap().getBytes(this.idx(n), byteBuffer);
        return this;
    }

    @Override
    public final ByteBuf setByte(int n, int n2) {
        this.checkIndex0(n, 1);
        ((ByteBuf)this.unwrap()).setByte(this.idx(n), n2);
        return this;
    }

    @Override
    protected final void _setByte(int n, int n2) {
        this.unwrap()._setByte(this.idx(n), n2);
    }

    @Override
    public final ByteBuf setShort(int n, int n2) {
        this.checkIndex0(n, 2);
        ((ByteBuf)this.unwrap()).setShort(this.idx(n), n2);
        return this;
    }

    @Override
    protected final void _setShort(int n, int n2) {
        this.unwrap()._setShort(this.idx(n), n2);
    }

    @Override
    public final ByteBuf setShortLE(int n, int n2) {
        this.checkIndex0(n, 2);
        ((ByteBuf)this.unwrap()).setShortLE(this.idx(n), n2);
        return this;
    }

    @Override
    protected final void _setShortLE(int n, int n2) {
        this.unwrap()._setShortLE(this.idx(n), n2);
    }

    @Override
    public final ByteBuf setMedium(int n, int n2) {
        this.checkIndex0(n, 3);
        ((ByteBuf)this.unwrap()).setMedium(this.idx(n), n2);
        return this;
    }

    @Override
    protected final void _setMedium(int n, int n2) {
        this.unwrap()._setMedium(this.idx(n), n2);
    }

    @Override
    public final ByteBuf setMediumLE(int n, int n2) {
        this.checkIndex0(n, 3);
        ((ByteBuf)this.unwrap()).setMediumLE(this.idx(n), n2);
        return this;
    }

    @Override
    protected final void _setMediumLE(int n, int n2) {
        this.unwrap()._setMediumLE(this.idx(n), n2);
    }

    @Override
    public final ByteBuf setInt(int n, int n2) {
        this.checkIndex0(n, 4);
        ((ByteBuf)this.unwrap()).setInt(this.idx(n), n2);
        return this;
    }

    @Override
    protected final void _setInt(int n, int n2) {
        this.unwrap()._setInt(this.idx(n), n2);
    }

    @Override
    public final ByteBuf setIntLE(int n, int n2) {
        this.checkIndex0(n, 4);
        ((ByteBuf)this.unwrap()).setIntLE(this.idx(n), n2);
        return this;
    }

    @Override
    protected final void _setIntLE(int n, int n2) {
        this.unwrap()._setIntLE(this.idx(n), n2);
    }

    @Override
    public final ByteBuf setLong(int n, long l) {
        this.checkIndex0(n, 8);
        ((ByteBuf)this.unwrap()).setLong(this.idx(n), l);
        return this;
    }

    @Override
    protected final void _setLong(int n, long l) {
        this.unwrap()._setLong(this.idx(n), l);
    }

    @Override
    public final ByteBuf setLongLE(int n, long l) {
        this.checkIndex0(n, 8);
        ((ByteBuf)this.unwrap()).setLongLE(this.idx(n), l);
        return this;
    }

    @Override
    protected final void _setLongLE(int n, long l) {
        ((ByteBuf)this.unwrap()).setLongLE(this.idx(n), l);
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkIndex0(n, n3);
        this.unwrap().setBytes(this.idx(n), byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkIndex0(n, n3);
        this.unwrap().setBytes(this.idx(n), byteBuf, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        this.checkIndex0(n, byteBuffer.remaining());
        this.unwrap().setBytes(this.idx(n), byteBuffer);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        this.checkIndex0(n, n2);
        this.unwrap().getBytes(this.idx(n), outputStream, n2);
        return this;
    }

    @Override
    public final int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkIndex0(n, n2);
        return this.unwrap().getBytes(this.idx(n), gatheringByteChannel, n2);
    }

    @Override
    public final int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        this.checkIndex0(n, n2);
        return this.unwrap().getBytes(this.idx(n), fileChannel, l, n2);
    }

    @Override
    public final int setBytes(int n, InputStream inputStream, int n2) {
        this.checkIndex0(n, n2);
        return this.unwrap().setBytes(this.idx(n), inputStream, n2);
    }

    @Override
    public final int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        this.checkIndex0(n, n2);
        return this.unwrap().setBytes(this.idx(n), scatteringByteChannel, n2);
    }

    @Override
    public final int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        this.checkIndex0(n, n2);
        return this.unwrap().setBytes(this.idx(n), fileChannel, l, n2);
    }

    @Override
    public final int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
        this.checkIndex0(n, n2);
        n = ((ByteBuf)this.unwrap()).forEachByte(this.idx(n), n2, byteProcessor);
        if (n < this.adjustment) {
            return -1;
        }
        return n - this.adjustment;
    }

    @Override
    public final int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
        this.checkIndex0(n, n2);
        n = ((ByteBuf)this.unwrap()).forEachByteDesc(this.idx(n), n2, byteProcessor);
        if (n < this.adjustment) {
            return -1;
        }
        return n - this.adjustment;
    }

    private int idx(int n) {
        return n + this.adjustment;
    }
}

