/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueDomainSocketChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.kqueue.Native;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.UnixChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.TimeUnit;

abstract class AbstractKQueueChannel
extends AbstractChannel
implements UnixChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private ChannelPromise connectPromise;
    private Future<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    final BsdSocket socket;
    private boolean readFilterEnabled;
    private boolean writeFilterEnabled;
    boolean readReadyRunnablePending;
    boolean inputClosedSeenErrorOnRead;
    protected volatile boolean active;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;

    AbstractKQueueChannel(Channel channel, BsdSocket bsdSocket, boolean bl) {
        super(channel);
        this.socket = (BsdSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)bsdSocket), (String)"fd"));
        this.active = bl;
        if (bl) {
            this.local = bsdSocket.localAddress();
            this.remote = bsdSocket.remoteAddress();
        }
    }

    AbstractKQueueChannel(Channel channel, BsdSocket bsdSocket, SocketAddress socketAddress) {
        super(channel);
        this.socket = (BsdSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)bsdSocket), (String)"fd"));
        this.active = true;
        this.remote = socketAddress;
        this.local = bsdSocket.localAddress();
    }

    static boolean isSoErrorZero(BsdSocket bsdSocket) {
        try {
            return bsdSocket.getSoError() == 0;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public final FileDescriptor fd() {
        return this.socket;
    }

    public boolean isActive() {
        return this.active;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected void doClose() {
        this.active = false;
        this.inputClosedSeenErrorOnRead = true;
        this.socket.close();
    }

    protected void doDisconnect() {
        this.doClose();
    }

    void resetCachedAddresses() {
        this.local = this.socket.localAddress();
        this.remote = this.socket.remoteAddress();
    }

    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof KQueueEventLoop;
    }

    public boolean isOpen() {
        return this.socket.isOpen();
    }

    protected void doDeregister() {
        ((KQueueEventLoop)this.eventLoop()).remove(this);
        this.readFilterEnabled = false;
        this.writeFilterEnabled = false;
    }

    void unregisterFilters() {
        this.readFilter(false);
        this.writeFilter(false);
        this.clearRdHup0();
    }

    private void clearRdHup0() {
        this.evSet0(Native.EVFILT_SOCK, Native.EV_DELETE_DISABLE, Native.NOTE_RDHUP);
    }

    protected final void doBeginRead() {
        AbstractKQueueUnsafe abstractKQueueUnsafe = (AbstractKQueueUnsafe)this.unsafe();
        ((AbstractKQueueUnsafe)this.unsafe()).readPending = true;
        this.readFilter(true);
        if (abstractKQueueUnsafe.maybeMoreDataToRead) {
            abstractKQueueUnsafe.executeReadReadyRunnable((ChannelConfig)this.config());
        }
    }

    protected void doRegister() {
        this.readReadyRunnablePending = false;
        ((KQueueEventLoop)this.eventLoop()).add(this);
        if (this.writeFilterEnabled) {
            this.evSet0(Native.EVFILT_WRITE, Native.EV_ADD_CLEAR_ENABLE);
        }
        if (this.readFilterEnabled) {
            this.evSet0(Native.EVFILT_READ, Native.EV_ADD_CLEAR_ENABLE);
        }
        this.evSet0(Native.EVFILT_SOCK, Native.EV_ADD, Native.NOTE_RDHUP);
    }

    protected abstract AbstractKQueueUnsafe newUnsafe();

    public abstract KQueueChannelConfig config();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return this.newDirectBuffer(byteBuf2, byteBuf2);
    }

    protected final ByteBuf newDirectBuffer(Object object, ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            ReferenceCountUtil.release((Object)object);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            return AbstractKQueueChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n);
        }
        ByteBuf byteBuf2 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf2 == null) {
            return AbstractKQueueChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n);
        }
        ByteBuf byteBuf3 = byteBuf;
        byteBuf2.writeBytes(byteBuf3, byteBuf3.readerIndex(), n);
        ReferenceCountUtil.safeRelease((Object)object);
        return byteBuf2;
    }

    private static ByteBuf newDirectBuffer0(Object object, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, int n) {
        byteBufAllocator = byteBufAllocator.directBuffer(n);
        ByteBuf byteBuf2 = byteBuf;
        byteBufAllocator.writeBytes(byteBuf2, byteBuf2.readerIndex(), n);
        ReferenceCountUtil.safeRelease((Object)object);
        return byteBufAllocator;
    }

    protected static void checkResolvable(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final int doReadBytes(ByteBuf byteBuf) {
        int n;
        int n2 = byteBuf.writerIndex();
        this.unsafe().recvBufAllocHandle().attemptedBytesRead(byteBuf.writableBytes());
        if (byteBuf.hasMemoryAddress()) {
            n = this.socket.readAddress(byteBuf.memoryAddress(), n2, byteBuf.capacity());
        } else {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = byteBuf.internalNioBuffer(n2, byteBuf.writableBytes());
            n = this.socket.read(byteBuffer2, byteBuffer2.position(), byteBuffer.limit());
        }
        if (n > 0) {
            byteBuf.writerIndex(n2 + n);
        }
        return n;
    }

    protected final int doWriteBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf object) {
        if (object.hasMemoryAddress()) {
            int n = this.socket.writeAddress(object.memoryAddress(), object.readerIndex(), object.writerIndex());
            if (n > 0) {
                channelOutboundBuffer.removeBytes((long)n);
                return 1;
            }
        } else {
            ByteBuffer byteBuffer;
            if (object.nioBufferCount() == 1) {
                ByteBuf byteBuf = object;
                byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), object.readableBytes());
            } else {
                byteBuffer = object.nioBuffer();
            }
            Object object2 = object = byteBuffer;
            int n = this.socket.write((ByteBuffer)object2, ((Buffer)object2).position(), ((Buffer)object).limit());
            if (n > 0) {
                Object object3 = object;
                ((ByteBuffer)object3).position(((Buffer)object3).position() + n);
                channelOutboundBuffer.removeBytes((long)n);
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    final boolean shouldBreakReadReady(ChannelConfig channelConfig) {
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractKQueueChannel.isAllowHalfClosure(channelConfig));
    }

    private static boolean isAllowHalfClosure(ChannelConfig channelConfig) {
        if (channelConfig instanceof KQueueDomainSocketChannelConfig) {
            return ((KQueueDomainSocketChannelConfig)channelConfig).isAllowHalfClosure();
        }
        return channelConfig instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    /*
     * Enabled aggressive block sorting
     */
    final void clearReadFilter() {
        if (!this.isRegistered()) {
            this.readFilterEnabled = false;
            return;
        }
        EventLoop eventLoop = this.eventLoop();
        final AbstractKQueueUnsafe abstractKQueueUnsafe = (AbstractKQueueUnsafe)this.unsafe();
        if (eventLoop.inEventLoop()) {
            abstractKQueueUnsafe.clearReadFilter0();
            return;
        }
        eventLoop.execute(new Runnable(){

            @Override
            public void run() {
                if (!abstractKQueueUnsafe.readPending && !AbstractKQueueChannel.this.config().isAutoRead()) {
                    abstractKQueueUnsafe.clearReadFilter0();
                }
            }
        });
    }

    void readFilter(boolean bl) {
        if (this.readFilterEnabled != bl) {
            this.readFilterEnabled = bl;
            this.evSet(Native.EVFILT_READ, bl ? Native.EV_ADD_CLEAR_ENABLE : Native.EV_DELETE_DISABLE);
        }
    }

    void writeFilter(boolean bl) {
        if (this.writeFilterEnabled != bl) {
            this.writeFilterEnabled = bl;
            this.evSet(Native.EVFILT_WRITE, bl ? Native.EV_ADD_CLEAR_ENABLE : Native.EV_DELETE_DISABLE);
        }
    }

    private void evSet(short s, short s2) {
        if (this.isRegistered()) {
            this.evSet0(s, s2);
        }
    }

    private void evSet0(short s, short s2) {
        this.evSet0(s, s2, 0);
    }

    private void evSet0(short s, short s2, int n) {
        if (this.isOpen()) {
            ((KQueueEventLoop)this.eventLoop()).evSet(this, s, s2, n);
        }
    }

    protected void doBind(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            AbstractKQueueChannel.checkResolvable((InetSocketAddress)socketAddress);
        }
        this.socket.bind(socketAddress);
        this.local = this.socket.localAddress();
    }

    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        boolean bl;
        InetSocketAddress inetSocketAddress;
        if (socketAddress2 instanceof InetSocketAddress) {
            AbstractKQueueChannel.checkResolvable((InetSocketAddress)socketAddress2);
        }
        if ((inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null) != null) {
            AbstractKQueueChannel.checkResolvable(inetSocketAddress);
        }
        if (this.remote != null) {
            throw new AlreadyConnectedException();
        }
        if (socketAddress2 != null) {
            this.socket.bind(socketAddress2);
        }
        if (bl = this.doConnect0(socketAddress, socketAddress2)) {
            this.remote = inetSocketAddress == null ? socketAddress : UnixChannelUtil.computeRemoteAddr((InetSocketAddress)inetSocketAddress, (InetSocketAddress)this.socket.remoteAddress());
        }
        this.local = this.socket.localAddress();
        return bl;
    }

    protected boolean doConnect0(SocketAddress socketAddress, SocketAddress socketAddress2) {
        boolean bl = false;
        try {
            boolean bl2 = this.socket.connect(socketAddress);
            if (!bl2) {
                this.writeFilter(true);
            }
            bl = true;
            return bl2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.doClose();
            }
            throw throwable;
        }
    }

    protected SocketAddress localAddress0() {
        return this.local;
    }

    protected SocketAddress remoteAddress0() {
        return this.remote;
    }

    public abstract class AbstractKQueueUnsafe
    extends AbstractChannel.AbstractUnsafe {
        boolean readPending;
        boolean maybeMoreDataToRead;
        private KQueueRecvByteAllocatorHandle allocHandle;
        private final Runnable readReadyRunnable;

        public AbstractKQueueUnsafe() {
            super((AbstractChannel)AbstractKQueueChannel.this);
            this.readReadyRunnable = new Runnable(){

                @Override
                public void run() {
                    AbstractKQueueChannel.this.readReadyRunnablePending = false;
                    AbstractKQueueUnsafe.this.readReady(AbstractKQueueUnsafe.this.recvBufAllocHandle());
                }
            };
        }

        final void readReady(long l) {
            KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle = this.recvBufAllocHandle();
            kQueueRecvByteAllocatorHandle.numberBytesPending(l);
            this.readReady(kQueueRecvByteAllocatorHandle);
        }

        abstract void readReady(KQueueRecvByteAllocatorHandle var1);

        final void readReadyBefore() {
            this.maybeMoreDataToRead = false;
        }

        final void readReadyFinally(ChannelConfig channelConfig) {
            this.maybeMoreDataToRead = this.allocHandle.maybeMoreDataToRead();
            if (this.allocHandle.isReadEOF() || this.readPending && this.maybeMoreDataToRead) {
                this.executeReadReadyRunnable(channelConfig);
                return;
            }
            if (!this.readPending && !channelConfig.isAutoRead()) {
                this.clearReadFilter0();
            }
        }

        final boolean failConnectPromise(Throwable throwable) {
            if (AbstractKQueueChannel.this.connectPromise != null) {
                ChannelPromise channelPromise = AbstractKQueueChannel.this.connectPromise;
                AbstractKQueueChannel.this.connectPromise = null;
                if (channelPromise.tryFailure(throwable instanceof ConnectException ? throwable : new ConnectException("failed to connect").initCause(throwable))) {
                    this.closeIfClosed();
                    return true;
                }
            }
            return false;
        }

        final void writeReady() {
            if (AbstractKQueueChannel.this.connectPromise != null) {
                this.finishConnect();
                return;
            }
            if (!AbstractKQueueChannel.this.socket.isOutputShutdown()) {
                super.flush0();
            }
        }

        void shutdownInput(boolean bl) {
            if (bl && AbstractKQueueChannel.this.connectPromise != null) {
                this.finishConnect();
            }
            if (!AbstractKQueueChannel.this.socket.isInputShutdown()) {
                if (AbstractKQueueChannel.isAllowHalfClosure((ChannelConfig)AbstractKQueueChannel.this.config())) {
                    try {
                        AbstractKQueueChannel.this.socket.shutdown(true, false);
                    }
                    catch (IOException iOException) {
                        this.fireEventAndClose(ChannelInputShutdownEvent.INSTANCE);
                        return;
                    }
                    catch (NotYetConnectedException notYetConnectedException) {}
                    this.clearReadFilter0();
                    AbstractKQueueChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
                    return;
                }
                AbstractKQueueUnsafe abstractKQueueUnsafe = this;
                abstractKQueueUnsafe.close(abstractKQueueUnsafe.voidPromise());
                return;
            }
            if (!bl && !AbstractKQueueChannel.this.inputClosedSeenErrorOnRead) {
                AbstractKQueueChannel.this.inputClosedSeenErrorOnRead = true;
                AbstractKQueueChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownReadComplete.INSTANCE);
            }
        }

        final void readEOF() {
            KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle = this.recvBufAllocHandle();
            kQueueRecvByteAllocatorHandle.readEOF();
            if (AbstractKQueueChannel.this.isActive()) {
                this.readReady(kQueueRecvByteAllocatorHandle);
            } else {
                this.shutdownInput(true);
            }
            AbstractKQueueChannel.this.clearRdHup0();
        }

        public KQueueRecvByteAllocatorHandle recvBufAllocHandle() {
            if (this.allocHandle == null) {
                this.allocHandle = new KQueueRecvByteAllocatorHandle((RecvByteBufAllocator.ExtendedHandle)super.recvBufAllocHandle());
            }
            return this.allocHandle;
        }

        protected final void flush0() {
            if (!AbstractKQueueChannel.this.writeFilterEnabled) {
                super.flush0();
            }
        }

        final void executeReadReadyRunnable(ChannelConfig channelConfig) {
            if (AbstractKQueueChannel.this.readReadyRunnablePending || !AbstractKQueueChannel.this.isActive() || AbstractKQueueChannel.this.shouldBreakReadReady(channelConfig)) {
                return;
            }
            AbstractKQueueChannel.this.readReadyRunnablePending = true;
            AbstractKQueueChannel.this.eventLoop().execute(this.readReadyRunnable);
        }

        protected final void clearReadFilter0() {
            assert (AbstractKQueueChannel.this.eventLoop().inEventLoop());
            try {
                this.readPending = false;
                AbstractKQueueChannel.this.readFilter(false);
                return;
            }
            catch (IOException iOException) {
                AbstractKQueueChannel.this.pipeline().fireExceptionCaught((Throwable)iOException);
                AbstractKQueueChannel.this.unsafe().close(AbstractKQueueChannel.this.unsafe().voidPromise());
                return;
            }
        }

        private void fireEventAndClose(Object object) {
            AbstractKQueueChannel.this.pipeline().fireUserEventTriggered(object);
            AbstractKQueueUnsafe abstractKQueueUnsafe = this;
            abstractKQueueUnsafe.close(abstractKQueueUnsafe.voidPromise());
        }

        public void connect(final SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            if (channelPromise.isDone() || !this.ensureOpen(channelPromise)) {
                return;
            }
            try {
                if (AbstractKQueueChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean bl = AbstractKQueueChannel.this.isActive();
                if (!AbstractKQueueChannel.this.doConnect(socketAddress, socketAddress2)) {
                    AbstractKQueueChannel.this.connectPromise = channelPromise;
                    AbstractKQueueChannel.this.requestedRemoteAddress = socketAddress;
                    final int n = AbstractKQueueChannel.this.config().getConnectTimeoutMillis();
                    if (n > 0) {
                        AbstractKQueueChannel.this.connectTimeoutFuture = (Future)AbstractKQueueChannel.this.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ChannelPromise channelPromise = AbstractKQueueChannel.this.connectPromise;
                                if (channelPromise != null && !channelPromise.isDone() && channelPromise.tryFailure((Throwable)new ConnectTimeoutException("connection timed out after " + n + " ms: " + socketAddress))) {
                                    AbstractKQueueUnsafe.this.close(AbstractKQueueUnsafe.this.voidPromise());
                                }
                            }
                        }, (long)n, TimeUnit.MILLISECONDS);
                    }
                    channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) {
                            if (channelFuture.isCancelled()) {
                                if (AbstractKQueueChannel.this.connectTimeoutFuture != null) {
                                    AbstractKQueueChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractKQueueChannel.this.connectPromise = null;
                                AbstractKQueueUnsafe.this.close(AbstractKQueueUnsafe.this.voidPromise());
                            }
                        }
                    });
                    return;
                }
                this.fulfillConnectPromise(channelPromise, bl);
            }
            catch (Throwable throwable) {
                this.closeIfClosed();
                channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl) {
            if (channelPromise == null) {
                return;
            }
            AbstractKQueueChannel.this.active = true;
            boolean bl2 = AbstractKQueueChannel.this.isActive();
            boolean bl3 = channelPromise.trySuccess();
            if (!bl && bl2) {
                AbstractKQueueChannel.this.pipeline().fireChannelActive();
            }
            if (!bl3) {
                AbstractKQueueUnsafe abstractKQueueUnsafe = this;
                abstractKQueueUnsafe.close(abstractKQueueUnsafe.voidPromise());
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
            if (channelPromise == null) {
                return;
            }
            channelPromise.tryFailure(throwable);
            this.closeIfClosed();
        }

        private void finishConnect() {
            assert (AbstractKQueueChannel.this.eventLoop().inEventLoop());
            try {
                boolean bl = AbstractKQueueChannel.this.isActive();
                if (!this.doFinishConnect()) {
                    return;
                }
                AbstractKQueueUnsafe abstractKQueueUnsafe = this;
                abstractKQueueUnsafe.fulfillConnectPromise(abstractKQueueUnsafe.AbstractKQueueChannel.this.connectPromise, bl);
                return;
            }
            catch (Throwable throwable) {
                AbstractKQueueUnsafe abstractKQueueUnsafe = this;
                abstractKQueueUnsafe.fulfillConnectPromise(abstractKQueueUnsafe.AbstractKQueueChannel.this.connectPromise, this.annotateConnectException(throwable, AbstractKQueueChannel.this.requestedRemoteAddress));
                return;
            }
            finally {
                if (AbstractKQueueChannel.this.connectTimeoutFuture != null) {
                    AbstractKQueueChannel.this.connectTimeoutFuture.cancel(false);
                }
                AbstractKQueueChannel.this.connectPromise = null;
            }
        }

        private boolean doFinishConnect() {
            if (AbstractKQueueChannel.this.socket.finishConnect()) {
                AbstractKQueueChannel.this.writeFilter(false);
                if (AbstractKQueueChannel.this.requestedRemoteAddress instanceof InetSocketAddress) {
                    AbstractKQueueChannel.this.remote = UnixChannelUtil.computeRemoteAddr((InetSocketAddress)((InetSocketAddress)AbstractKQueueChannel.this.requestedRemoteAddress), (InetSocketAddress)AbstractKQueueChannel.this.socket.remoteAddress());
                }
                AbstractKQueueChannel.this.requestedRemoteAddress = null;
                return true;
            }
            AbstractKQueueChannel.this.writeFilter(true);
            return false;
        }
    }
}

