/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.InitiationListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;

public final class Socks5BytestreamManager
extends Manager
implements BytestreamManager {
    private static final String SESSION_ID_PREFIX = "js5_";
    private static final Map<XMPPConnection, Socks5BytestreamManager> managers;
    private final Map<i, BytestreamListener> userListeners = new ConcurrentHashMap<i, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private int targetResponseTimeout = 10000;
    private int proxyConnectionTimeout = 10000;
    private final Set<i> proxyBlacklist = Collections.synchronizedSet(new HashSet());
    private i lastWorkingProxy;
    private boolean proxyPrioritizationEnabled = true;
    private boolean annouceLocalStreamHost = true;
    private final List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized Socks5BytestreamManager getBytestreamManager(XMPPConnection xMPPConnection) {
        if (xMPPConnection == null) {
            return null;
        }
        Socks5BytestreamManager socks5BytestreamManager = managers.get(xMPPConnection);
        if (socks5BytestreamManager == null) {
            socks5BytestreamManager = new Socks5BytestreamManager(xMPPConnection);
            managers.put(xMPPConnection, socks5BytestreamManager);
        }
        return socks5BytestreamManager;
    }

    private Socks5BytestreamManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.initiationListener = new InitiationListener(this);
        this.activate();
    }

    @Override
    public final void addIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.add(bytestreamListener);
    }

    @Override
    public final void removeIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.remove(bytestreamListener);
    }

    @Override
    public final void addIncomingBytestreamListener(BytestreamListener bytestreamListener, i i2) {
        this.userListeners.put(i2, bytestreamListener);
    }

    @Override
    public final void removeIncomingBytestreamListener(i i2) {
        this.userListeners.remove(i2);
    }

    public final void ignoreBytestreamRequestOnce(String string) {
        this.ignoredBytestreamRequests.add(string);
    }

    public final synchronized void disableService() {
        Object object = this.connection();
        object.unregisterIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.initiationListener.shutdown();
        this.allRequestListeners.clear();
        this.userListeners.clear();
        this.lastWorkingProxy = null;
        this.proxyBlacklist.clear();
        this.ignoredBytestreamRequests.clear();
        managers.remove(object);
        if (managers.size() == 0) {
            Socks5Proxy.getSocks5Proxy().stop();
        }
        if ((object = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)object)) != null) {
            ((ServiceDiscoveryManager)((Object)object)).removeFeature("http://jabber.org/protocol/bytestreams");
        }
    }

    public final int getTargetResponseTimeout() {
        if (this.targetResponseTimeout <= 0) {
            this.targetResponseTimeout = 10000;
        }
        return this.targetResponseTimeout;
    }

    public final void setTargetResponseTimeout(int n) {
        this.targetResponseTimeout = n;
    }

    public final int getProxyConnectionTimeout() {
        if (this.proxyConnectionTimeout <= 0) {
            this.proxyConnectionTimeout = 10000;
        }
        return this.proxyConnectionTimeout;
    }

    public final void setProxyConnectionTimeout(int n) {
        this.proxyConnectionTimeout = n;
    }

    public final boolean isProxyPrioritizationEnabled() {
        return this.proxyPrioritizationEnabled;
    }

    public final void setProxyPrioritizationEnabled(boolean bl) {
        this.proxyPrioritizationEnabled = bl;
    }

    public final boolean isAnnouncingLocalStreamHostEnabled() {
        return this.annouceLocalStreamHost;
    }

    public final void setAnnounceLocalStreamHost(boolean bl) {
        this.annouceLocalStreamHost = bl;
    }

    @Override
    public final Socks5BytestreamSession establishSession(i i2) {
        String string = Socks5BytestreamManager.getNextSessionID();
        return this.establishSession(i2, string);
    }

    @Override
    public final Socks5BytestreamSession establishSession(i object, String string) {
        Bytestream.StreamHost streamHost;
        Object object2;
        Object object3;
        XMPPConnection xMPPConnection = this.connection();
        Object object4 = null;
        if (!this.supportsSocks5((i)object)) {
            throw new SmackException.FeatureNotSupportedException("SOCKS5 Bytestream", object);
        }
        Object object5 = new ArrayList<i>();
        try {
            object5.addAll(this.determineProxies());
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            object3 = xMPPErrorException;
            object4 = xMPPErrorException;
        }
        object3 = this.determineStreamHostInfos((List<i>)object5);
        if (object3.isEmpty()) {
            if (object4 != null) {
                throw object4;
            }
            throw new SmackException.SmackMessageException("no SOCKS5 proxies available");
        }
        object4 = Socks5Utils.createDigest(string, (i)xMPPConnection.getUser(), object);
        if (this.proxyPrioritizationEnabled && this.lastWorkingProxy != null) {
            object5 = null;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                streamHost = (Bytestream.StreamHost)object2.next();
                if (!streamHost.getJID().a((CharSequence)this.lastWorkingProxy)) continue;
                object5 = streamHost;
                break;
            }
            if (object5 != null) {
                object3.remove(object5);
                object3.add(0, object5);
            }
        }
        object5 = Socks5Proxy.getSocks5Proxy();
        try {
            ((Socks5Proxy)object5).addTransfer((String)object4);
            object2 = Socks5BytestreamManager.createBytestreamInitiation(string, object, (List<Bytestream.StreamHost>)object3);
            streamHost = xMPPConnection.createStanzaCollectorAndSend((IQ)object2).nextResultOrThrow((long)this.getTargetResponseTimeout());
            object3 = ((Bytestream)((Object)streamHost)).getUsedHost();
            object3 = ((Bytestream)((Object)object2)).getStreamHost(((Bytestream.StreamHostUsed)object3).getJID());
            if (object3 == null) {
                throw new SmackException.SmackMessageException("Remote user responded with unknown host");
            }
            object = new Socks5ClientForInitiator((Bytestream.StreamHost)object3, (String)object4, xMPPConnection, string, (i)object);
            object = object.getSocket(this.getProxyConnectionTimeout());
            this.lastWorkingProxy = ((Bytestream.StreamHost)object3).getJID();
            object = new Socks5BytestreamSession((Socket)object, ((Bytestream.StreamHost)object3).getJID().a((CharSequence)xMPPConnection.getUser()));
            return object;
        }
        catch (TimeoutException timeoutException) {
            throw new IOException("Timeout while connecting to SOCKS5 proxy", timeoutException);
        }
        finally {
            ((Socks5Proxy)object5).removeTransfer((String)object4);
        }
    }

    private boolean supportsSocks5(i i2) {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(i2, "http://jabber.org/protocol/bytestreams");
    }

    public final List<i> determineProxies() {
        Object object = this.connection();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)object);
        ArrayList<i> arrayList = new ArrayList<i>();
        object = serviceDiscoveryManager.discoverItems((i)object.getXMPPServiceDomain());
        for (DiscoverItems.Item item : ((DiscoverItems)((Object)object)).getItems()) {
            DiscoverInfo discoverInfo;
            if (this.proxyBlacklist.contains(item.getEntityID())) continue;
            try {
                discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException throwable) {
                this.proxyBlacklist.add(item.getEntityID());
                continue;
            }
            if (discoverInfo.hasIdentity("proxy", "bytestreams")) {
                arrayList.add(item.getEntityID());
                continue;
            }
            this.proxyBlacklist.add(item.getEntityID());
        }
        return arrayList;
    }

    private List<Bytestream.StreamHost> determineStreamHostInfos(List<i> i22) {
        XMPPConnection xMPPConnection = this.connection();
        ArrayList<Bytestream.StreamHost> arrayList = new ArrayList<Bytestream.StreamHost>();
        if (this.annouceLocalStreamHost) {
            List<Bytestream.StreamHost> list = this.getLocalStreamHost();
            arrayList.addAll(list);
        }
        for (i i22 : i22) {
            Bytestream bytestream = Socks5BytestreamManager.createStreamHostRequest(i22);
            try {
                bytestream = (Bytestream)xMPPConnection.createStanzaCollectorAndSend((IQ)bytestream).nextResultOrThrow();
                arrayList.addAll(bytestream.getStreamHosts());
            }
            catch (Exception exception) {
                this.proxyBlacklist.add(i22);
            }
        }
        return arrayList;
    }

    private static Bytestream createStreamHostRequest(i i2) {
        Bytestream bytestream = new Bytestream();
        bytestream.setType(IQ.Type.get);
        bytestream.setTo(i2);
        return bytestream;
    }

    public final List<Bytestream.StreamHost> getLocalStreamHost() {
        Socks5Proxy.getSocks5Proxy();
        ArrayList<Bytestream.StreamHost> arrayList = new ArrayList<Bytestream.StreamHost>();
        XMPPConnection xMPPConnection = this.connection();
        xMPPConnection = xMPPConnection.getUser();
        for (Socks5Proxy socks5Proxy : Socks5Proxy.getRunningProxies()) {
            List<InetAddress> list = socks5Proxy.getLocalAddresses();
            if (list.isEmpty()) continue;
            int n = socks5Proxy.getPort();
            for (InetAddress inetAddress : list) {
                if (inetAddress.isLoopbackAddress()) continue;
                arrayList.add(new Bytestream.StreamHost((i)xMPPConnection, inetAddress, n));
            }
        }
        return arrayList;
    }

    private static Bytestream createBytestreamInitiation(String object, i i2, List<Bytestream.StreamHost> object2) {
        object = new Bytestream((String)object);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Bytestream.StreamHost streamHost = (Bytestream.StreamHost)object2.next();
            ((Bytestream)((Object)object)).addStreamHost(streamHost);
        }
        object.setType(IQ.Type.set);
        object.setTo(i2);
        return object;
    }

    protected final void replyRejectPacket(IQ iQ) {
        StanzaError stanzaError = StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.not_acceptable).build();
        iQ = IQ.createErrorResponse((IQ)iQ, (StanzaError)stanzaError);
        this.connection().sendStanza((Stanza)iQ);
    }

    private void activate() {
        this.connection().registerIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.enableService();
    }

    private void enableService() {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        serviceDiscoveryManager.addFeature("http://jabber.org/protocol/bytestreams");
    }

    private static String getNextSessionID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SESSION_ID_PREFIX);
        stringBuilder.append(StringUtils.secureOnlineAttackSafeRandomString());
        return stringBuilder.toString();
    }

    protected final XMPPConnection getConnection() {
        return this.connection();
    }

    protected final BytestreamListener getUserListener(i i2) {
        return this.userListeners.get(i2);
    }

    protected final List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected final List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                Socks5BytestreamManager.getBytestreamManager(xMPPConnection);
            }
        });
        managers = new WeakHashMap<XMPPConnection, Socks5BytestreamManager>();
    }
}

