/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.e.a.i;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class DiscoverItems
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#items";
    private final List<Item> items = new LinkedList<Item>();
    private String node;

    public DiscoverItems() {
        super(ELEMENT, NAMESPACE);
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void addItems(Collection<Item> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Item item = (Item)object.next();
            this.addItem(item);
        }
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String string) {
        this.node = string;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        iQChildElementXmlStringBuilder.optAttribute("node", this.getNode());
        iQChildElementXmlStringBuilder.rightAngleBracket();
        for (Item item : this.items) {
            iQChildElementXmlStringBuilder.append(item.toXML());
        }
        return iQChildElementXmlStringBuilder;
    }

    public static class Item {
        public static final String UPDATE_ACTION = "update";
        public static final String REMOVE_ACTION = "remove";
        private final i entityID;
        private String name;
        private String node;
        private String action;

        public Item(i i2) {
            this.entityID = i2;
        }

        public i getEntityID() {
            return this.entityID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String string) {
            this.node = string;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String string) {
            this.action = string;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
            xmlStringBuilder.halfOpenElement("item");
            xmlStringBuilder.attribute("jid", (CharSequence)this.entityID);
            xmlStringBuilder.optAttribute("name", this.name);
            xmlStringBuilder.optAttribute("node", this.node);
            xmlStringBuilder.optAttribute("action", this.action);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }

        public String toString() {
            return this.toXML().toString();
        }
    }
}

