/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.e.a.f;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;
import org.jivesoftware.smackx.si.packet.StreamInitiation;

public final class FileTransferManager
extends Manager {
    private static final Map<XMPPConnection, FileTransferManager> INSTANCES = new WeakHashMap<XMPPConnection, FileTransferManager>();
    private final FileTransferNegotiator fileTransferNegotiator;
    private final List<FileTransferListener> listeners = new CopyOnWriteArrayList<FileTransferListener>();

    public static synchronized FileTransferManager getInstanceFor(XMPPConnection xMPPConnection) {
        FileTransferManager fileTransferManager = INSTANCES.get(xMPPConnection);
        if (fileTransferManager == null) {
            fileTransferManager = new FileTransferManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, fileTransferManager);
        }
        return fileTransferManager;
    }

    private FileTransferManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.fileTransferNegotiator = FileTransferNegotiator.getInstanceFor(xMPPConnection);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("si", "http://jabber.org/protocol/si", IQ.Type.set, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ object) {
                object = (StreamInitiation)((Object)object);
                object = new FileTransferRequest(FileTransferManager.this, (StreamInitiation)((Object)object));
                for (FileTransferListener fileTransferListener : FileTransferManager.this.listeners) {
                    fileTransferListener.fileTransferRequest((FileTransferRequest)object);
                }
                return null;
            }
        });
    }

    public final void addFileTransferListener(FileTransferListener fileTransferListener) {
        this.listeners.add(fileTransferListener);
    }

    public final void removeFileTransferListener(FileTransferListener fileTransferListener) {
        this.listeners.remove(fileTransferListener);
    }

    public final OutgoingFileTransfer createOutgoingFileTransfer(f f2) {
        if (f2 == null) {
            throw new IllegalArgumentException("userID was null");
        }
        return new OutgoingFileTransfer((i)this.connection().getUser(), (i)f2, FileTransferNegotiator.getNextStreamID(), this.fileTransferNegotiator);
    }

    protected final IncomingFileTransfer createIncomingFileTransfer(FileTransferRequest fileTransferRequest) {
        if (fileTransferRequest == null) {
            throw new NullPointerException("ReceiveRequest cannot be null");
        }
        IncomingFileTransfer incomingFileTransfer = new IncomingFileTransfer(fileTransferRequest, this.fileTransferNegotiator);
        incomingFileTransfer.setFileInfo(fileTransferRequest.getFileName(), fileTransferRequest.getFileSize());
        return incomingFileTransfer;
    }

    protected final void rejectIncomingFileTransfer(FileTransferRequest object) {
        object = object.getStreamInitiation();
        object = IQ.createErrorResponse((IQ)object, (StanzaError)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.forbidden).build());
        this.connection().sendStanza((Stanza)object);
    }
}

