/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.element.MoodConcretisation;
import org.jivesoftware.smackx.mood.element.MoodElement;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PayloadItem;

public final class MoodManager
extends Manager {
    public static final String MOOD_NODE = "http://jabber.org/protocol/mood";
    private static final Map<XMPPConnection, MoodManager> INSTANCES = new WeakHashMap<XMPPConnection, MoodManager>();
    private final PepManager pepManager;

    private MoodManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.pepManager = PepManager.getInstanceFor(xMPPConnection);
    }

    public static synchronized MoodManager getInstanceFor(XMPPConnection xMPPConnection) {
        MoodManager moodManager = INSTANCES.get(xMPPConnection);
        if (moodManager == null) {
            moodManager = new MoodManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, moodManager);
        }
        return moodManager;
    }

    public final void setMood(Mood mood) {
        this.setMood(mood, null, null);
    }

    public final void setMood(Mood mood, String string) {
        this.setMood(mood, null, string);
    }

    public final void setMood(Mood mood, MoodConcretisation moodConcretisation) {
        this.setMood(mood, moodConcretisation, null);
    }

    public final void setMood(Mood object, MoodConcretisation moodConcretisation, String string) {
        object = MoodManager.buildMood(object, moodConcretisation, string);
        this.publishMood((MoodElement)object);
    }

    public final void clearMood() {
        MoodElement moodElement = MoodManager.buildMood(null, null, null);
        this.publishMood(moodElement);
    }

    private void publishMood(MoodElement moodElement) {
        this.pepManager.publish(MOOD_NODE, new PayloadItem<MoodElement>(moodElement));
    }

    private static MoodElement buildMood(Mood mood, MoodConcretisation moodConcretisation, String string) {
        return new MoodElement(new MoodElement.MoodSubjectElement(mood, moodConcretisation), string);
    }

    public static void addMoodToMessage(Message message, Mood mood) {
        MoodManager.addMoodToMessage(message, mood, null);
    }

    public static void addMoodToMessage(Message message, Mood object, MoodConcretisation moodConcretisation) {
        object = MoodManager.buildMood(object, moodConcretisation, null);
        message.addExtension((ExtensionElement)object);
    }

    public final boolean addMoodListener(PepEventListener<MoodElement> pepEventListener) {
        return this.pepManager.addPepEventListener(MOOD_NODE, MoodElement.class, pepEventListener);
    }

    public final boolean removeMoodListener(PepEventListener<MoodElement> pepEventListener) {
        return this.pepManager.removePepEventListener(pepEventListener);
    }
}

