/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood.element;

import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.element.MoodConcretisation;

public class MoodElement
implements ExtensionElement {
    public static final String NAMESPACE = "http://jabber.org/protocol/mood";
    public static final String ELEMENT = "mood";
    public static final QName QNAME = new QName("http://jabber.org/protocol/mood", "mood");
    public static final String ELEM_TEXT = "text";
    private final MoodSubjectElement mood;
    private final String text;

    public MoodElement(MoodSubjectElement moodSubjectElement, String string) {
        if (moodSubjectElement == null && string != null) {
            throw new IllegalArgumentException("If <mood/> is null, text MUST be null too.");
        }
        this.mood = moodSubjectElement;
        this.text = string;
    }

    public Mood getMood() {
        if (this.mood != null) {
            return this.mood.getMood();
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasText() {
        return this.getText() != null;
    }

    public MoodConcretisation getMoodConcretisation() {
        if (this.mood != null) {
            return this.mood.getConcretisation();
        }
        return null;
    }

    public boolean hasConcretisation() {
        return this.getMoodConcretisation() != null;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
        if (this.mood == null && this.text == null) {
            return xmlEnvironment.closeEmptyElement();
        }
        xmlEnvironment.rightAngleBracket();
        xmlEnvironment.optAppend((Element)this.mood);
        if (this.text != null) {
            xmlEnvironment.openElement(ELEM_TEXT).append((CharSequence)this.text).closeElement(ELEM_TEXT);
        }
        return xmlEnvironment.closeElement(this.getElementName());
    }

    public static MoodElement fromMessage(Message message) {
        return (MoodElement)message.getExtension(MoodElement.class);
    }

    public static boolean hasMoodElement(Message message) {
        return message.hasExtension(ELEMENT, NAMESPACE);
    }

    public static class MoodSubjectElement
    implements FullyQualifiedElement {
        private final Mood mood;
        private final MoodConcretisation concretisation;

        public MoodSubjectElement(Mood mood, MoodConcretisation moodConcretisation) {
            this.mood = (Mood)((Object)Objects.requireNonNull((Object)((Object)mood)));
            this.concretisation = moodConcretisation;
        }

        public String getElementName() {
            return this.mood.toString();
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            if (this.concretisation == null) {
                return xmlEnvironment.closeEmptyElement();
            }
            xmlEnvironment.rightAngleBracket().append((Element)this.concretisation).closeElement((NamedElement)this);
            return xmlEnvironment;
        }

        public Mood getMood() {
            return this.mood;
        }

        public MoodConcretisation getConcretisation() {
            return this.concretisation;
        }

        public String getNamespace() {
            return MoodElement.NAMESPACE;
        }
    }
}

