/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.b;
import org.e.a.b.d;
import org.e.a.e;
import org.e.a.f;
import org.e.a.g;
import org.e.a.i;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PresenceListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.MessageWithSubjectFilter;
import org.jivesoftware.smack.filter.MessageWithThreadFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PossibleFromTypeFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.filter.ToMatchesFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.iqregister.packet.Registration;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.MucConfigFormManager;
import org.jivesoftware.smackx.muc.MucEnterConfiguration;
import org.jivesoftware.smackx.muc.MucMessageInterceptor;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.filter.MUCUserStatusCodeFilter;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCAdmin;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCOwner;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class MultiUserChat {
    private static final Logger LOGGER = Logger.getLogger(MultiUserChat.class.getName());
    private final XMPPConnection connection;
    private final e room;
    private final MultiUserChatManager multiUserChatManager;
    private final Map<f, Presence> occupantsMap = new ConcurrentHashMap<f, Presence>();
    private final Set<InvitationRejectionListener> invitationRejectionListeners = new CopyOnWriteArraySet<InvitationRejectionListener>();
    private final Set<SubjectUpdatedListener> subjectUpdatedListeners = new CopyOnWriteArraySet<SubjectUpdatedListener>();
    private final Set<UserStatusListener> userStatusListeners = new CopyOnWriteArraySet<UserStatusListener>();
    private final Set<ParticipantStatusListener> participantStatusListeners = new CopyOnWriteArraySet<ParticipantStatusListener>();
    private final Set<MessageListener> messageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final Set<PresenceListener> presenceListeners = new CopyOnWriteArraySet<PresenceListener>();
    private final Set<Consumer<PresenceBuilder>> presenceInterceptors = new CopyOnWriteArraySet<Consumer<PresenceBuilder>>();
    private final StanzaFilter fromRoomFilter;
    private final StanzaFilter fromRoomGroupchatFilter;
    private final AtomicInteger presenceInterceptorCount = new AtomicInteger();
    private final Consumer<PresenceBuilder> presenceInterceptor = presenceBuilder -> {
        for (Consumer<PresenceBuilder> consumer : this.presenceInterceptors) {
            consumer.accept(presenceBuilder);
        }
    };
    private final StanzaListener messageListener;
    private final StanzaListener presenceListener;
    private final StanzaListener subjectListener;
    private static final StanzaFilter DECLINE_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL, new StanzaExtensionFilter("x", "http://jabber.org/protocol/muc#user")});
    private final StanzaListener declinesListener;
    private String subject;
    private f myRoomJid;
    private StanzaCollector messageCollector;
    private DiscoverInfo mucServiceDiscoInfo;
    private volatile boolean processedReflectedSelfPresence;
    private CopyOnWriteArrayList<MucMessageInterceptor> messageInterceptors;

    MultiUserChat(XMPPConnection xMPPConnection, e e2, final MultiUserChatManager multiUserChatManager) {
        this.connection = xMPPConnection;
        this.room = e2;
        this.multiUserChatManager = multiUserChatManager;
        this.messageInterceptors = MultiUserChatManager.getMessageInterceptors();
        this.fromRoomFilter = FromMatchesFilter.create((i)e2);
        this.fromRoomGroupchatFilter = new AndFilter(new StanzaFilter[]{this.fromRoomFilter, MessageTypeFilter.GROUPCHAT});
        this.messageListener = new StanzaListener(){

            public void processStanza(Stanza stanza) {
                stanza = (Message)stanza;
                for (MessageListener messageListener : MultiUserChat.this.messageListeners) {
                    messageListener.processMessage((Message)stanza);
                }
            }
        };
        this.subjectListener = new StanzaListener(){

            public void processStanza(Stanza stanza) {
                stanza = (Message)stanza;
                f f2 = stanza.getFrom().q();
                MultiUserChat.this.subject = stanza.getSubject();
                for (SubjectUpdatedListener subjectUpdatedListener : MultiUserChat.this.subjectUpdatedListeners) {
                    subjectUpdatedListener.subjectUpdated(stanza.getSubject(), f2);
                }
            }
        };
        this.presenceListener = new StanzaListener(){

            public void processStanza(Stanza object) {
                Object object22;
                Presence presence = (Presence)object;
                f f2 = presence.getFrom().q();
                if (f2 == null) {
                    return;
                }
                f f3 = MultiUserChat.this.myRoomJid;
                boolean bl = presence.getFrom().a((CharSequence)f3);
                object = MUCUser.from((Stanza)object);
                switch (presence.getType()) {
                    case available: {
                        Object object32;
                        Object object42;
                        if (!MultiUserChat.this.processedReflectedSelfPresence && ((MUCUser)object).getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110)) {
                            MultiUserChat.this.processedReflectedSelfPresence = true;
                            object42 = this;
                            synchronized (object42) {
                                this.notify();
                            }
                        }
                        if ((object42 = MultiUserChat.this.occupantsMap.put(f2, presence)) != null) {
                            object22 = MUCUser.from((Stanza)object42);
                            object42 = ((MUCUser)object22).getItem().getAffiliation();
                            object32 = ((MUCUser)object22).getItem().getRole();
                            MUCAffiliation mUCAffiliation = ((MUCUser)object).getItem().getAffiliation();
                            Object object5 = ((MUCUser)object).getItem().getRole();
                            MultiUserChat.this.checkRoleModifications(object32, object5, bl, f2);
                            MultiUserChat.this.checkAffiliationModifications((MUCAffiliation)((Object)object42), mUCAffiliation, bl, f2);
                            break;
                        }
                        for (Object object42 : MultiUserChat.this.participantStatusListeners) {
                            object42.joined(f2);
                        }
                        break;
                    }
                    case unavailable: {
                        Object object32;
                        Object object42;
                        MultiUserChat.this.occupantsMap.remove(f2);
                        if (object != null && ((MUCUser)object).hasStatus()) {
                            if (bl) {
                                MultiUserChat.this.userHasLeft();
                            }
                            MultiUserChat.this.checkPresenceCode(((MUCUser)object).getStatus(), bl, (MUCUser)object, f2);
                        } else if (!bl) {
                            object22 = MultiUserChat.this.participantStatusListeners.iterator();
                            while (object22.hasNext()) {
                                object42 = (ParticipantStatusListener)object22.next();
                                object42.left(f2);
                            }
                        }
                        if ((object22 = object == null ? null : ((MUCUser)object).getDestroy()) != null) {
                            object42 = ((Destroy)object22).getJid();
                            object32 = object42 == null ? null : multiUserChatManager.getMultiUserChat((e)object42);
                            for (Object object5 : MultiUserChat.this.userStatusListeners) {
                                object5.roomDestroyed((MultiUserChat)object32, ((Destroy)object22).getReason());
                            }
                        }
                        if (bl) {
                            for (Object object32 : MultiUserChat.this.userStatusListeners) {
                                object32.removed((MUCUser)object, presence);
                            }
                        } else {
                            for (Object object32 : MultiUserChat.this.participantStatusListeners) {
                                object32.parted(f2);
                            }
                        }
                        break;
                    }
                }
                for (Object object22 : MultiUserChat.this.presenceListeners) {
                    object22.processPresence(presence);
                }
            }
        };
        this.declinesListener = new StanzaListener(){

            public void processStanza(Stanza object) {
                Message message = (Message)object;
                object = MUCUser.from(object);
                if ((object = object.getDecline()) == null) {
                    return;
                }
                MultiUserChat.this.fireInvitationRejectionListeners(message, (MUCUser.Decline)object);
            }
        };
    }

    public e getRoom() {
        return this.room;
    }

    private Presence enter(MucEnterConfiguration mucEnterConfiguration) {
        b b2 = this.room.v();
        this.mucServiceDiscoInfo = this.multiUserChatManager.getMucServiceDiscoInfo(b2);
        if (this.mucServiceDiscoInfo == null) {
            throw new MultiUserChatException.NotAMucServiceException(this);
        }
        b2 = mucEnterConfiguration.getJoinPresence(this);
        this.connection.addStanzaListener(this.messageListener, this.fromRoomGroupchatFilter);
        AndFilter andFilter = new AndFilter(new StanzaFilter[]{this.fromRoomFilter, StanzaTypeFilter.PRESENCE, PossibleFromTypeFilter.ENTITY_FULL_JID});
        this.connection.addStanzaListener(this.presenceListener, (StanzaFilter)andFilter);
        this.connection.addStanzaListener(this.subjectListener, (StanzaFilter)new AndFilter(new StanzaFilter[]{this.fromRoomFilter, MessageWithSubjectFilter.INSTANCE, new NotFilter(MessageTypeFilter.ERROR), new NotFilter(MessageWithBodiesFilter.INSTANCE), new NotFilter(MessageWithThreadFilter.INSTANCE)}));
        this.connection.addStanzaListener(this.declinesListener, (StanzaFilter)new AndFilter(new StanzaFilter[]{this.fromRoomFilter, DECLINE_FILTER}));
        this.messageCollector = this.connection.createStanzaCollector(this.fromRoomGroupchatFilter);
        AndFilter andFilter2 = new AndFilter(new StanzaFilter[]{StanzaTypeFilter.PRESENCE, new OrFilter(new StanzaFilter[]{new AndFilter(new StanzaFilter[]{FromMatchesFilter.createBare((i)this.getRoom()), MUCUserStatusCodeFilter.STATUS_110_PRESENCE_TO_SELF}), new AndFilter(new StanzaFilter[]{FromMatchesFilter.createFull((i)b2.getTo()), new StanzaIdFilter((Stanza)b2), PresenceTypeFilter.ERROR})})});
        this.processedReflectedSelfPresence = false;
        StanzaCollector stanzaCollector = null;
        try {
            b2 = this.connection.createStanzaCollectorAndSend((StanzaFilter)andFilter2, (Stanza)b2);
            andFilter = StanzaCollector.newConfiguration().setCollectorToReset((StanzaCollector)b2).setStanzaFilter((StanzaFilter)andFilter);
            stanzaCollector = this.connection.createStanzaCollector((StanzaCollector.Configuration)andFilter);
            mucEnterConfiguration = (Presence)b2.nextResultOrThrow(mucEnterConfiguration.getTimeout());
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
            this.removeConnectionCallbacks();
            throw throwable;
        }
        finally {
            if (stanzaCollector != null) {
                stanzaCollector.cancel();
            }
        }
        b2 = this.presenceListener;
        synchronized (b2) {
            while (!this.processedReflectedSelfPresence) {
                this.presenceListener.wait();
            }
        }
        b2 = mucEnterConfiguration.getFrom().y();
        this.setNickname((d)b2);
        this.multiUserChatManager.addJoinedRoom(this.room);
        return mucEnterConfiguration;
    }

    private void setNickname(d d2) {
        this.myRoomJid = org.e.a.a.d.b((e)this.room, (d)d2);
    }

    public MucEnterConfiguration.Builder getEnterConfigurationBuilder(d d2) {
        return new MucEnterConfiguration.Builder(d2, this.connection);
    }

    public synchronized MucCreateConfigFormHandle create(d object) {
        if (this.isJoined()) {
            throw new MultiUserChatException.MucAlreadyJoinedException();
        }
        if ((object = this.createOrJoin((d)object)) != null) {
            return object;
        }
        try {
            this.leave();
        }
        catch (MultiUserChatException.MucNotJoinedException mucNotJoinedException) {
            LOGGER.log(Level.INFO, "Unexpected MucNotJoinedException", (Throwable)((Object)mucNotJoinedException));
        }
        throw new MultiUserChatException.MissingMucCreationAcknowledgeException();
    }

    public synchronized MucCreateConfigFormHandle createOrJoin(d object) {
        object = this.getEnterConfigurationBuilder((d)object).build();
        return this.createOrJoin((MucEnterConfiguration)object);
    }

    public synchronized MucCreateConfigFormHandle createOrJoin(MucEnterConfiguration object) {
        if (this.isJoined()) {
            throw new MultiUserChatException.MucAlreadyJoinedException();
        }
        object = this.enter((MucEnterConfiguration)object);
        if ((object = MUCUser.from((Stanza)object)) != null && ((MUCUser)object).getStatus().contains(MUCUser.Status.ROOM_CREATED_201)) {
            return new MucCreateConfigFormHandle();
        }
        return null;
    }

    public MucCreateConfigFormHandle createOrJoinIfNecessary(d object, String string) {
        if (this.isJoined()) {
            return null;
        }
        object = this.getEnterConfigurationBuilder((d)object).withPassword(string).build();
        try {
            return this.createOrJoin((MucEnterConfiguration)object);
        }
        catch (MultiUserChatException.MucAlreadyJoinedException mucAlreadyJoinedException) {
            return null;
        }
    }

    public void join(d object) {
        object = this.getEnterConfigurationBuilder((d)object);
        this.join(((MucEnterConfiguration.Builder)object).build());
    }

    public void join(d object, String string) {
        object = this.getEnterConfigurationBuilder((d)object).withPassword(string);
        this.join(((MucEnterConfiguration.Builder)object).build());
    }

    public synchronized void join(MucEnterConfiguration mucEnterConfiguration) {
        if (this.isJoined()) {
            try {
                this.leaveSync();
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException | MultiUserChatException.MucNotJoinedException object) {
                LOGGER.log(Level.WARNING, "Could not leave MUC prior joining, assuming we are not joined", (Throwable)object);
            }
        }
        this.enter(mucEnterConfiguration);
    }

    public boolean isJoined() {
        return this.myRoomJid != null;
    }

    @Deprecated
    public synchronized Presence leaveSync() {
        return this.leave();
    }

    public synchronized Presence leave() {
        f f2 = this.myRoomJid;
        if (f2 == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        Presence presence = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.unavailable).to((i)f2)).build();
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(StanzaTypeFilter.PRESENCE);
        arrayList.add(new OrFilter(new StanzaFilter[]{new AndFilter(new StanzaFilter[]{FromMatchesFilter.createFull((i)f2), PresenceTypeFilter.UNAVAILABLE, MUCUserStatusCodeFilter.STATUS_110_PRESENCE_TO_SELF}), new AndFilter(new StanzaFilter[]{this.fromRoomFilter, PresenceTypeFilter.ERROR})}));
        if (this.serviceSupportsStableIds()) {
            arrayList.add(new StanzaIdFilter((Stanza)presence));
        }
        f2 = new AndFilter(arrayList);
        try {
            f2 = (Presence)this.connection.createStanzaCollectorAndSend((StanzaFilter)f2, (Stanza)presence).nextResultOrThrow();
        }
        finally {
            this.userHasLeft();
        }
        return f2;
    }

    public MucConfigFormManager getConfigFormManager() {
        return new MucConfigFormManager(this);
    }

    public Form getConfigurationForm() {
        Object object = new MUCOwner();
        object.setTo((i)this.room);
        object.setType(IQ.Type.get);
        object = (IQ)this.connection.createStanzaCollectorAndSend((IQ)object).nextResultOrThrow();
        object = DataForm.from((StanzaView)object, "http://jabber.org/protocol/muc#roomconfig");
        return new Form((DataForm)object);
    }

    public void sendConfigurationForm(FillableForm object) {
        object = object != null ? ((FillableForm)object).getDataFormToSubmit() : DataForm.builder().build();
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo((i)this.room);
        mUCOwner.setType(IQ.Type.set);
        mUCOwner.addExtension((ExtensionElement)object);
        this.connection.createStanzaCollectorAndSend((IQ)mUCOwner).nextResultOrThrow();
    }

    public Form getRegistrationForm() {
        Object object = new Registration();
        object.setType(IQ.Type.get);
        object.setTo((i)this.room);
        object = (IQ)this.connection.createStanzaCollectorAndSend((IQ)object).nextResultOrThrow();
        object = DataForm.from((StanzaView)object);
        return new Form((DataForm)object);
    }

    public void sendRegistrationForm(FillableForm fillableForm) {
        Registration registration = new Registration();
        registration.setType(IQ.Type.set);
        registration.setTo((i)this.room);
        registration.addExtension(fillableForm.getDataFormToSubmit());
        this.connection.createStanzaCollectorAndSend((IQ)registration).nextResultOrThrow();
    }

    public void destroy(String object, e e2) {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo((i)this.room);
        mUCOwner.setType(IQ.Type.set);
        object = new Destroy(e2, (String)object);
        mUCOwner.setDestroy((Destroy)object);
        try {
            this.connection.createStanzaCollectorAndSend((IQ)mUCOwner).nextResultOrThrow();
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            object = xMPPErrorException;
            throw xMPPErrorException;
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException throwable) {
            this.userHasLeft();
            throw throwable;
        }
        this.userHasLeft();
    }

    public void invite(e e2, String string) {
        MultiUserChat multiUserChat = this;
        multiUserChat.invite(multiUserChat.connection.getStanzaFactory().buildMessageStanza(), e2, string);
    }

    @Deprecated
    public void invite(Message message, e object, String string) {
        message.setTo((i)this.room);
        MUCUser mUCUser = new MUCUser();
        object = new MUCUser.Invite(string, (e)object);
        mUCUser.setInvite((MUCUser.Invite)object);
        message.addExtension((ExtensionElement)mUCUser);
        this.connection.sendStanza((Stanza)message);
    }

    public void invite(MessageBuilder messageBuilder, e object, String string) {
        messageBuilder.to((i)this.room);
        MUCUser mUCUser = new MUCUser();
        object = new MUCUser.Invite(string, (e)object);
        mUCUser.setInvite((MUCUser.Invite)object);
        messageBuilder.addExtension((ExtensionElement)mUCUser);
        messageBuilder = messageBuilder.build();
        this.connection.sendStanza((Stanza)messageBuilder);
    }

    public boolean addInvitationRejectionListener(InvitationRejectionListener invitationRejectionListener) {
        return this.invitationRejectionListeners.add(invitationRejectionListener);
    }

    public boolean removeInvitationRejectionListener(InvitationRejectionListener invitationRejectionListener) {
        return this.invitationRejectionListeners.remove(invitationRejectionListener);
    }

    private void fireInvitationRejectionListeners(Message message, MUCUser.Decline decline) {
        e e2 = decline.getFrom();
        String string = decline.getReason();
        InvitationRejectionListener[] invitationRejectionListenerArray = this.invitationRejectionListeners;
        synchronized (this.invitationRejectionListeners) {
            InvitationRejectionListener[] invitationRejectionListenerArray2 = new InvitationRejectionListener[this.invitationRejectionListeners.size()];
            this.invitationRejectionListeners.toArray(invitationRejectionListenerArray2);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            invitationRejectionListenerArray = invitationRejectionListenerArray2;
            int n = invitationRejectionListenerArray2.length;
            for (int j = 0; j < n; ++j) {
                InvitationRejectionListener invitationRejectionListener = invitationRejectionListenerArray[j];
                invitationRejectionListener.invitationDeclined(e2, string, message, decline);
            }
            return;
        }
    }

    public boolean addSubjectUpdatedListener(SubjectUpdatedListener subjectUpdatedListener) {
        return this.subjectUpdatedListeners.add(subjectUpdatedListener);
    }

    public boolean removeSubjectUpdatedListener(SubjectUpdatedListener subjectUpdatedListener) {
        return this.subjectUpdatedListeners.remove(subjectUpdatedListener);
    }

    public void addPresenceInterceptor(Consumer<PresenceBuilder> consumer) {
        int n = this.presenceInterceptors.add(consumer);
        if (n == 0) {
            return;
        }
        n = this.presenceInterceptorCount.incrementAndGet();
        if (n == 1) {
            this.connection.addPresenceInterceptor(this.presenceInterceptor, ToMatchesFilter.create((i)this.room).asPredicate(Presence.class));
        }
    }

    public void removePresenceInterceptor(Consumer<PresenceBuilder> consumer) {
        int n = this.presenceInterceptors.remove(consumer);
        if (n == 0) {
            return;
        }
        n = this.presenceInterceptorCount.decrementAndGet();
        if (n == 0) {
            this.connection.removePresenceInterceptor(this.presenceInterceptor);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReservedNickname() {
        try {
            Object object = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo((i)this.room, "x-roomuser-item");
            object = ((DiscoverInfo)object).getIdentities().iterator();
            if (object.hasNext()) {
                object = (DiscoverInfo.Identity)object.next();
                return ((DiscoverInfo.Identity)object).getName();
            }
        }
        catch (XMPPException xMPPException) {
            LOGGER.log(Level.SEVERE, "Error retrieving room nickname", xMPPException);
        }
        return null;
    }

    public d getNickname() {
        f f2 = this.myRoomJid;
        if (f2 == null) {
            return null;
        }
        return f2.d();
    }

    public synchronized void changeNickname(d d2) {
        Objects.requireNonNull((Object)d2, (String)"Nickname must not be null or blank.");
        if (!this.isJoined()) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        f f2 = org.e.a.a.d.b((e)this.room, (d)d2);
        Presence presence = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().to((i)f2)).ofType(Presence.Type.available).build();
        f2 = new AndFilter(new StanzaFilter[]{FromMatchesFilter.createFull((i)f2), new StanzaTypeFilter(Presence.class)});
        f2 = this.connection.createStanzaCollectorAndSend((StanzaFilter)f2, (Stanza)presence);
        f2.nextResultOrThrow();
        this.setNickname(d2);
    }

    public void changeAvailabilityStatus(String string, Presence.Mode mode) {
        f f2 = this.myRoomJid;
        if (f2 == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        string = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().to((i)f2)).ofType(Presence.Type.available).setStatus(string).setMode(mode).build();
        this.connection.sendStanza((Stanza)string);
    }

    public void kickParticipant(d d2, String string) {
        this.changeRole(d2, MUCRole.none, string);
    }

    public void requestVoice() {
        DataForm.Builder builder = DataForm.builder().setFormType("http://jabber.org/protocol/muc#request");
        TextSingleFormField.Builder builder2 = FormField.textSingleBuilder("muc#role");
        builder2.setLabel("Requested role");
        builder2.setValue("participant");
        builder.addField(builder2.build());
        builder = ((MessageBuilder)((MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().to((i)this.room)).addExtension((ExtensionElement)builder.build())).build();
        this.connection.sendStanza((Stanza)builder);
    }

    public void grantVoice(Collection<d> collection) {
        this.changeRole(collection, MUCRole.participant);
    }

    public void grantVoice(d d2) {
        this.changeRole(d2, MUCRole.participant, null);
    }

    public void revokeVoice(Collection<d> collection) {
        this.changeRole(collection, MUCRole.visitor);
    }

    public void revokeVoice(d d2) {
        this.changeRole(d2, MUCRole.visitor, null);
    }

    public void banUsers(Collection<? extends i> collection) {
        this.changeAffiliationByAdmin(collection, MUCAffiliation.outcast);
    }

    public void banUser(i i2, String string) {
        this.changeAffiliationByAdmin(i2, MUCAffiliation.outcast, string);
    }

    public void grantMembership(Collection<? extends i> collection) {
        this.changeAffiliationByAdmin(collection, MUCAffiliation.member);
    }

    public void grantMembership(i i2) {
        this.changeAffiliationByAdmin(i2, MUCAffiliation.member, null);
    }

    public void revokeMembership(Collection<? extends i> collection) {
        this.changeAffiliationByAdmin(collection, MUCAffiliation.none);
    }

    public void revokeMembership(i i2) {
        this.changeAffiliationByAdmin(i2, MUCAffiliation.none, null);
    }

    public void grantModerator(Collection<d> collection) {
        this.changeRole(collection, MUCRole.moderator);
    }

    public void grantModerator(d d2) {
        this.changeRole(d2, MUCRole.moderator, null);
    }

    public void revokeModerator(Collection<d> collection) {
        this.changeRole(collection, MUCRole.participant);
    }

    public void revokeModerator(d d2) {
        this.changeRole(d2, MUCRole.participant, null);
    }

    public void grantOwnership(Collection<? extends i> collection) {
        this.changeAffiliationByAdmin(collection, MUCAffiliation.owner);
    }

    public void grantOwnership(i i2) {
        this.changeAffiliationByAdmin(i2, MUCAffiliation.owner, null);
    }

    public void revokeOwnership(Collection<? extends i> collection) {
        this.changeAffiliationByAdmin(collection, MUCAffiliation.admin);
    }

    public void revokeOwnership(i i2) {
        this.changeAffiliationByAdmin(i2, MUCAffiliation.admin, null);
    }

    public void grantAdmin(Collection<? extends i> collection) {
        this.changeAffiliationByAdmin(collection, MUCAffiliation.admin);
    }

    public void grantAdmin(i i2) {
        this.changeAffiliationByAdmin(i2, MUCAffiliation.admin);
    }

    public void revokeAdmin(Collection<? extends i> collection) {
        this.changeAffiliationByAdmin(collection, MUCAffiliation.admin);
    }

    public void revokeAdmin(g g2) {
        this.changeAffiliationByAdmin((i)g2, MUCAffiliation.member);
    }

    private void changeAffiliationByAdmin(i i2, MUCAffiliation mUCAffiliation) {
        this.changeAffiliationByAdmin(i2, mUCAffiliation, null);
    }

    private void changeAffiliationByAdmin(i object, MUCAffiliation mUCAffiliation, String string) {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo((i)this.room);
        mUCAdmin.setType(IQ.Type.set);
        object = new MUCItem(mUCAffiliation, (i)object, string);
        mUCAdmin.addItem((MUCItem)object);
        this.connection.createStanzaCollectorAndSend((IQ)mUCAdmin).nextResultOrThrow();
    }

    private void changeAffiliationByAdmin(Collection<? extends i> object, MUCAffiliation mUCAffiliation) {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo((i)this.room);
        mUCAdmin.setType(IQ.Type.set);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (i)object.next();
            object2 = new MUCItem(mUCAffiliation, (i)object2);
            mUCAdmin.addItem((MUCItem)object2);
        }
        this.connection.createStanzaCollectorAndSend((IQ)mUCAdmin).nextResultOrThrow();
    }

    private void changeRole(d object, MUCRole mUCRole, String string) {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo((i)this.room);
        mUCAdmin.setType(IQ.Type.set);
        object = new MUCItem(mUCRole, (d)object, string);
        mUCAdmin.addItem((MUCItem)object);
        this.connection.createStanzaCollectorAndSend((IQ)mUCAdmin).nextResultOrThrow();
    }

    private void changeRole(Collection<d> object, MUCRole mUCRole) {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo((i)this.room);
        mUCAdmin.setType(IQ.Type.set);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (d)object.next();
            object2 = new MUCItem(mUCRole, (d)object2);
            mUCAdmin.addItem((MUCItem)object2);
        }
        this.connection.createStanzaCollectorAndSend((IQ)mUCAdmin).nextResultOrThrow();
    }

    public int getOccupantsCount() {
        return this.occupantsMap.size();
    }

    public List<f> getOccupants() {
        return new ArrayList<f>(this.occupantsMap.keySet());
    }

    public Presence getOccupantPresence(f f2) {
        return this.occupantsMap.get(f2);
    }

    public Occupant getOccupant(f f2) {
        if ((f2 = this.getOccupantPresence(f2)) != null) {
            return new Occupant((Presence)f2);
        }
        return null;
    }

    public boolean addParticipantListener(PresenceListener presenceListener) {
        return this.presenceListeners.add(presenceListener);
    }

    public boolean removeParticipantListener(PresenceListener presenceListener) {
        return this.presenceListeners.remove(presenceListener);
    }

    public List<Affiliate> getOwners() {
        return this.getAffiliatesByAdmin(MUCAffiliation.owner);
    }

    public List<Affiliate> getAdmins() {
        return this.getAffiliatesByAdmin(MUCAffiliation.admin);
    }

    public List<Affiliate> getMembers() {
        return this.getAffiliatesByAdmin(MUCAffiliation.member);
    }

    public List<Affiliate> getOutcasts() {
        return this.getAffiliatesByAdmin(MUCAffiliation.outcast);
    }

    private List<Affiliate> getAffiliatesByAdmin(MUCAffiliation object) {
        Object object2 = new MUCAdmin();
        object2.setTo((i)this.room);
        object2.setType(IQ.Type.get);
        object = new MUCItem((MUCAffiliation)((Object)object));
        ((MUCAdmin)((Object)object2)).addItem((MUCItem)object);
        object = (MUCAdmin)this.connection.createStanzaCollectorAndSend((IQ)object2).nextResultOrThrow();
        object2 = new ArrayList();
        for (MUCItem mUCItem : ((MUCAdmin)((Object)object)).getItems()) {
            object2.add(new Affiliate(mUCItem));
        }
        return object2;
    }

    public List<Occupant> getModerators() {
        return this.getOccupants(MUCRole.moderator);
    }

    public List<Occupant> getParticipants() {
        return this.getOccupants(MUCRole.participant);
    }

    private List<Occupant> getOccupants(MUCRole object) {
        Object object2 = new MUCAdmin();
        object2.setTo((i)this.room);
        object2.setType(IQ.Type.get);
        object = new MUCItem((MUCRole)((Object)object));
        ((MUCAdmin)((Object)object2)).addItem((MUCItem)object);
        object = (MUCAdmin)this.connection.createStanzaCollectorAndSend((IQ)object2).nextResultOrThrow();
        object2 = new ArrayList();
        for (MUCItem mUCItem : ((MUCAdmin)((Object)object)).getItems()) {
            object2.add(new Occupant(mUCItem));
        }
        return object2;
    }

    public void sendMessage(String string) {
        string = this.buildMessage().setBody(string).build();
        this.connection.sendStanza((Stanza)string);
    }

    public Chat createPrivateChat(f f2, ChatMessageListener chatMessageListener) {
        return ChatManager.getInstanceFor((XMPPConnection)this.connection).createChat((g)f2, chatMessageListener);
    }

    @Deprecated
    public Message createMessage() {
        return ((MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().ofType(Message.Type.groupchat).to((i)this.room)).build();
    }

    public MessageBuilder buildMessage() {
        return (MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().ofType(Message.Type.groupchat).to((i)this.room);
    }

    @Deprecated
    public void sendMessage(Message message) {
        this.sendMessage(message.asBuilder());
    }

    public MessageView sendMessage(MessageBuilder messageBuilder) {
        for (MucMessageInterceptor mucMessageInterceptor : this.messageInterceptors) {
            mucMessageInterceptor.intercept(messageBuilder, this);
        }
        Message message = ((MessageBuilder)messageBuilder.to((i)this.room)).ofType(Message.Type.groupchat).build();
        this.connection.sendStanza((Stanza)message);
        return message;
    }

    public Message pollMessage() {
        if (this.messageCollector == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() {
        if (this.messageCollector == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long l) {
        if (this.messageCollector == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        return (Message)this.messageCollector.nextResult(l);
    }

    public boolean addMessageListener(MessageListener messageListener) {
        return this.messageListeners.add(messageListener);
    }

    public boolean removeMessageListener(MessageListener messageListener) {
        return this.messageListeners.remove(messageListener);
    }

    public boolean addMessageInterceptor(MucMessageInterceptor mucMessageInterceptor) {
        return this.messageInterceptors.add(mucMessageInterceptor);
    }

    public boolean removeMessageInterceptor(MucMessageInterceptor mucMessageInterceptor) {
        return this.messageInterceptors.remove(mucMessageInterceptor);
    }

    public void changeSubject(final String string) {
        MessageBuilder messageBuilder = this.buildMessage();
        messageBuilder.setSubject(string);
        string = new AndFilter(new StanzaFilter[]{this.fromRoomGroupchatFilter, new StanzaFilter(){

            public boolean accept(Stanza stanza) {
                stanza = (Message)stanza;
                return string.equals(stanza.getSubject());
            }
        }});
        string = this.connection.createStanzaCollectorAndSend((StanzaFilter)string, (Stanza)messageBuilder.build());
        string.nextResultOrThrow();
    }

    private void removeConnectionCallbacks() {
        this.connection.removeStanzaListener(this.messageListener);
        this.connection.removeStanzaListener(this.presenceListener);
        this.connection.removeStanzaListener(this.subjectListener);
        this.connection.removeStanzaListener(this.declinesListener);
        this.connection.removePresenceInterceptor(this.presenceInterceptor);
        if (this.messageCollector != null) {
            this.messageCollector.cancel();
            this.messageCollector = null;
        }
    }

    private synchronized void userHasLeft() {
        this.occupantsMap.clear();
        this.myRoomJid = null;
        this.multiUserChatManager.removeJoinedRoom(this.room);
        this.removeConnectionCallbacks();
    }

    public boolean addUserStatusListener(UserStatusListener userStatusListener) {
        return this.userStatusListeners.add(userStatusListener);
    }

    public boolean removeUserStatusListener(UserStatusListener userStatusListener) {
        return this.userStatusListeners.remove(userStatusListener);
    }

    public boolean addParticipantStatusListener(ParticipantStatusListener participantStatusListener) {
        return this.participantStatusListeners.add(participantStatusListener);
    }

    public boolean removeParticipantStatusListener(ParticipantStatusListener participantStatusListener) {
        return this.participantStatusListeners.remove(participantStatusListener);
    }

    private void checkRoleModifications(MUCRole mUCRole, MUCRole mUCRole2, boolean bl, f f2) {
        if ((MUCRole.visitor.equals((Object)mUCRole) || MUCRole.none.equals((Object)mUCRole)) && MUCRole.participant.equals((Object)mUCRole2)) {
            if (bl) {
                for (UserStatusListener object : this.userStatusListeners) {
                    object.voiceGranted();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.voiceGranted(f2);
                }
            }
        } else if (MUCRole.participant.equals((Object)mUCRole) && (MUCRole.visitor.equals((Object)mUCRole2) || MUCRole.none.equals((Object)mUCRole2))) {
            if (bl) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.voiceRevoked();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.voiceRevoked(f2);
                }
            }
        }
        if (!MUCRole.moderator.equals((Object)mUCRole) && MUCRole.moderator.equals((Object)mUCRole2)) {
            if (MUCRole.visitor.equals((Object)mUCRole) || MUCRole.none.equals((Object)mUCRole)) {
                if (bl) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.voiceGranted();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.voiceGranted(f2);
                    }
                }
            }
            if (bl) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.moderatorGranted();
                }
                return;
            }
            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                participantStatusListener.moderatorGranted(f2);
            }
            return;
        }
        if (MUCRole.moderator.equals((Object)mUCRole) && !MUCRole.moderator.equals((Object)mUCRole2)) {
            if (MUCRole.visitor.equals((Object)mUCRole2) || MUCRole.none.equals((Object)mUCRole2)) {
                if (bl) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.voiceRevoked();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.voiceRevoked(f2);
                    }
                }
            }
            if (bl) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.moderatorRevoked();
                }
                return;
            }
            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                participantStatusListener.moderatorRevoked(f2);
            }
        }
    }

    private void checkAffiliationModifications(MUCAffiliation mUCAffiliation, MUCAffiliation mUCAffiliation2, boolean bl, f f2) {
        if (MUCAffiliation.owner.equals((Object)mUCAffiliation) && !MUCAffiliation.owner.equals((Object)mUCAffiliation2)) {
            if (bl) {
                for (UserStatusListener object : this.userStatusListeners) {
                    object.ownershipRevoked();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.ownershipRevoked(f2);
                }
            }
        } else if (MUCAffiliation.admin.equals((Object)mUCAffiliation) && !MUCAffiliation.admin.equals((Object)mUCAffiliation2)) {
            if (bl) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.adminRevoked();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.adminRevoked(f2);
                }
            }
        } else if (MUCAffiliation.member.equals((Object)mUCAffiliation) && !MUCAffiliation.member.equals((Object)mUCAffiliation2)) {
            if (bl) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.membershipRevoked();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.membershipRevoked(f2);
                }
            }
        }
        if (!MUCAffiliation.owner.equals((Object)mUCAffiliation) && MUCAffiliation.owner.equals((Object)mUCAffiliation2)) {
            if (bl) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.ownershipGranted();
                }
                return;
            }
            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                participantStatusListener.ownershipGranted(f2);
            }
            return;
        }
        if (!MUCAffiliation.admin.equals((Object)mUCAffiliation) && MUCAffiliation.admin.equals((Object)mUCAffiliation2)) {
            if (bl) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.adminGranted();
                }
                return;
            }
            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                participantStatusListener.adminGranted(f2);
            }
            return;
        }
        if (!MUCAffiliation.member.equals((Object)mUCAffiliation) && MUCAffiliation.member.equals((Object)mUCAffiliation2)) {
            if (bl) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.membershipGranted();
                }
                return;
            }
            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                participantStatusListener.membershipGranted(f2);
            }
        }
    }

    private void checkPresenceCode(Set<MUCUser.Status> set, boolean bl, MUCUser mUCUser, f f2) {
        if (set.contains(MUCUser.Status.KICKED_307)) {
            if (bl) {
                for (UserStatusListener object : this.userStatusListeners) {
                    object.kicked(mUCUser.getItem().getActor(), mUCUser.getItem().getReason());
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.kicked(f2, mUCUser.getItem().getActor(), mUCUser.getItem().getReason());
                }
            }
        }
        if (set.contains(MUCUser.Status.BANNED_301)) {
            if (bl) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.banned(mUCUser.getItem().getActor(), mUCUser.getItem().getReason());
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.banned(f2, mUCUser.getItem().getActor(), mUCUser.getItem().getReason());
                }
            }
        }
        if (set.contains(MUCUser.Status.REMOVED_AFFIL_CHANGE_321) && bl) {
            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                userStatusListener.membershipRevoked();
            }
        }
        if (set.contains(MUCUser.Status.NEW_NICKNAME_303)) {
            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                participantStatusListener.nicknameChanged(f2, mUCUser.getItem().getNick());
            }
        }
    }

    public XMPPConnection getXmppConnection() {
        return this.connection;
    }

    public boolean serviceSupportsStableIds() {
        return DiscoverInfo.nullSafeContainsFeature(this.mucServiceDiscoInfo, "http://jabber.org/protocol/muc#stable_id");
    }

    public String toString() {
        return "MUC: " + this.room + "(" + this.connection.getUser() + ")";
    }

    public class MucCreateConfigFormHandle {
        public void makeInstant() {
            MultiUserChat.this.sendConfigurationForm(null);
        }

        public MucConfigFormManager getConfigFormManager() {
            return MultiUserChat.this.getConfigFormManager();
        }
    }
}

