/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.softwareinfo.form;

import java.util.List;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smackx.formtypes.FormFieldRegistry;
import org.jivesoftware.smackx.mediaelement.element.MediaElement;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FilledForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class SoftwareInfoForm
extends FilledForm {
    public static final String FORM_TYPE = "urn:xmpp:dataforms:softwareinfo";
    public static final String OS = "os";
    public static final String OS_VERSION = "os_version";
    public static final String SOFTWARE = "software";
    public static final String SOFTWARE_VERSION = "software_version";
    public static final String ICON = "icon";

    private SoftwareInfoForm(DataForm dataForm) {
        super(dataForm);
    }

    public final String getOS() {
        return this.readFirstValue(OS);
    }

    public final String getOSVersion() {
        return this.readFirstValue(OS_VERSION);
    }

    public final String getSoftwareName() {
        return this.readFirstValue(SOFTWARE);
    }

    public final String getSoftwareVersion() {
        return this.readFirstValue(SOFTWARE_VERSION);
    }

    public final MediaElement getIcon() {
        Object object = this.getField(ICON);
        if (object == null) {
            return null;
        }
        if ((object = object.getFormFieldChildElement(MediaElement.QNAME)) == null) {
            return null;
        }
        return (MediaElement)object;
    }

    public final boolean equals(Object object) {
        return EqualsUtil.equals((Object)this, (Object)object, (builder, softwareInfoForm) -> builder.append((Object)this.getDataForm().getType(), (Object)softwareInfoForm.getDataForm().getType()).append((Object)this.getDataForm().getTitle(), (Object)softwareInfoForm.getDataForm().getTitle()).append((Object)this.getDataForm().getReportedData(), (Object)softwareInfoForm.getDataForm().getReportedData()).append(this.getDataForm().getItems(), softwareInfoForm.getDataForm().getItems()).append(this.getDataForm().getFields(), softwareInfoForm.getDataForm().getFields()).append(this.getDataForm().getExtensionElements(), softwareInfoForm.getDataForm().getExtensionElements()));
    }

    public final int hashCode() {
        HashCode.Builder builder = HashCode.builder();
        builder.append(this.getDataForm().getFields());
        builder.append(this.getDataForm().getItems());
        builder.append(this.getDataForm().getExtensionElements());
        return builder.build();
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    static {
        FormFieldRegistry.register(FORM_TYPE, FormField.Type.text_single, OS, OS_VERSION, SOFTWARE, SOFTWARE_VERSION);
    }

    public static final class Builder {
        DataForm.Builder dataFormBuilder = DataForm.builder(DataForm.Type.result);

        private Builder() {
            TextSingleFormField textSingleFormField = FormField.buildHiddenFormType(SoftwareInfoForm.FORM_TYPE);
            this.dataFormBuilder.addField(textSingleFormField);
        }

        public final Builder setIcon(int n, int n2, List<MediaElement.Uri> object) {
            MediaElement.Builder builder = MediaElement.builder();
            object = object.iterator();
            while (object.hasNext()) {
                MediaElement.Uri uri = (MediaElement.Uri)object.next();
                builder.addUri(uri);
            }
            object = builder.setHeightAndWidth(n, n2).build();
            return this.setIcon((MediaElement)object);
        }

        public final Builder setIcon(MediaElement mediaElement) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.ICON);
            builder.addFormFieldChildElement(mediaElement);
            this.dataFormBuilder.addField((FormField)builder.build());
            return this;
        }

        public final Builder setOS(String string) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.OS);
            builder.setValue(string);
            this.dataFormBuilder.addField(builder.build());
            return this;
        }

        public final Builder setOSVersion(String string) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.OS_VERSION);
            builder.setValue(string);
            this.dataFormBuilder.addField(builder.build());
            return this;
        }

        public final Builder setSoftware(String string) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.SOFTWARE);
            builder.setValue(string);
            this.dataFormBuilder.addField(builder.build());
            return this;
        }

        public final Builder setSoftwareVersion(String string) {
            TextSingleFormField.Builder builder = FormField.builder(SoftwareInfoForm.SOFTWARE_VERSION);
            builder.setValue(string);
            this.dataFormBuilder.addField(builder.build());
            return this;
        }

        public final Builder setDataForm(DataForm dataForm) {
            if (dataForm.getTitle() != null || !dataForm.getItems().isEmpty() || dataForm.getReportedData() != null || !dataForm.getInstructions().isEmpty()) {
                throw new IllegalArgumentException("Illegal Arguements for SoftwareInformation");
            }
            String string = dataForm.getFormType();
            if (string == null) {
                throw new IllegalArgumentException("FORM_TYPE Formfield missing");
            }
            if (!string.equals(SoftwareInfoForm.FORM_TYPE)) {
                throw new IllegalArgumentException("Malformed FORM_TYPE Formfield encountered");
            }
            this.dataFormBuilder = dataForm.asBuilder();
            return this;
        }

        public final SoftwareInfoForm build() {
            return new SoftwareInfoForm(this.dataFormBuilder.build());
        }
    }
}

