/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.form;

import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FormReader;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public abstract class FilledForm
implements FormReader {
    private final DataForm dataForm;
    protected final TextSingleFormField formTypeFormField;

    public FilledForm(DataForm dataForm) {
        this.dataForm = (DataForm)Objects.requireNonNull((Object)dataForm);
        if (dataForm.getType() == DataForm.Type.cancel) {
            throw new IllegalArgumentException("Forms of type 'cancel' are not filled nor fillable");
        }
        this.formTypeFormField = dataForm.getHiddenFormTypeField();
    }

    @Override
    public FormField getField(String string) {
        return this.dataForm.getField(string);
    }

    public String getTitle() {
        return this.dataForm.getTitle();
    }

    public StringBuilder getInstructions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.dataForm.getInstructions()) {
            stringBuilder.append(string).append('\n');
        }
        return stringBuilder;
    }

    public DataForm getDataForm() {
        return this.dataForm;
    }

    public String getFormType() {
        if (this.formTypeFormField == null) {
            return null;
        }
        return this.formTypeFormField.getValue();
    }

    public boolean hasField(String string) {
        return this.dataForm.hasField(string);
    }

    protected FormField getFieldOrThrow(String string) {
        FormField formField = this.getField(string);
        if (formField == null) {
            throw new IllegalArgumentException("No field named " + string);
        }
        return formField;
    }

    protected static void ensureFormType(DataForm object, String string) {
        if (!string.equals(object = ((DataForm)object).getFormType())) {
            throw new IllegalArgumentException("The provided data form must be of type '" + string + "', this one was of type '" + (String)object + '\'');
        }
    }
}

