/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkDecoder;
import com.ning.compress.lzf.util.ChunkDecoderFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import java.util.List;

public class LzfDecoder
extends ByteToMessageDecoder {
    private State currentState = State.INIT_BLOCK;
    private static final short MAGIC_NUMBER = 23126;
    private ChunkDecoder decoder;
    private BufferRecycler recycler;
    private int chunkLength;
    private int originalLength;
    private boolean isCompressed;

    public LzfDecoder() {
        this(false);
    }

    public LzfDecoder(boolean bl) {
        this.decoder = bl ? ChunkDecoderFactory.safeInstance() : ChunkDecoderFactory.optimalInstance();
        this.recycler = BufferRecycler.instance();
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        block27: {
            try {
                switch (this.currentState) {
                    case INIT_BLOCK: {
                        if (byteBuf.readableBytes() < 5) break;
                        int n = byteBuf.readUnsignedShort();
                        if (n != 23126) {
                            throw new DecompressionException("unexpected block identifier");
                        }
                        byte by = byteBuf.readByte();
                        n = by;
                        switch (by) {
                            case 0: {
                                this.isCompressed = false;
                                this.currentState = State.DECOMPRESS_DATA;
                                break;
                            }
                            case 1: {
                                this.isCompressed = true;
                                this.currentState = State.INIT_ORIGINAL_LENGTH;
                                break;
                            }
                            default: {
                                throw new DecompressionException(String.format("unknown type of chunk: %d (expected: %d or %d)", n, 0, 1));
                            }
                        }
                        this.chunkLength = byteBuf.readUnsignedShort();
                        if (this.chunkLength > 65535) {
                            throw new DecompressionException(String.format("chunk length exceeds maximum: %d (expected: =< %d)", this.chunkLength, 65535));
                        }
                        if (n != 1) break;
                    }
                    case INIT_ORIGINAL_LENGTH: {
                        if (byteBuf.readableBytes() < 2) break;
                        this.originalLength = byteBuf.readUnsignedShort();
                        if (this.originalLength > 65535) {
                            throw new DecompressionException(String.format("original length exceeds maximum: %d (expected: =< %d)", this.chunkLength, 65535));
                        }
                        this.currentState = State.DECOMPRESS_DATA;
                    }
                    case DECOMPRESS_DATA: {
                        int n = this.chunkLength;
                        if (byteBuf.readableBytes() < n) break;
                        int n2 = this.originalLength;
                        if (this.isCompressed) {
                            int n3;
                            byte[] byArray;
                            byte[] byArray2;
                            int n4 = byteBuf.readerIndex();
                            if (byteBuf.hasArray()) {
                                byArray2 = byteBuf.array();
                                n4 = byteBuf.arrayOffset() + n4;
                            } else {
                                byArray2 = this.recycler.allocInputBuffer(n);
                                byteBuf.getBytes(n4, byArray2, 0, n);
                                n4 = 0;
                            }
                            int n5 = n2;
                            channelHandlerContext = channelHandlerContext.alloc().heapBuffer(n5, n5);
                            if (channelHandlerContext.hasArray()) {
                                byArray = channelHandlerContext.array();
                                n3 = channelHandlerContext.arrayOffset() + channelHandlerContext.writerIndex();
                            } else {
                                byArray = new byte[n2];
                                n3 = 0;
                            }
                            try {
                                int n6 = n3;
                                this.decoder.decodeChunk(byArray2, n4, byArray, n6, n6 + n2);
                                if (channelHandlerContext.hasArray()) {
                                    ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
                                    channelHandlerContext2.writerIndex(channelHandlerContext2.writerIndex() + n2);
                                } else {
                                    channelHandlerContext.writeBytes(byArray);
                                }
                                list.add(channelHandlerContext);
                                byteBuf.skipBytes(n);
                            }
                            catch (Throwable throwable) {
                                channelHandlerContext.release();
                                throw throwable;
                            }
                            if (!byteBuf.hasArray()) {
                                this.recycler.releaseInputBuffer(byArray2);
                            }
                        } else if (n > 0) {
                            list.add(byteBuf.readRetainedSlice(n));
                        }
                        this.currentState = State.INIT_BLOCK;
                        break block27;
                    }
                    case CORRUPTED: {
                        ByteBuf byteBuf2 = byteBuf;
                        byteBuf2.skipBytes(byteBuf2.readableBytes());
                        break block27;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return;
            }
            catch (Exception exception) {
                this.currentState = State.CORRUPTED;
                this.decoder = null;
                this.recycler = null;
                throw exception;
            }
        }
    }

    private static enum State {
        INIT_BLOCK,
        INIT_ORIGINAL_LENGTH,
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

