/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public class ProtobufDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final boolean HAS_PARSER;
    private final MessageLite prototype;
    private final ExtensionRegistryLite extensionRegistry;

    public ProtobufDecoder(MessageLite messageLite) {
        this(messageLite, (ExtensionRegistry)null);
    }

    public ProtobufDecoder(MessageLite messageLite, ExtensionRegistry extensionRegistry) {
        this(messageLite, (ExtensionRegistryLite)extensionRegistry);
    }

    public ProtobufDecoder(MessageLite messageLite, ExtensionRegistryLite extensionRegistryLite) {
        this.prototype = ((MessageLite)ObjectUtil.checkNotNull((Object)messageLite, (String)"prototype")).getDefaultInstanceForType();
        this.extensionRegistry = extensionRegistryLite;
    }

    @Override
    protected void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        int n;
        int n2 = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            object = byteBuf.array();
            n = byteBuf.arrayOffset() + byteBuf.readerIndex();
        } else {
            ByteBuf byteBuf2 = byteBuf;
            object = ByteBufUtil.getBytes((ByteBuf)byteBuf2, (int)byteBuf2.readerIndex(), (int)n2, (boolean)false);
            n = 0;
        }
        if (this.extensionRegistry == null) {
            if (HAS_PARSER) {
                list.add(this.prototype.getParserForType().parseFrom((byte[])object, n, n2));
                return;
            }
            list.add(this.prototype.newBuilderForType().mergeFrom((byte[])object, n, n2).build());
            return;
        }
        if (HAS_PARSER) {
            list.add(this.prototype.getParserForType().parseFrom((byte[])object, n, n2, this.extensionRegistry));
            return;
        }
        list.add(this.prototype.newBuilderForType().mergeFrom((byte[])object, n, n2, this.extensionRegistry).build());
    }

    static {
        boolean bl = false;
        try {
            MessageLite.class.getDeclaredMethod("getParserForType", new Class[0]);
            bl = true;
        }
        catch (Throwable throwable) {}
        HAS_PARSER = bl;
    }
}

