/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.util.PoolsKt;
import io.ktor.utils.io.core.BytePacketBuilderExtensions_jvmKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.ByteReadPacketExtensions_jvmKt;
import io.ktor.utils.io.pool.ByteBufferPool;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.b.a;
import kotlinx.b.q;
import kotlinx.b.t;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a6\u0010\b\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0019\b\u0002\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0000\u00a2\u0006\u0004\b\b\u0010\t\" \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lkotlinx/io/Source;", "Ljavax/crypto/Cipher;", "cipher", "Lkotlin/Function1;", "Lkotlinx/io/Sink;", "", "Lkotlin/ExtensionFunctionType;", "header", "cipherLoop", "(Lkotlinx/io/Source;Ljavax/crypto/Cipher;Lkotlin/jvm/functions/Function1;)Lkotlinx/io/Source;", "Lio/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "CryptoBufferPool", "Lio/ktor/utils/io/pool/ObjectPool;", "getCryptoBufferPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "ktor-network-tls"})
public final class CipherUtilsKt {
    private static final ObjectPool<ByteBuffer> CryptoBufferPool = (ObjectPool)new ByteBufferPool(128, 65536);

    public static final ObjectPool<ByteBuffer> getCryptoBufferPool() {
        return CryptoBufferPool;
    }

    public static final t cipherLoop(t object, Cipher cipher, Function1<? super q, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        ByteBuffer byteBuffer = (ByteBuffer)PoolsKt.getDefaultByteBufferPool().borrow();
        Object object2 = CryptoBufferPool.borrow();
        boolean bl = true;
        try {
            int n2;
            a a2 = new a();
            q q2 = (q)a2;
            byteBuffer.clear();
            function1.invoke((Object)q2);
            while (true) {
                n2 = byteBuffer.hasRemaining() ? ByteReadPacketExtensions_jvmKt.readAvailable((t)object, (ByteBuffer)byteBuffer) : 0;
                byteBuffer.flip();
                if (!byteBuffer.hasRemaining() && (n2 == -1 || object.e())) break;
                ((ByteBuffer)object2).clear();
                if (cipher.getOutputSize(byteBuffer.remaining()) > ((ByteBuffer)object2).remaining()) {
                    if (bl) {
                        CryptoBufferPool.recycle(object2);
                    }
                    object2 = ByteBuffer.allocate(cipher.getOutputSize(byteBuffer.remaining()));
                    bl = false;
                }
                cipher.update(byteBuffer, (ByteBuffer)object2);
                ((ByteBuffer)object2).flip();
                BytePacketBuilderExtensions_jvmKt.writeFully((q)q2, (ByteBuffer)((ByteBuffer)object2));
                byteBuffer.compact();
            }
            int n3 = n2 = !byteBuffer.hasRemaining() ? 1 : 0;
            if (_Assertions.ENABLED && n2 == 0) {
                object = "Cipher loop completed too early: there are unprocessed bytes";
                throw new AssertionError(object);
            }
            int n4 = n2 = !((ByteBuffer)object2).hasRemaining() ? 1 : 0;
            if (_Assertions.ENABLED && n2 == 0) {
                object = "Not all bytes were appended to the packet";
                throw new AssertionError(object);
            }
            n2 = cipher.getOutputSize(0);
            if (n2 != 0) {
                if (n2 > ((ByteBuffer)object2).capacity()) {
                    byte[] byArray = cipher.doFinal();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
                    BytePacketBuilderKt.writeFully$default((q)q2, (byte[])byArray, (int)0, (int)0, (int)6, null);
                } else {
                    ((ByteBuffer)object2).clear();
                    cipher.doFinal(CipherKt.getEmptyByteBuffer(), (ByteBuffer)object2);
                    ((ByteBuffer)object2).flip();
                    if (!((ByteBuffer)object2).hasRemaining()) {
                        byte[] byArray = cipher.doFinal();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
                        BytePacketBuilderKt.writeFully$default((q)q2, (byte[])byArray, (int)0, (int)0, (int)6, null);
                    } else {
                        BytePacketBuilderExtensions_jvmKt.writeFully((q)q2, (ByteBuffer)((ByteBuffer)object2));
                    }
                }
            }
            object = (t)a2;
            return object;
        }
        finally {
            PoolsKt.getDefaultByteBufferPool().recycle((Object)byteBuffer);
            if (bl) {
                CryptoBufferPool.recycle(object2);
            }
        }
    }

    public static /* synthetic */ t cipherLoop$default(t t2, Cipher cipher, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = CipherUtilsKt::cipherLoop$lambda$0;
        }
        return CipherUtilsKt.cipherLoop(t2, cipher, (Function1<? super q, Unit>)function1);
    }

    private static final Unit cipherLoop$lambda$0(q q2) {
        Intrinsics.checkNotNullParameter((Object)q2, (String)"");
        return Unit.INSTANCE;
    }
}

