/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.util.internal.SystemPropertyUtil;

public final class Epoll {
    private static final Throwable UNAVAILABILITY_CAUSE;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    public static boolean isTcpFastOpenClientSideAvailable() {
        return Epoll.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    }

    public static boolean isTcpFastOpenServerSideAvailable() {
        return Epoll.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    }

    private Epoll() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Throwable throwable;
        block16: {
            throwable = null;
            if (SystemPropertyUtil.getBoolean((String)"io.netty.transport.noNative", (boolean)false)) {
                throwable = new UnsupportedOperationException("Native transport was explicit disabled with -Dio.netty.transport.noNative=true");
            } else {
                FileDescriptor fileDescriptor2;
                block15: {
                    FileDescriptor fileDescriptor = null;
                    try {
                        fileDescriptor = Native.newEpollCreate();
                        fileDescriptor2 = Native.newEventFd();
                        if (fileDescriptor == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throwable = throwable2;
                        if (fileDescriptor != null) {
                            try {
                                fileDescriptor.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block16;
                    }
                    catch (Throwable throwable3) {
                        if (fileDescriptor == null) throw throwable3;
                        try {
                            fileDescriptor.close();
                            throw throwable3;
                        }
                        catch (Exception exception) {}
                        throw throwable3;
                    }
                    try {
                        fileDescriptor.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileDescriptor2 != null) {
                    try {
                        fileDescriptor2.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        UNAVAILABILITY_CAUSE = throwable;
    }
}

