/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.Map;
import javax.swing.UIManager;

public class FlatHelpButtonIcon
extends FlatAbstractIcon {
    @FlatStylingSupport.Styleable
    protected int focusWidth = UIManager.getInt("Component.focusWidth");
    @FlatStylingSupport.Styleable
    protected Color focusColor = UIManager.getColor("Component.focusColor");
    @FlatStylingSupport.Styleable
    protected float innerFocusWidth = FlatUIUtils.getUIFloat("HelpButton.innerFocusWidth", FlatUIUtils.getUIFloat("Component.innerFocusWidth", 0.0f));
    @FlatStylingSupport.Styleable
    protected int borderWidth = FlatUIUtils.getUIInt("HelpButton.borderWidth", 1);
    @FlatStylingSupport.Styleable
    protected Color borderColor = UIManager.getColor("HelpButton.borderColor");
    @FlatStylingSupport.Styleable
    protected Color disabledBorderColor = UIManager.getColor("HelpButton.disabledBorderColor");
    @FlatStylingSupport.Styleable
    protected Color focusedBorderColor = UIManager.getColor("HelpButton.focusedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color hoverBorderColor = UIManager.getColor("HelpButton.hoverBorderColor");
    @FlatStylingSupport.Styleable
    protected Color background = UIManager.getColor("HelpButton.background");
    @FlatStylingSupport.Styleable
    protected Color disabledBackground = UIManager.getColor("HelpButton.disabledBackground");
    @FlatStylingSupport.Styleable
    protected Color focusedBackground = UIManager.getColor("HelpButton.focusedBackground");
    @FlatStylingSupport.Styleable
    protected Color hoverBackground = UIManager.getColor("HelpButton.hoverBackground");
    @FlatStylingSupport.Styleable
    protected Color pressedBackground = UIManager.getColor("HelpButton.pressedBackground");
    @FlatStylingSupport.Styleable
    protected Color questionMarkColor = UIManager.getColor("HelpButton.questionMarkColor");
    @FlatStylingSupport.Styleable
    protected Color disabledQuestionMarkColor = UIManager.getColor("HelpButton.disabledQuestionMarkColor");

    public FlatHelpButtonIcon() {
        super(0, 0, null);
    }

    public Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
    }

    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    public Object getStyleableValue(String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    protected void paintIcon(Component serializable, Graphics2D graphics2D) {
        boolean bl = serializable == null || ((Component)serializable).isEnabled();
        boolean bl2 = serializable != null && FlatUIUtils.isPermanentFocusOwner((Component)serializable);
        float f = this.iconSize() - 1;
        if (bl2 && FlatButtonUI.isFocusPainted((Component)serializable)) {
            graphics2D.setColor(this.focusColor);
            float f2 = f;
            graphics2D.fill(new Ellipse2D.Float(0.5f, 0.5f, f2, f2));
        }
        float f3 = 0.5f + (float)this.focusWidth;
        graphics2D.setColor(FlatButtonUI.buttonStateColor((Component)serializable, this.borderColor, this.disabledBorderColor, this.focusedBorderColor, this.hoverBorderColor, null));
        float f4 = f3;
        float f5 = f -= (float)(this.focusWidth << 1);
        graphics2D.fill(new Ellipse2D.Float(f4, f4, f5, f5));
        f3 += (float)this.borderWidth;
        f -= (float)(this.borderWidth << 1);
        if (this.innerFocusWidth > 0.0f && bl2 && FlatButtonUI.isFocusPainted((Component)serializable)) {
            graphics2D.setColor(this.focusColor);
            float f6 = f3;
            float f7 = f;
            graphics2D.fill(new Ellipse2D.Float(f6, f6, f7, f7));
            f3 += this.innerFocusWidth;
            f -= this.innerFocusWidth * 2.0f;
        }
        graphics2D.setColor(FlatUIUtils.deriveColor(FlatButtonUI.buttonStateColor((Component)serializable, this.background, this.disabledBackground, this.focusedBackground, this.hoverBackground, this.pressedBackground), this.background));
        float f8 = f3;
        float f9 = f;
        graphics2D.fill(new Ellipse2D.Float(f8, f8, f9, f9));
        serializable = new Path2D.Float(1, 10);
        ((Path2D)((Object)serializable)).moveTo(8.0, 8.5);
        ((Path2D)((Object)serializable)).curveTo(8.25, 7.0, 9.66585007, 6.0, 11.0, 6.0);
        ((Path2D)((Object)serializable)).curveTo(12.5, 6.0, 14.0, 7.0, 14.0, 8.5);
        ((Path2D)((Object)serializable)).curveTo(14.0, 10.5, 11.0, 11.0, 11.0, 13.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
        graphics2D.translate(this.focusWidth, this.focusWidth);
        graphics2D.setColor(bl ? this.questionMarkColor : this.disabledQuestionMarkColor);
        graphics2D.draw((Shape)((Object)serializable));
        graphics2D.fill(new Ellipse2D.Float(9.8f, 14.8f, 2.4f, 2.4f));
    }

    @Override
    public int getIconWidth() {
        return UIScale.scale(this.iconSize());
    }

    @Override
    public int getIconHeight() {
        return UIScale.scale(this.iconSize());
    }

    private int iconSize() {
        return 22 + (this.focusWidth << 1);
    }
}

