/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.icons.FlatCheckBoxMenuItemIcon;
import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatListUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;

@FlatStylingSupport.StyleableField(cls=BasicComboBoxUI.class, key="padding")
public class FlatComboBoxUI
extends BasicComboBoxUI
implements FlatStylingSupport.StyleableLookupProvider,
FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    @FlatStylingSupport.Styleable
    protected int editorColumns;
    @FlatStylingSupport.Styleable
    protected String buttonStyle;
    @FlatStylingSupport.Styleable
    protected String arrowType;
    private Color background;
    @FlatStylingSupport.Styleable
    protected Color editableBackground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected Color buttonBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonEditableBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonFocusedBackground;
    @FlatStylingSupport.Styleable
    protected float buttonSeparatorWidth;
    @FlatStylingSupport.Styleable
    protected Color buttonSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonHoverArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonPressedArrowColor;
    @FlatStylingSupport.Styleable
    protected Color popupBackground;
    @FlatStylingSupport.Styleable
    protected Insets popupInsets;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc;
    private MouseListener hoverListener;
    protected boolean hover;
    protected boolean pressed;
    private CellPaddingBorder paddingBorder;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatComboBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
            return;
        }
        this.installUIImpl(jComponent);
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        FlatComboBoxUI flatComboBoxUI = this;
        this.comboBox.setKeySelectionManager(flatComboBoxUI.new FlatKeySelectionManager(flatComboBoxUI.comboBox.getKeySelectionManager()));
        this.installStyle();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.hoverListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FlatComboBoxUI.this.hover = true;
                this.repaintArrowButton();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FlatComboBoxUI.this.hover = false;
                this.repaintArrowButton();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FlatComboBoxUI.this.pressed = true;
                this.repaintArrowButton();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FlatComboBoxUI.this.pressed = false;
                this.repaintArrowButton();
            }

            private void repaintArrowButton() {
                if (FlatComboBoxUI.this.arrowButton != null && !FlatComboBoxUI.this.comboBox.isEditable()) {
                    FlatComboBoxUI.this.arrowButton.repaint();
                }
            }
        };
        this.comboBox.addMouseListener(this.hoverListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.hoverListener);
        this.hoverListener = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.comboBox, "opaque", Boolean.FALSE);
        this.minimumWidth = UIManager.getInt("ComboBox.minimumWidth");
        this.editorColumns = UIManager.getInt("ComboBox.editorColumns");
        this.buttonStyle = UIManager.getString("ComboBox.buttonStyle");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.background = UIManager.getColor("ComboBox.background");
        this.editableBackground = UIManager.getColor("ComboBox.editableBackground");
        this.focusedBackground = UIManager.getColor("ComboBox.focusedBackground");
        this.disabledBackground = UIManager.getColor("ComboBox.disabledBackground");
        this.disabledForeground = UIManager.getColor("ComboBox.disabledForeground");
        this.buttonBackground = UIManager.getColor("ComboBox.buttonBackground");
        this.buttonFocusedBackground = UIManager.getColor("ComboBox.buttonFocusedBackground");
        this.buttonEditableBackground = UIManager.getColor("ComboBox.buttonEditableBackground");
        this.buttonSeparatorWidth = FlatUIUtils.getUIFloat("ComboBox.buttonSeparatorWidth", FlatUIUtils.getUIFloat("Component.borderWidth", 1.0f));
        this.buttonSeparatorColor = UIManager.getColor("ComboBox.buttonSeparatorColor");
        this.buttonDisabledSeparatorColor = UIManager.getColor("ComboBox.buttonDisabledSeparatorColor");
        this.buttonArrowColor = UIManager.getColor("ComboBox.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("ComboBox.buttonDisabledArrowColor");
        this.buttonHoverArrowColor = UIManager.getColor("ComboBox.buttonHoverArrowColor");
        this.buttonPressedArrowColor = UIManager.getColor("ComboBox.buttonPressedArrowColor");
        this.popupBackground = UIManager.getColor("ComboBox.popupBackground");
        this.popupInsets = UIManager.getInsets("ComboBox.popupInsets");
        this.selectionInsets = UIManager.getInsets("ComboBox.selectionInsets");
        this.selectionArc = UIManager.getInt("ComboBox.selectionArc");
        int n = UIManager.getInt("ComboBox.maximumRowCount");
        if (n > 0 && n != 8 && this.comboBox.getMaximumRowCount() == 8) {
            this.comboBox.setMaximumRowCount(n);
        }
        this.paddingBorder = new CellPaddingBorder(this.padding);
        MigLayoutVisualPadding.install(this.comboBox);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.background = null;
        this.editableBackground = null;
        this.focusedBackground = null;
        this.disabledBackground = null;
        this.disabledForeground = null;
        this.buttonBackground = null;
        this.buttonEditableBackground = null;
        this.buttonFocusedBackground = null;
        this.buttonSeparatorColor = null;
        this.buttonDisabledSeparatorColor = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
        this.buttonHoverArrowColor = null;
        this.buttonPressedArrowColor = null;
        this.popupBackground = null;
        this.paddingBorder.uninstall();
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall(this.comboBox);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                if (FlatComboBoxUI.this.arrowButton != null && FlatComboBoxUI.this.comboBox.getFont() != null) {
                    FontMetrics fontMetrics = FlatComboBoxUI.this.comboBox.getFontMetrics(FlatComboBoxUI.this.comboBox.getFont());
                    int n = fontMetrics.getHeight() + UIScale.scale(((FlatComboBoxUI)FlatComboBoxUI.this).padding.top) + UIScale.scale(((FlatComboBoxUI)FlatComboBoxUI.this).padding.bottom);
                    int n2 = n * 3 / 4;
                    Insets insets = FlatComboBoxUI.this.getInsets();
                    int n3 = Math.min(Math.max(container.getHeight() - insets.top - insets.bottom, n2), n);
                    if (n3 != FlatComboBoxUI.this.arrowButton.getWidth()) {
                        n = FlatComboBoxUI.this.comboBox.getComponentOrientation().isLeftToRight() ? FlatComboBoxUI.this.arrowButton.getWidth() - n3 : 0;
                        FlatComboBoxUI.this.arrowButton.setBounds(FlatComboBoxUI.this.arrowButton.getX() + n, FlatComboBoxUI.this.arrowButton.getY(), n3, FlatComboBoxUI.this.arrowButton.getHeight());
                        if (FlatComboBoxUI.this.editor != null) {
                            FlatComboBoxUI.this.editor.setBounds(FlatComboBoxUI.this.rectangleForCurrentValue());
                        }
                    }
                }
            }
        };
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicComboBoxUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                if (FlatComboBoxUI.this.comboBox != null && FlatComboBoxUI.this.comboBox.isEditable()) {
                    FlatComboBoxUI.this.comboBox.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                if (FlatComboBoxUI.this.comboBox != null && FlatComboBoxUI.this.comboBox.isEditable()) {
                    FlatComboBoxUI.this.comboBox.repaint();
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            propertyChangeListener.propertyChange(propertyChangeEvent);
            propertyChangeListener = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (this.editor != null && (propertyChangeListener == this.comboBox && string == "foreground" || propertyChangeListener == this.editor && string == "enabled")) {
                this.updateEditorColors();
                return;
            }
            if (this.editor != null && propertyChangeListener == this.comboBox && string == "componentOrientation") {
                propertyChangeListener = (ComponentOrientation)propertyChangeEvent.getNewValue();
                this.editor.applyComponentOrientation((ComponentOrientation)((Object)propertyChangeListener));
                return;
            }
            switch (string) {
                case "JTextField.placeholderText": {
                    if (this.editor == null) break;
                    this.editor.repaint();
                    return;
                }
                case "JComponent.roundRect": 
                case "JComponent.outline": {
                    this.comboBox.repaint();
                    return;
                }
                case "JComponent.minimumWidth": {
                    this.comboBox.revalidate();
                    return;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.comboBox.revalidate();
                    this.comboBox.repaint();
                }
            }
        };
    }

    @Override
    protected ComboPopup createPopup() {
        FlatComboBoxUI flatComboBoxUI = this;
        return flatComboBoxUI.new FlatComboPopup(flatComboBoxUI.comboBox);
    }

    @Override
    protected void configureEditor() {
        Serializable serializable;
        super.configureEditor();
        if (this.editor instanceof JTextField) {
            serializable = (JTextField)this.editor;
            serializable.setColumns(this.editorColumns);
            Border border = serializable.getBorder();
            if (border == null || border instanceof UIResource) {
                serializable.setBorder(BorderFactory.createEmptyBorder());
            }
        }
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).setOpaque(false);
        }
        this.editor.applyComponentOrientation(this.comboBox.getComponentOrientation());
        this.updateEditorPadding();
        this.updateEditorColors();
        if (SystemInfo.isMacOS && this.editor instanceof JTextComponent) {
            serializable = ((JTextComponent)this.editor).getInputMap();
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("UP"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("KP_UP"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("DOWN"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("KP_DOWN"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("HOME"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("END"));
        }
    }

    private void updateEditorPadding() {
        if (!(this.editor instanceof JTextField)) {
            return;
        }
        JTextField jTextField = (JTextField)this.editor;
        Insets insets = jTextField.getInsets();
        Insets insets2 = this.padding;
        if (insets.top != 0 || insets.left != 0 || insets.bottom != 0 || insets.right != 0) {
            insets2 = new Insets(UIScale.unscale(Math.max(UIScale.scale(this.padding.top) - insets.top, 0)), UIScale.unscale(Math.max(UIScale.scale(this.padding.left) - insets.left, 0)), UIScale.unscale(Math.max(UIScale.scale(this.padding.bottom) - insets.bottom, 0)), UIScale.unscale(Math.max(UIScale.scale(this.padding.right) - insets.right, 0)));
        }
        jTextField.putClientProperty("JTextField.padding", insets2);
    }

    private void updateEditorColors() {
        boolean bl = this.editor instanceof JTextComponent;
        this.editor.setForeground(FlatUIUtils.nonUIResource(this.getForeground(bl || this.editor.isEnabled())));
        if (bl) {
            ((JTextComponent)this.editor).setDisabledTextColor(FlatUIUtils.nonUIResource(this.getForeground(false)));
        }
    }

    @Override
    protected JButton createArrowButton() {
        return new FlatComboBoxButton();
    }

    protected void installStyle() {
        try {
            FlatComboBoxUI flatComboBoxUI = this;
            flatComboBoxUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatComboBoxUI.comboBox, "ComboBox"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        Insets insets = this.padding;
        int n = this.editorColumns;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (!this.padding.equals(insets)) {
            this.paddingBorder.padding = this.padding;
            this.updateEditorPadding();
        }
        if (this.arrowButton instanceof FlatComboBoxButton) {
            ((FlatComboBoxButton)this.arrowButton).updateStyle();
        }
        if (this.popup instanceof FlatComboPopup) {
            ((FlatComboPopup)this.popup).updateStyle();
        }
        if (this.editorColumns != n && this.editor instanceof JTextField) {
            ((JTextField)this.editor).setColumns(this.editorColumns);
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.comboBox, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        FlatComboBoxUI flatComboBoxUI = this;
        return FlatStylingSupport.getAnnotatedStyleableInfos(flatComboBoxUI, flatComboBoxUI.comboBox.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        FlatComboBoxUI flatComboBoxUI = this;
        return FlatStylingSupport.getAnnotatedStyleableValue(flatComboBoxUI, flatComboBoxUI.comboBox.getBorder(), string);
    }

    @Override
    public MethodHandles.Lookup getLookupForStyling() {
        return MethodHandles.lookup();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        float f = FlatUIUtils.getBorderFocusWidth(jComponent);
        float f2 = FlatUIUtils.getBorderArc(jComponent);
        boolean bl = true;
        int n = jComponent.getParent() instanceof CellRendererPane;
        if (n != 0) {
            f = 0.0f;
            f2 = 0.0f;
            bl = this.isCellRendererBackgroundChanged();
        }
        if (jComponent.isOpaque() && (f > 0.0f || f2 > 0.0f)) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics2D);
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        int n4 = this.arrowButton.getX();
        int n5 = this.arrowButton.getWidth();
        boolean bl2 = (this.comboBox.isEditable() || "button".equals(this.buttonStyle)) && !"none".equals(this.buttonStyle) && !this.isMacStyle();
        boolean bl3 = this.comboBox.isEnabled();
        boolean bl4 = this.comboBox.getComponentOrientation().isLeftToRight();
        if (bl || jComponent.isOpaque()) {
            Color color;
            graphics2D.setColor(this.getBackground(bl3));
            FlatUIUtils.paintComponentBackground(graphics2D, 0, 0, n2, n3, f, f2);
            if (bl3 && n == 0) {
                Object object;
                Object object2 = bl2 ? this.buttonEditableBackground : ((this.buttonFocusedBackground != null || this.focusedBackground != null) && FlatComboBoxUI.isPermanentFocusOwner(this.comboBox) ? (this.buttonFocusedBackground != null ? this.buttonFocusedBackground : this.focusedBackground) : (object = this.buttonBackground));
                if (object2 != null) {
                    graphics2D.setColor((Color)object);
                    if (this.isMacStyle()) {
                        object = this.comboBox.getInsets();
                        n = UIScale.scale(2);
                        FlatUIUtils.paintComponentBackground(graphics2D, n4 + n, ((Insets)object).top + n, n5 - (n << 1), n3 - ((Insets)object).top - ((Insets)object).bottom - (n << 1), 0.0f, f2 - f);
                    } else {
                        object = graphics2D.getClip();
                        if (bl4) {
                            graphics2D.clipRect(n4, 0, n2 - n4, n3);
                        } else {
                            graphics2D.clipRect(0, 0, n4 + n5, n3);
                        }
                        FlatUIUtils.paintComponentBackground(graphics2D, 0, 0, n2, n3, f, f2);
                        graphics2D.setClip((Shape)object);
                    }
                }
            }
            if (bl2 && (color = bl3 ? this.buttonSeparatorColor : this.buttonDisabledSeparatorColor) != null && this.buttonSeparatorWidth > 0.0f) {
                graphics2D.setColor(color);
                float f3 = UIScale.scale(this.buttonSeparatorWidth);
                float f4 = bl4 ? (float)n4 : (float)(n4 + n5) - f3;
                graphics2D.fill(new Rectangle2D.Float(f4, f, f3, (float)(n3 - 1) - f * 2.0f));
            }
        }
        FlatUIUtils.resetRenderingHints(graphics2D, objectArray);
        this.paint(graphics, jComponent);
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        this.paddingBorder.uninstall();
        Component component = this.comboBox.getRenderer();
        if (component == null) {
            component = new DefaultListCellRenderer();
        }
        component = component.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        component.setFont(this.comboBox.getFont());
        component.applyComponentOrientation(this.comboBox.getComponentOrientation());
        boolean bl2 = this.comboBox.isEnabled();
        component.setBackground(this.getBackground(bl2));
        component.setForeground(this.getForeground(bl2));
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
        bl2 = component instanceof JPanel;
        this.paddingBorder.install(component, 0);
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
        this.paddingBorder.uninstall();
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(true);
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
    }

    protected Color getBackground(boolean bl) {
        if (bl) {
            if (FlatUIUtils.isAWTPeer(this.comboBox)) {
                return this.background;
            }
            Color color = this.comboBox.getBackground();
            if (!(color instanceof UIResource)) {
                return color;
            }
            if (this.focusedBackground != null && FlatComboBoxUI.isPermanentFocusOwner(this.comboBox)) {
                return this.focusedBackground;
            }
            if (this.editableBackground != null && this.comboBox.isEditable()) {
                return this.editableBackground;
            }
            return color;
        }
        return this.disabledBackground;
    }

    protected Color getForeground(boolean bl) {
        if (bl) {
            return this.comboBox.getForeground();
        }
        return this.disabledForeground;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        int n = Math.round(FlatUIUtils.getBorderFocusWidth(jComponent) * 2.0f);
        dimension.width = Math.max(dimension.width, UIScale.scale(FlatUIUtils.minimumWidth(jComponent, this.minimumWidth)) + n);
        return dimension;
    }

    @Override
    protected Dimension getDefaultSize() {
        this.paddingBorder.uninstall();
        Dimension dimension = super.getDefaultSize();
        this.paddingBorder.uninstall();
        return dimension;
    }

    @Override
    protected Dimension getDisplaySize() {
        this.paddingBorder.uninstall();
        Dimension dimension = super.getDisplaySize();
        this.paddingBorder.uninstall();
        int n = dimension.width - this.padding.left - this.padding.right;
        int n2 = dimension.height - this.padding.top - this.padding.bottom;
        if (n == 100 && this.comboBox.isEditable() && this.comboBox.getItemCount() == 0 && this.comboBox.getPrototypeDisplayValue() == null) {
            n = Math.max(this.getDefaultSize().width, this.editor.getPreferredSize().width);
        }
        return new Dimension(n, n2);
    }

    @Override
    protected Dimension getSizeForComponent(Component serializable) {
        this.paddingBorder.install((Component)serializable, 0);
        serializable = super.getSizeForComponent((Component)serializable);
        this.paddingBorder.uninstall();
        return serializable;
    }

    private boolean isCellRenderer() {
        return this.comboBox.getParent() instanceof CellRendererPane;
    }

    private boolean isCellRendererBackgroundChanged() {
        Container container = this.comboBox.getParent().getParent();
        return container != null && !this.comboBox.getBackground().equals(container.getBackground());
    }

    private boolean isMacStyle() {
        return "mac".equals(this.buttonStyle);
    }

    public static boolean isPermanentFocusOwner(JComboBox<?> component) {
        if (component.isEditable()) {
            if (FlatUIUtils.isPermanentFocusOwner(component)) {
                return true;
            }
            return (component = component.getEditor().getEditorComponent()) != null && FlatUIUtils.isPermanentFocusOwner(component);
        }
        return FlatUIUtils.isPermanentFocusOwner(component);
    }

    private class FlatKeySelectionManager
    implements JComboBox.KeySelectionManager,
    UIResource {
        private final JComboBox.KeySelectionManager delegate;
        private final long timeFactor;
        private long lastTime;

        FlatKeySelectionManager(JComboBox.KeySelectionManager keySelectionManager) {
            this.delegate = keySelectionManager;
            FlatComboBoxUI.this = (Long)UIManager.get("ComboBox.timeFactor");
            this.timeFactor = FlatComboBoxUI.this != null ? (Long)FlatComboBoxUI.this : 1000L;
        }

        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            long l = EventQueue.getMostRecentEventTime();
            long l2 = this.lastTime;
            this.lastTime = l;
            if (c == ' ' && l - l2 >= this.timeFactor && !FlatComboBoxUI.this.comboBox.isPopupVisible()) {
                FlatComboBoxUI.this.comboBox.setPopupVisible(true);
                return -1;
            }
            return this.delegate.selectionForKey(c, comboBoxModel);
        }
    }

    private class EditorDelegateAction
    extends AbstractAction {
        private final KeyStroke keyStroke;

        EditorDelegateAction(InputMap inputMap, KeyStroke keyStroke) {
            this.keyStroke = keyStroke;
            inputMap.put(keyStroke, this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionListener actionListener = FlatComboBoxUI.this.comboBox.getActionForKeyStroke(this.keyStroke);
            if (actionListener != null) {
                actionListener.actionPerformed(new ActionEvent(FlatComboBoxUI.this.comboBox, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
            }
        }
    }

    private static class MacCheckedItemIcon
    extends FlatCheckBoxMenuItemIcon {
        static MacCheckedItemIcon INSTANCE = new MacCheckedItemIcon();

        private MacCheckedItemIcon() {
        }

        @Override
        protected void paintIcon(Component component, Graphics2D graphics2D) {
            graphics2D.setColor(component.getForeground());
            this.paintCheckmark(graphics2D);
        }
    }

    private static class CellPaddingBorder
    extends AbstractBorder {
        static final String KEY_MAC_STYLE_HINT = "FlatLaf.internal.FlatComboBoxUI.macStyleHint";
        static final int MAC_STYLE_GAP = 4;
        private Insets padding;
        private JComponent rendererComponent;
        private Border rendererBorder;
        private int focusWidth;

        CellPaddingBorder(Insets insets) {
            this.padding = insets;
        }

        synchronized void install(Component component, int n) {
            if (!(component instanceof JComponent)) {
                return;
            }
            this.focusWidth = n;
            Border border = ((JComponent)(component = (JComponent)component)).getBorder();
            if (border == this) {
                return;
            }
            if (border instanceof CellPaddingBorder) {
                ((CellPaddingBorder)border).uninstall();
            }
            this.uninstall();
            this.rendererComponent = component;
            this.rendererBorder = ((JComponent)component).getBorder();
            ((JComponent)component).setBorder(this);
        }

        synchronized void uninstall() {
            if (this.rendererComponent == null) {
                return;
            }
            this.rendererComponent.putClientProperty(KEY_MAC_STYLE_HINT, null);
            if (this.rendererComponent.getBorder() == this) {
                this.rendererComponent.setBorder(this.rendererBorder);
            }
            this.rendererComponent = null;
            this.rendererBorder = null;
        }

        @Override
        public synchronized Insets getBorderInsets(Component component, Insets insets) {
            Serializable serializable;
            Insets insets2 = UIScale.scale(this.padding);
            if (this.rendererBorder != null && !(this.rendererBorder instanceof CellPaddingBorder)) {
                serializable = this.rendererBorder.getBorderInsets(component);
                insets.top = Math.max(insets2.top, serializable.top);
                insets.left = Math.max(insets2.left, serializable.left);
                insets.bottom = Math.max(insets2.bottom, serializable.bottom);
                insets.right = Math.max(insets2.right, serializable.right);
            } else {
                insets.top = insets2.top;
                insets.left = insets2.left;
                insets.bottom = insets2.bottom;
                insets.right = insets2.right;
            }
            insets.left += this.focusWidth;
            insets.right += this.focusWidth;
            if (component instanceof JComponent && (serializable = FlatClientProperties.clientPropertyBooleanStrict((JComponent)component, KEY_MAC_STYLE_HINT, null)) != null) {
                int n = MacCheckedItemIcon.INSTANCE.getIconWidth() + UIScale.scale(4);
                if (component.getComponentOrientation().isLeftToRight()) {
                    insets.left += n;
                } else {
                    insets.right += n;
                }
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Boolean bl;
            if (this.rendererBorder != null) {
                this.rendererBorder.paintBorder(component, graphics, n, n2, n3, n4);
            }
            if (component instanceof JComponent && (bl = FlatClientProperties.clientPropertyBooleanStrict((JComponent)component, KEY_MAC_STYLE_HINT, null)) == Boolean.TRUE) {
                n = component.getComponentOrientation().isLeftToRight() ? n + UIScale.scale(this.padding.left) : n + n3 - UIScale.scale(this.padding.right) - MacCheckedItemIcon.INSTANCE.getIconWidth();
                MacCheckedItemIcon.INSTANCE.paintIcon(component, graphics, n, n2 + (n4 - MacCheckedItemIcon.INSTANCE.getIconHeight()) / 2);
            }
        }
    }

    protected class FlatComboPopup
    extends BasicComboPopup {
        protected FlatComboPopup(JComboBox jComboBox) {
            super(jComboBox);
            FlatComboBoxUI.this = this.comboBox.getComponentOrientation();
            this.list.setComponentOrientation((ComponentOrientation)FlatComboBoxUI.this);
            this.scroller.setComponentOrientation((ComponentOrientation)FlatComboBoxUI.this);
            this.setComponentOrientation((ComponentOrientation)FlatComboBoxUI.this);
        }

        @Override
        protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            Insets insets;
            Serializable serializable;
            Object object;
            int n5 = FlatComboBoxUI.this.getDisplaySize().width;
            Border[] borderArray = new Border[]{this.scroller.getViewportBorder(), this.scroller.getBorder()};
            int cfr_ignored_0 = borderArray.length;
            for (int i = 0; i < 2; ++i) {
                Border border = borderArray[i];
                if (border == null) continue;
                object = border.getBorderInsets(null);
                n5 += ((Insets)object).left + ((Insets)object).right;
            }
            boolean bl = this.isPopupOverComboBox();
            int n6 = -1;
            if (bl && (n6 = this.comboBox.getSelectedIndex()) >= 0) {
                n5 += MacCheckedItemIcon.INSTANCE.getIconWidth() + UIScale.scale(4);
            }
            if ((serializable = this.scroller.getVerticalScrollBar()) != null) {
                n5 += serializable.getPreferredSize().width;
            }
            int n7 = n3;
            if (n5 > n3) {
                object = this.comboBox.getGraphicsConfiguration();
                if (object != null) {
                    serializable = ((GraphicsConfiguration)object).getBounds();
                    insets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)object);
                    n5 = Math.min(n5, ((Rectangle)serializable).width - insets.left - insets.right);
                } else {
                    serializable = Toolkit.getDefaultToolkit().getScreenSize();
                    n5 = Math.min(n5, ((Dimension)serializable).width);
                }
                int n8 = n5 - n3;
                n3 = n5;
                if (!this.comboBox.getComponentOrientation().isLeftToRight()) {
                    n -= n8;
                }
            }
            if (bl && n6 >= 0 && (object = this.list.getCellBounds(0, 0)) != null) {
                Insets insets2 = this.comboBox.getInsets();
                insets = this.list.getInsets();
                Insets insets3 = this.getInsets();
                int n9 = Math.min(n3 - n7, MacCheckedItemIcon.INSTANCE.getIconWidth()) + UIScale.scale(4);
                n = this.comboBox.getComponentOrientation().isLeftToRight() ? (n -= n9 + insets2.right + insets.right) : (n += n9 + insets2.left + insets.left);
                return new Rectangle(n, n2 -= ((Rectangle)object).height * (n6 + 1) + insets2.top + insets.top + insets3.top, n3, n4);
            }
            return super.computePopupBounds(n, n2, n3, n4);
        }

        @Override
        protected void configurePopup() {
            super.configurePopup();
            this.setOpaque(true);
            Border border = UIManager.getBorder("PopupMenu.border");
            if (border != null) {
                this.setBorder(FlatUIUtils.nonUIResource(border));
            }
            this.list.setCellRenderer(new PopupListCellRenderer());
            this.updateStyle();
        }

        void updateStyle() {
            if (FlatComboBoxUI.this.popupBackground != null) {
                this.list.setBackground(FlatComboBoxUI.this.popupBackground);
            }
            FlatComboPopup flatComboPopup = this;
            flatComboPopup.setBackground(FlatUIUtils.nonUIResource(flatComboPopup.list.getBackground()));
            this.scroller.setViewportBorder(FlatComboBoxUI.this.popupInsets != null ? new FlatEmptyBorder(FlatComboBoxUI.this.popupInsets) : null);
            this.scroller.setOpaque(false);
            if (this.list.getUI() instanceof FlatListUI) {
                FlatListUI flatListUI = (FlatListUI)this.list.getUI();
                ((FlatListUI)this.list.getUI()).selectionInsets = FlatComboBoxUI.this.selectionInsets;
                flatListUI.selectionArc = FlatComboBoxUI.this.selectionArc;
            }
        }

        @Override
        protected PropertyChangeListener createPropertyChangeListener() {
            PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
            return propertyChangeEvent -> {
                propertyChangeListener.propertyChange(propertyChangeEvent);
                if (propertyChangeEvent.getPropertyName() == "renderer") {
                    this.list.setCellRenderer(new PopupListCellRenderer());
                }
            };
        }

        @Override
        protected int getPopupHeightForRowCount(int n) {
            n = super.getPopupHeightForRowCount(n);
            FlatComboBoxUI.this.paddingBorder.uninstall();
            return n;
        }

        @Override
        public void show(Component component, int n, int n2) {
            int n3;
            Border border;
            if (n2 < 0 && !SystemInfo.isJava_9_orLater && (border = this.getBorder()) != null) {
                Insets insets = border.getBorderInsets(this);
                n2 -= insets.top + insets.bottom;
            }
            if (this.list.getHeight() == 0 && (n3 = this.list.getSelectedIndex()) > 0) {
                int n4 = this.comboBox.getMaximumRowCount();
                if (n3 < n4) {
                    this.list.scrollRectToVisible(new Rectangle());
                } else if ((n3 = Math.max(n3 - n4 / 2, 0)) > 0) {
                    this.list.ensureIndexIsVisible(n3);
                }
            }
            super.show(component, n, n2);
        }

        @Override
        protected void paintChildren(Graphics graphics) {
            super.paintChildren(graphics);
            FlatComboBoxUI.this.paddingBorder.uninstall();
        }

        private boolean isPopupOverComboBox() {
            return FlatComboBoxUI.this.isMacStyle() && !this.comboBox.isEditable() && this.comboBox.getItemCount() > 0 && this.comboBox.getItemCount() <= this.comboBox.getMaximumRowCount() && !FlatClientProperties.clientPropertyBoolean(this.comboBox, "JComboBox.isPopDown", false);
        }

        private class PopupListCellRenderer
        implements ListCellRenderer {
            private PopupListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList component, Object object, int n, boolean bl, boolean bl2) {
                FlatComboBoxUI.this.paddingBorder.uninstall();
                DefaultListCellRenderer defaultListCellRenderer = FlatComboPopup.this.comboBox.getRenderer();
                if (defaultListCellRenderer == null) {
                    defaultListCellRenderer = new DefaultListCellRenderer();
                }
                component = defaultListCellRenderer.getListCellRendererComponent(component, object, n, bl, bl2);
                ((Component)component).applyComponentOrientation(FlatComboPopup.this.comboBox.getComponentOrientation());
                if (FlatComboPopup.this.isPopupOverComboBox() && component instanceof JComponent) {
                    int n2 = FlatComboPopup.this.comboBox.getSelectedIndex();
                    ((JComponent)component).putClientProperty("FlatLaf.internal.FlatComboBoxUI.macStyleHint", n2 >= 0 ? Boolean.valueOf(n == n2) : null);
                }
                FlatComboBoxUI.this.paddingBorder.install(component, Math.round(FlatUIUtils.getBorderFocusWidth(FlatComboPopup.this.comboBox)));
                return component;
            }
        }
    }

    protected class FlatComboBoxButton
    extends FlatArrowButton {
        protected FlatComboBoxButton() {
            this(5, flatComboBoxUI.arrowType, flatComboBoxUI.buttonArrowColor, flatComboBoxUI.buttonDisabledArrowColor, flatComboBoxUI.buttonHoverArrowColor, null, flatComboBoxUI.buttonPressedArrowColor, null);
        }

        protected FlatComboBoxButton(int n, String string, Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
            super(n, string, color, color2, color3, color4, color5, color6);
        }

        protected void updateStyle() {
            FlatComboBoxButton flatComboBoxButton = this;
            flatComboBoxButton.updateStyle(flatComboBoxButton.FlatComboBoxUI.this.arrowType, FlatComboBoxUI.this.buttonArrowColor, FlatComboBoxUI.this.buttonDisabledArrowColor, FlatComboBoxUI.this.buttonHoverArrowColor, null, FlatComboBoxUI.this.buttonPressedArrowColor, null);
        }

        @Override
        public int getArrowWidth() {
            if (FlatComboBoxUI.this.isMacStyle()) {
                if (this.getWidth() % 2 == 0) {
                    return 6;
                }
                return 7;
            }
            return super.getArrowWidth();
        }

        @Override
        public float getArrowThickness() {
            if (FlatComboBoxUI.this.isMacStyle()) {
                return 1.5f;
            }
            return super.getArrowThickness();
        }

        @Override
        public boolean isRoundBorderAutoXOffset() {
            if (FlatComboBoxUI.this.isMacStyle()) {
                return false;
            }
            return super.isRoundBorderAutoXOffset();
        }

        @Override
        protected boolean isHover() {
            return super.isHover() || !FlatComboBoxUI.this.comboBox.isEditable() && FlatComboBoxUI.this.hover;
        }

        @Override
        protected boolean isPressed() {
            return super.isPressed() || !FlatComboBoxUI.this.comboBox.isEditable() && FlatComboBoxUI.this.pressed;
        }

        @Override
        protected Color getArrowColor() {
            if (FlatComboBoxUI.this.isCellRenderer() && FlatComboBoxUI.this.isCellRendererBackgroundChanged()) {
                return FlatComboBoxUI.this.comboBox.getForeground();
            }
            return super.getArrowColor();
        }

        @Override
        protected void paintArrow(Graphics2D graphics2D) {
            if (FlatComboBoxUI.this.isMacStyle() && !FlatComboBoxUI.this.comboBox.isEditable()) {
                int n = this.getHeight();
                int n2 = Math.round((float)n / 2.0f);
                FlatUIUtils.paintArrow(graphics2D, 0, 0, this.getWidth(), n2, 1, this.chevron, ((FlatArrowButton)this).getArrowWidth(), ((FlatArrowButton)this).getArrowThickness(), this.getXOffset(), this.getYOffset() + 1.25f);
                FlatUIUtils.paintArrow(graphics2D, 0, n - n2, this.getWidth(), n2, 5, this.chevron, ((FlatArrowButton)this).getArrowWidth(), ((FlatArrowButton)this).getArrowThickness(), this.getXOffset(), this.getYOffset() - 1.25f);
                return;
            }
            super.paintArrow(graphics2D);
        }
    }
}

