/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class FlatSeparatorUI
extends BasicSeparatorUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    @FlatStylingSupport.Styleable
    protected int height;
    @FlatStylingSupport.Styleable
    protected int stripeWidth;
    @FlatStylingSupport.Styleable
    protected int stripeIndent;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        if (FlatUIUtils.canUseSharedUI(jComponent)) {
            return FlatUIUtils.createSharedUI(FlatSeparatorUI.class, () -> new FlatSeparatorUI(true));
        }
        return new FlatSeparatorUI(false);
    }

    protected FlatSeparatorUI(boolean bl) {
        this.shared = bl;
    }

    protected String getPropertyPrefix() {
        return "Separator";
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle((JSeparator)jComponent);
    }

    @Override
    protected void installDefaults(JSeparator object) {
        super.installDefaults((JSeparator)object);
        if (!this.defaults_initialized) {
            object = this.getPropertyPrefix();
            this.height = UIManager.getInt((String)object + ".height");
            this.stripeWidth = UIManager.getInt((String)object + ".stripeWidth");
            this.stripeIndent = UIManager.getInt((String)object + ".stripeIndent");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(JSeparator jSeparator) {
        super.uninstallDefaults(jSeparator);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners(JSeparator jSeparator) {
        super.installListeners(jSeparator);
        jSeparator.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSeparator jSeparator) {
        super.uninstallListeners(jSeparator);
        jSeparator.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent serializable) {
        switch (((PropertyChangeEvent)serializable).getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                serializable = (JSeparator)((EventObject)serializable).getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty((JComponent)serializable)) {
                    ((JSeparator)serializable).updateUI();
                } else {
                    this.installStyle((JSeparator)serializable);
                }
                ((JComponent)serializable).revalidate();
                ((Component)serializable).repaint();
            }
        }
    }

    protected void installStyle(JSeparator jSeparator) {
        try {
            JSeparator jSeparator2 = jSeparator;
            this.applyStyle(jSeparator2, FlatStylingSupport.getResolvedStyle(jSeparator2, this.getStyleType()));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    String getStyleType() {
        return "Separator";
    }

    protected void applyStyle(JSeparator jSeparator, Object object2) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object2, (string, object) -> this.applyStyleProperty(jSeparator, (String)string, object));
    }

    protected Object applyStyleProperty(JSeparator jSeparator, String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, jSeparator, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        graphics = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics);
            graphics.setColor(jComponent.getForeground());
            float f = UIScale.scale((float)this.stripeWidth);
            float f2 = UIScale.scale((float)this.stripeIndent);
            if (((JSeparator)jComponent).getOrientation() == 1) {
                ((Graphics2D)graphics).fill(new Rectangle2D.Float(f2, 0.0f, f, jComponent.getHeight()));
            } else {
                ((Graphics2D)graphics).fill(new Rectangle2D.Float(0.0f, f2, jComponent.getWidth(), f));
            }
            return;
        }
        finally {
            graphics.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return new Dimension(UIScale.scale(this.height), 0);
        }
        return new Dimension(0, UIScale.scale(this.height));
    }
}

