/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class FlatSliderUI
extends BasicSliderUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int trackWidth;
    @FlatStylingSupport.Styleable
    protected Dimension thumbSize;
    @FlatStylingSupport.Styleable
    protected int focusWidth;
    @FlatStylingSupport.Styleable
    protected float thumbBorderWidth;
    @FlatStylingSupport.Styleable
    protected Color trackValueColor;
    @FlatStylingSupport.Styleable
    protected Color trackColor;
    @FlatStylingSupport.Styleable
    protected Color thumbColor;
    @FlatStylingSupport.Styleable
    protected Color thumbBorderColor;
    protected Color focusBaseColor;
    @FlatStylingSupport.Styleable
    protected Color focusedColor;
    @FlatStylingSupport.Styleable
    protected Color focusedThumbBorderColor;
    @FlatStylingSupport.Styleable
    protected Color hoverThumbColor;
    @FlatStylingSupport.Styleable
    protected Color pressedThumbColor;
    @FlatStylingSupport.Styleable
    protected Color disabledTrackColor;
    @FlatStylingSupport.Styleable
    protected Color disabledThumbColor;
    @FlatStylingSupport.Styleable
    protected Color disabledThumbBorderColor;
    @FlatStylingSupport.Styleable
    protected Color tickColor;
    private Color defaultBackground;
    private Color defaultForeground;
    protected boolean thumbHover;
    protected boolean thumbPressed;
    private Object[] oldRenderingHints;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatSliderUI();
    }

    public FlatSliderUI() {
        super(null);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        LookAndFeel.installProperty(jSlider, "opaque", Boolean.FALSE);
        this.trackWidth = UIManager.getInt("Slider.trackWidth");
        this.thumbSize = UIManager.getDimension("Slider.thumbSize");
        if (this.thumbSize == null) {
            int n;
            int n2 = n = UIManager.getInt("Slider.thumbWidth");
            this.thumbSize = new Dimension(n2, n2);
        }
        this.focusWidth = FlatUIUtils.getUIInt("Slider.focusWidth", 4);
        this.thumbBorderWidth = FlatUIUtils.getUIFloat("Slider.thumbBorderWidth", 1.0f);
        this.trackValueColor = FlatUIUtils.getUIColor("Slider.trackValueColor", "Slider.thumbColor");
        this.trackColor = UIManager.getColor("Slider.trackColor");
        this.thumbColor = UIManager.getColor("Slider.thumbColor");
        this.thumbBorderColor = UIManager.getColor("Slider.thumbBorderColor");
        this.focusBaseColor = UIManager.getColor("Component.focusColor");
        this.focusedColor = FlatUIUtils.getUIColor("Slider.focusedColor", this.focusBaseColor);
        this.focusedThumbBorderColor = FlatUIUtils.getUIColor("Slider.focusedThumbBorderColor", "Component.focusedBorderColor");
        this.hoverThumbColor = UIManager.getColor("Slider.hoverThumbColor");
        this.pressedThumbColor = UIManager.getColor("Slider.pressedThumbColor");
        this.disabledTrackColor = UIManager.getColor("Slider.disabledTrackColor");
        this.disabledThumbColor = UIManager.getColor("Slider.disabledThumbColor");
        this.disabledThumbBorderColor = FlatUIUtils.getUIColor("Slider.disabledThumbBorderColor", "Component.disabledBorderColor");
        this.tickColor = FlatUIUtils.getUIColor("Slider.tickColor", Color.BLACK);
        this.defaultBackground = UIManager.getColor("Slider.background");
        this.defaultForeground = UIManager.getColor("Slider.foreground");
    }

    @Override
    protected void uninstallDefaults(JSlider jSlider) {
        super.uninstallDefaults(jSlider);
        this.trackValueColor = null;
        this.trackColor = null;
        this.thumbColor = null;
        this.thumbBorderColor = null;
        this.focusBaseColor = null;
        this.focusedColor = null;
        this.focusedThumbBorderColor = null;
        this.hoverThumbColor = null;
        this.pressedThumbColor = null;
        this.disabledTrackColor = null;
        this.disabledThumbColor = null;
        this.disabledThumbBorderColor = null;
        this.tickColor = null;
        this.defaultBackground = null;
        this.defaultForeground = null;
        this.oldStyleValues = null;
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new FlatTrackListener();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return FlatStylingSupport.createPropertyChangeListener(jSlider, this::installStyle, super.createPropertyChangeListener(jSlider));
    }

    protected void installStyle() {
        try {
            FlatSliderUI flatSliderUI = this;
            flatSliderUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatSliderUI.slider, "Slider"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        FlatSliderUI flatSliderUI = this;
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(flatSliderUI, flatSliderUI.slider, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public int getBaseline(JComponent serializable, int n, int n2) {
        if (serializable == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (this.slider.getOrientation() == 1) {
            return -1;
        }
        serializable = UIManager.getFont("defaultFont");
        if (serializable == null) {
            serializable = this.slider.getFont();
        }
        serializable = this.slider.getFontMetrics((Font)serializable);
        Insets insets = this.slider.getInsets();
        int n3 = this.getThumbSize().height;
        n2 = n2 - insets.top - insets.bottom - this.focusInsets.top - this.focusInsets.bottom;
        int n4 = n3 + (this.slider.getPaintTicks() ? this.getTickLength() : 0) + (this.slider.getPaintLabels() ? this.getHeightOfTallestLabel() : 0);
        int n5 = insets.top + this.focusInsets.top + (n2 - n4 - 1) / 2;
        n2 = n3;
        return n5 + Math.round((float)(n2 - ((FontMetrics)serializable).getHeight()) / 2.0f) + ((FontMetrics)serializable).getAscent() - 1;
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return UIScale.scale(super.getPreferredHorizontalSize());
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return UIScale.scale(super.getPreferredVerticalSize());
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return UIScale.scale(super.getMinimumHorizontalSize());
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return UIScale.scale(super.getMinimumVerticalSize());
    }

    @Override
    protected int getTickLength() {
        return UIScale.scale(super.getTickLength());
    }

    @Override
    protected Dimension getThumbSize() {
        return FlatSliderUI.calcThumbSize(this.slider, this.thumbSize, this.focusWidth);
    }

    public static Dimension calcThumbSize(JSlider jSlider, Dimension dimension, int n) {
        n = UIScale.scale(n);
        int n2 = UIScale.scale(dimension.width) + n + n;
        int n3 = UIScale.scale(dimension.height) + n + n;
        if (jSlider.getOrientation() == 0) {
            return new Dimension(n2, n3);
        }
        return new Dimension(n3, n2);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.oldRenderingHints = FlatUIUtils.setRenderingHints(graphics);
        super.paint(graphics, jComponent);
        FlatUIUtils.resetRenderingHints(graphics, this.oldRenderingHints);
        this.oldRenderingHints = null;
    }

    @Override
    public void paintLabels(Graphics graphics) {
        FlatUIUtils.runWithoutRenderingHints(graphics, this.oldRenderingHints, () -> super.paintLabels(graphics));
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    @Override
    public void paintTrack(Graphics graphics) {
        RoundRectangle2D.Float float_;
        float f;
        boolean bl = this.slider.isEnabled();
        float f2 = UIScale.scale((float)this.trackWidth);
        RoundRectangle2D.Float float_2 = null;
        if (this.slider.getOrientation() == 0) {
            f = (float)this.trackRect.y + ((float)this.trackRect.height - f2) / 2.0f;
            if (bl && this.isRoundThumb()) {
                if (this.slider.getComponentOrientation().isLeftToRight()) {
                    int n = this.thumbRect.x + this.thumbRect.width / 2 - this.trackRect.x;
                    float f3 = f2;
                    float_2 = new RoundRectangle2D.Float(this.trackRect.x, f, n, f3, f3, f2);
                    float f4 = f2;
                    float_ = new RoundRectangle2D.Float(this.trackRect.x + n, f, this.trackRect.width - n, f4, f4, f2);
                } else {
                    int n = this.trackRect.x + this.trackRect.width - this.thumbRect.x - this.thumbRect.width / 2;
                    float f5 = f2;
                    float_2 = new RoundRectangle2D.Float(this.trackRect.x + this.trackRect.width - n, f, n, f5, f5, f2);
                    float f6 = f2;
                    float_ = new RoundRectangle2D.Float(this.trackRect.x, f, this.trackRect.width - n, f6, f6, f2);
                }
            } else {
                float f7 = f2;
                float_ = new RoundRectangle2D.Float(this.trackRect.x, f, this.trackRect.width, f7, f7, f2);
            }
        } else {
            f = (float)this.trackRect.x + ((float)this.trackRect.width - f2) / 2.0f;
            if (bl && this.isRoundThumb()) {
                int n = this.thumbRect.y + this.thumbRect.height / 2 - this.trackRect.y;
                float f8 = f2;
                float_ = new RoundRectangle2D.Float(f, this.trackRect.y, f2, n, f8, f8);
                float f9 = f2;
                float_2 = new RoundRectangle2D.Float(f, this.trackRect.y + n, f2, this.trackRect.height - n, f9, f9);
            } else {
                float f10 = f2;
                float_ = new RoundRectangle2D.Float(f, this.trackRect.y, f2, this.trackRect.height, f10, f10);
            }
        }
        if (float_2 != null) {
            if (this.slider.getInverted()) {
                RoundRectangle2D.Float float_3 = float_;
                float_ = float_2;
                float_2 = float_3;
            }
            graphics.setColor(this.getTrackValueColor());
            ((Graphics2D)graphics).fill(float_2);
        }
        graphics.setColor(bl ? this.getTrackColor() : this.disabledTrackColor);
        ((Graphics2D)graphics).fill(float_);
    }

    @Override
    public void paintTicks(Graphics graphics) {
        super.paintTicks(new Graphics2DProxy((Graphics2D)graphics){

            @Override
            public void setColor(Color color) {
                1 v0 = this;
                super.setColor(v0.FlatSliderUI.this.tickColor);
            }
        });
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Color color = this.getThumbColor();
        Color color2 = FlatSliderUI.stateColor(this.slider, this.thumbHover, this.thumbPressed, color, this.disabledThumbColor, null, this.hoverThumbColor, this.pressedThumbColor);
        color2 = FlatUIUtils.deriveColor(color2, color);
        color = this.slider.getForeground();
        Color color3 = this.thumbBorderColor != null && color == this.defaultForeground ? FlatSliderUI.stateColor(this.slider, false, false, this.thumbBorderColor, this.disabledThumbBorderColor, this.focusedThumbBorderColor, null, null) : null;
        color = FlatUIUtils.deriveColor(this.focusedColor, color != this.defaultForeground ? color : this.focusBaseColor);
        FlatSliderUI.paintThumb(graphics, this.slider, this.thumbRect, this.isRoundThumb(), color2, color3, color, this.thumbBorderWidth, this.focusWidth);
    }

    public static void paintThumb(Graphics graphics, JSlider jSlider, Rectangle rectangle, boolean bl, Color color, Color color2, Color color3, float f, int n) {
        double d2 = UIScale.getSystemScaleFactor((Graphics2D)graphics);
        if (d2 != 1.0 && d2 != 2.0) {
            HiDPIUtils.paintAtScale1x((Graphics2D)graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, (graphics2D, n2, n3, n4, n5, d) -> FlatSliderUI.paintThumbImpl(graphics, jSlider, n2, n3, n4, n5, bl, color, color2, color3, (float)((double)f * d), (float)((double)n * d)));
            return;
        }
        FlatSliderUI.paintThumbImpl(graphics, jSlider, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl, color, color2, color3, f, n);
    }

    private static void paintThumbImpl(Graphics graphics, JSlider jSlider, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2, Color color3, float f, float f2) {
        int n5 = Math.round(UIScale.scale(f2));
        int n6 = n + n5;
        int n7 = n2 + n5;
        int n8 = n3 - n5 - n5;
        int n9 = n4 - n5 - n5;
        boolean bl2 = FlatUIUtils.isPermanentFocusOwner(jSlider);
        if (bl) {
            if (bl2) {
                graphics.setColor(color3);
                ((Graphics2D)graphics).fill(FlatSliderUI.createRoundThumbShape(n, n2, n3, n4));
            }
            if (color2 != null) {
                graphics.setColor(color2);
                ((Graphics2D)graphics).fill(FlatSliderUI.createRoundThumbShape(n6, n7, n8, n9));
                float f3 = UIScale.scale(f);
                graphics.setColor(color);
                ((Graphics2D)graphics).fill(FlatSliderUI.createRoundThumbShape((float)n6 + f3, (float)n7 + f3, (float)n8 - f3 - f3, (float)n9 - f3 - f3));
                return;
            }
            graphics.setColor(color);
            ((Graphics2D)graphics).fill(FlatSliderUI.createRoundThumbShape(n6, n7, n8, n9));
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.translate(n, n2);
            if (jSlider.getOrientation() == 1) {
                if (jSlider.getComponentOrientation().isLeftToRight()) {
                    graphics2D.translate(0, n4);
                    graphics2D.rotate(Math.toRadians(270.0));
                } else {
                    graphics2D.translate(n3, 0);
                    graphics2D.rotate(Math.toRadians(90.0));
                }
                int n10 = n8;
                n8 = n9;
                n9 = n10;
            }
            if (bl2) {
                graphics2D.setColor(color3);
                graphics2D.fill(FlatSliderUI.createDirectionalThumbShape(0.0f, 0.0f, n8 + n5 + n5, (float)(n9 + n5 + n5) + (float)n5 * 0.4142f, n5));
            }
            if (color2 != null) {
                graphics2D.setColor(color2);
                graphics2D.fill(FlatSliderUI.createDirectionalThumbShape(n5, n5, n8, n9, 0.0f));
                float f4 = UIScale.scale(f);
                graphics2D.setColor(color);
                graphics2D.fill(FlatSliderUI.createDirectionalThumbShape((float)n5 + f4, (float)n5 + f4, (float)n8 - f4 - f4, (float)n9 - f4 - f4 - f4 * 0.4142f, 0.0f));
            } else {
                graphics2D.setColor(color);
                graphics2D.fill(FlatSliderUI.createDirectionalThumbShape(n5, n5, n8, n9, 0.0f));
            }
            return;
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static Shape createRoundThumbShape(float f, float f2, float f3, float f4) {
        float f5;
        if (f3 == f4) {
            return new Ellipse2D.Float(f, f2, f3, f4);
        }
        float f6 = f5 = Math.min(f3, f4);
        return new RoundRectangle2D.Float(f, f2, f3, f4, f6, f6);
    }

    public static Shape createDirectionalThumbShape(float f, float f2, float f3, float f4, float f5) {
        float f6 = f3 / 2.0f;
        Path2D.Float float_ = new Path2D.Float(1, 9);
        ((Path2D)float_).moveTo(f + f6, f2 + f4);
        ((Path2D)float_).lineTo(f, f2 + (f4 - f6));
        ((Path2D)float_).lineTo(f, f2 + f5);
        ((Path2D)float_).quadTo(f, f2, f + f5, f2);
        ((Path2D)float_).lineTo(f + (f3 - f5), f2);
        ((Path2D)float_).quadTo(f + f3, f2, f + f3, f2 + f5);
        ((Path2D)float_).lineTo(f + f3, f2 + (f4 - f6));
        float_.closePath();
        return float_;
    }

    protected Color getTrackValueColor() {
        Color color = this.slider.getForeground();
        if (color != this.defaultForeground) {
            return color;
        }
        return this.trackValueColor;
    }

    protected Color getTrackColor() {
        Color color = this.slider.getBackground();
        if (color != this.defaultBackground) {
            return color;
        }
        return this.trackColor;
    }

    protected Color getThumbColor() {
        Color color = this.slider.getForeground();
        if (color != this.defaultForeground) {
            return color;
        }
        return this.thumbColor;
    }

    public static Color stateColor(JSlider jSlider, boolean bl, boolean bl2, Color color, Color color2, Color color3, Color color4, Color color5) {
        if (color2 != null && !jSlider.isEnabled()) {
            return color2;
        }
        if (color5 != null && bl2) {
            return color5;
        }
        if (color4 != null && bl) {
            return color4;
        }
        if (color3 != null && FlatUIUtils.isPermanentFocusOwner(jSlider)) {
            return color3;
        }
        return color;
    }

    protected boolean isRoundThumb() {
        return !this.slider.getPaintTicks() && !this.slider.getPaintLabels();
    }

    @Override
    public void setThumbLocation(int n, int n2) {
        if (!this.isRoundThumb()) {
            Rectangle rectangle = new Rectangle(this.thumbRect);
            this.thumbRect.setLocation(n, n2);
            SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, rectangle);
            n = (int)Math.ceil((float)UIScale.scale(this.focusWidth) * 0.4142f);
            if (this.slider.getOrientation() == 0) {
                rectangle.height += n;
            } else {
                rectangle.width += n;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    rectangle.x -= n;
                }
            }
            this.slider.repaint(rectangle);
            return;
        }
        super.setThumbLocation(n, n2);
    }

    protected class FlatTrackListener
    extends BasicSliderUI.TrackListener {
        protected FlatTrackListener() {
            super(FlatSliderUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            FlatTrackListener flatTrackListener = this;
            flatTrackListener.setThumbHover(flatTrackListener.isOverThumb(mouseEvent));
            super.mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.setThumbHover(false);
            super.mouseExited(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            FlatTrackListener flatTrackListener = this;
            flatTrackListener.setThumbHover(flatTrackListener.isOverThumb(mouseEvent));
            super.mouseMoved(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            FlatTrackListener flatTrackListener = this;
            flatTrackListener.setThumbPressed(flatTrackListener.isOverThumb(mouseEvent));
            if (!FlatSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (UIManager.getBoolean("Slider.scrollOnTrackClick")) {
                super.mousePressed(mouseEvent);
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            FlatSliderUI.this.calculateGeometry();
            if (FlatSliderUI.this.thumbRect.contains(n, n2)) {
                super.mousePressed(mouseEvent);
                return;
            }
            if (UIManager.getBoolean("Slider.onlyLeftMouseButtonDrag") && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            n = ((FlatSliderUI)FlatSliderUI.this).thumbRect.x + ((FlatSliderUI)FlatSliderUI.this).thumbRect.width / 2 - n;
            n2 = ((FlatSliderUI)FlatSliderUI.this).thumbRect.y + ((FlatSliderUI)FlatSliderUI.this).thumbRect.height / 2 - n2;
            mouseEvent.translatePoint(n, n2);
            super.mousePressed(mouseEvent);
            mouseEvent.translatePoint(-n, -n2);
            this.mouseDragged(mouseEvent);
            this.setThumbPressed(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.setThumbPressed(false);
            super.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            if (FlatSliderUI.this.isDragging() && FlatSliderUI.this.slider.getSnapToTicks() && FlatSliderUI.this.slider.isEnabled() && !UIManager.getBoolean("Slider.snapToTicksOnReleased")) {
                FlatSliderUI.this.calculateThumbLocation();
                FlatSliderUI.this.slider.repaint();
            }
        }

        protected void setThumbHover(boolean bl) {
            if (bl != FlatSliderUI.this.thumbHover) {
                FlatSliderUI.this.thumbHover = bl;
                FlatSliderUI.this.slider.repaint(FlatSliderUI.this.thumbRect);
            }
        }

        protected void setThumbPressed(boolean bl) {
            if (bl != FlatSliderUI.this.thumbPressed) {
                FlatSliderUI.this.thumbPressed = bl;
                FlatSliderUI.this.slider.repaint(FlatSliderUI.this.thumbRect);
            }
        }

        protected boolean isOverThumb(MouseEvent mouseEvent) {
            return mouseEvent != null && FlatSliderUI.this.slider.isEnabled() && FlatSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

