/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.ui.FlatNativeWindowsLibrary;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import java.util.Locale;
import java.util.StringTokenizer;

public class SystemInfo {
    public static final boolean isWindows;
    public static final boolean isMacOS;
    public static final boolean isLinux;
    public static final long osVersion;
    public static final boolean isWindows_10_orLater;
    public static final boolean isWindows_11_orLater;
    public static final boolean isMacOS_10_11_ElCapitan_orLater;
    public static final boolean isMacOS_10_14_Mojave_orLater;
    public static final boolean isMacOS_10_15_Catalina_orLater;
    public static final boolean isX86;
    public static final boolean isX86_64;
    public static final boolean isAARCH64;
    public static final long javaVersion;
    public static final boolean isJava_9_orLater;
    public static final boolean isJava_11_orLater;
    public static final boolean isJava_12_orLater;
    public static final boolean isJava_15_orLater;
    public static final boolean isJava_17_orLater;
    public static final boolean isJava_18_orLater;
    public static final boolean isJetBrainsJVM;
    public static final boolean isJetBrainsJVM_11_orLater;
    public static final boolean isKDE;
    public static final boolean isProjector;
    public static final boolean isWebswing;
    public static final boolean isWinPE;
    public static final boolean isMacFullWindowContentSupported;

    public static long scanVersion(String object) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            object = new StringTokenizer((String)object, "._-+");
            n = Integer.parseInt(((StringTokenizer)object).nextToken());
            n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
            n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
            n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
        }
        catch (Exception exception) {}
        return SystemInfo.toVersion(n, n2, n3, n4);
    }

    public static long toVersion(int n, int n2, int n3, int n4) {
        return ((long)n << 48) + ((long)n2 << 32) + ((long)n3 << 16) + (long)n4;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        isWindows = string.startsWith("windows");
        isMacOS = string.startsWith("mac");
        isLinux = string.startsWith("linux");
        osVersion = SystemInfo.scanVersion(System.getProperty("os.version"));
        isWindows_10_orLater = isWindows && osVersion >= SystemInfo.toVersion(10, 0, 0, 0);
        isMacOS_10_11_ElCapitan_orLater = isMacOS && osVersion >= SystemInfo.toVersion(10, 11, 0, 0);
        isMacOS_10_14_Mojave_orLater = isMacOS && osVersion >= SystemInfo.toVersion(10, 14, 0, 0);
        isMacOS_10_15_Catalina_orLater = isMacOS && osVersion >= SystemInfo.toVersion(10, 15, 0, 0);
        String string2 = System.getProperty("os.arch");
        isX86 = string2.equals("x86");
        isX86_64 = string2.equals("amd64") || string2.equals("x86_64");
        isAARCH64 = string2.equals("aarch64");
        javaVersion = SystemInfo.scanVersion(System.getProperty("java.version"));
        isJava_9_orLater = javaVersion >= SystemInfo.toVersion(9, 0, 0, 0);
        isJava_11_orLater = javaVersion >= SystemInfo.toVersion(11, 0, 0, 0);
        isJava_12_orLater = javaVersion >= SystemInfo.toVersion(12, 0, 0, 0);
        isJava_15_orLater = javaVersion >= SystemInfo.toVersion(15, 0, 0, 0);
        isJava_17_orLater = javaVersion >= SystemInfo.toVersion(17, 0, 0, 0);
        isJava_18_orLater = javaVersion >= SystemInfo.toVersion(18, 0, 0, 0);
        isJetBrainsJVM = System.getProperty("java.vm.vendor", "Unknown").toLowerCase(Locale.ENGLISH).contains("jetbrains");
        isJetBrainsJVM_11_orLater = isJetBrainsJVM && isJava_11_orLater;
        isKDE = isLinux && System.getenv("KDE_FULL_SESSION") != null;
        isProjector = Boolean.getBoolean("org.jetbrains.projector.server.enable");
        isWebswing = System.getProperty("webswing.rootDir") != null;
        isWinPE = isWindows && "X:\\Windows\\System32".equalsIgnoreCase(System.getProperty("user.dir"));
        isMacFullWindowContentSupported = isMacOS && (javaVersion >= SystemInfo.toVersion(11, 0, 8, 0) || javaVersion >= SystemInfo.toVersion(1, 8, 0, 292) && !isJava_9_orLater);
        boolean bl = false;
        try {
            bl = isWindows_10_orLater && (SystemInfo.scanVersion(StringUtils.removeLeading(string, "windows ")) >= SystemInfo.toVersion(11, 0, 0, 0) || FlatNativeWindowsLibrary.isLoaded() && FlatNativeWindowsLibrary.getOSBuildNumber() >= 22000L);
        }
        catch (Throwable throwable) {
            LoggingFacade.INSTANCE.logSevere(null, throwable);
        }
        isWindows_11_orLater = bl;
    }
}

