/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.LazyLayoutBeyondBoundsState;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerLayoutInfoKt;
import androidx.compose.foundation.pager.PagerState;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u0014"}, d2={"Landroidx/compose/foundation/pager/PagerBeyondBoundsState;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutBeyondBoundsState;", "state", "Landroidx/compose/foundation/pager/PagerState;", "beyondViewportPageCount", "", "<init>", "(Landroidx/compose/foundation/pager/PagerState;I)V", "itemCount", "getItemCount", "()I", "hasVisibleItems", "", "getHasVisibleItems", "()Z", "firstPlacedIndex", "getFirstPlacedIndex", "lastPlacedIndex", "getLastPlacedIndex", "itemsPerViewport", "foundation"})
public final class PagerBeyondBoundsState
implements LazyLayoutBeyondBoundsState {
    private final PagerState state;
    private final int beyondViewportPageCount;
    public static final int $stable;

    public PagerBeyondBoundsState(PagerState pagerState, int n2) {
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"");
        this.state = pagerState;
        this.beyondViewportPageCount = n2;
    }

    @Override
    public final int getItemCount() {
        return this.state.getPageCount();
    }

    @Override
    public final boolean getHasVisibleItems() {
        return !((Collection)this.state.getLayoutInfo().getVisiblePagesInfo()).isEmpty();
    }

    @Override
    public final int getFirstPlacedIndex() {
        return Math.max(0, this.state.getFirstVisiblePage$foundation() - this.beyondViewportPageCount);
    }

    @Override
    public final int getLastPlacedIndex() {
        return Math.min(this.getItemCount() - 1, ((PageInfo)CollectionsKt.last(this.state.getLayoutInfo().getVisiblePagesInfo())).getIndex() + this.beyondViewportPageCount);
    }

    @Override
    public final int itemsPerViewport() {
        int n2 = this.state.getLayoutInfo().getVisiblePagesInfo().size();
        if (n2 == 0) {
            return 0;
        }
        n2 = PagerLayoutInfoKt.getMainAxisViewportSize(this.state.getLayoutInfo());
        int n3 = this.state.getLayoutInfo().getPageSize() + this.state.getLayoutInfo().getPageSpacing();
        if (n3 == 0) {
            return 1;
        }
        return RangesKt.coerceAtLeast((int)(n2 / n3), (int)1);
    }
}

