/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.platform.SynchronizedObject;
import androidx.compose.foundation.text.TextLayoutHelperKt;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegateKt;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayoutBuilder;
import androidx.compose.foundation.text.selection.TextSelectionDelegateKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u001f\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\n\u0010\"\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0011H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010(\u001a\u00020\u0011H\u0016J\u0010\u0010+\u001a\u00020*2\u0006\u0010(\u001a\u00020\u0011H\u0016J\u0010\u0010,\u001a\u00020*2\u0006\u0010(\u001a\u00020\u0011H\u0016J\u0017\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b/\u00100J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u00101\u001a\u00020*2\u0006\u0010(\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u0011*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00062"}, d2={"Landroidx/compose/foundation/text/selection/MultiWidgetSelectionDelegate;", "Landroidx/compose/foundation/text/selection/Selectable;", "selectableId", "", "coordinatesCallback", "Lkotlin/Function0;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "layoutResultCallback", "Landroidx/compose/ui/text/TextLayoutResult;", "<init>", "(JLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getSelectableId", "()J", "lock", "Landroidx/compose/foundation/platform/SynchronizedObject;", "_previousTextLayoutResult", "_previousLastVisibleOffset", "", "lastVisibleOffset", "getLastVisibleOffset", "(Landroidx/compose/ui/text/TextLayoutResult;)I", "appendSelectableInfoToBuilder", "", "builder", "Landroidx/compose/foundation/text/selection/SelectionLayoutBuilder;", "getSelectAllSelection", "Landroidx/compose/foundation/text/selection/Selection;", "getHandlePosition", "Landroidx/compose/ui/geometry/Offset;", "selection", "isStartHandle", "", "getHandlePosition-dBAh8RU", "(Landroidx/compose/foundation/text/selection/Selection;Z)J", "getLayoutCoordinates", "textLayoutResult", "getText", "Landroidx/compose/ui/text/AnnotatedString;", "getBoundingBox", "Landroidx/compose/ui/geometry/Rect;", "offset", "getLineLeft", "", "getLineRight", "getCenterYForOffset", "getRangeOfLineContaining", "Landroidx/compose/ui/text/TextRange;", "getRangeOfLineContaining--jx7JFs", "(I)J", "getLineHeight", "foundation"})
public final class MultiWidgetSelectionDelegate
implements Selectable {
    private final long selectableId;
    private final Function0<LayoutCoordinates> coordinatesCallback;
    private final Function0<TextLayoutResult> layoutResultCallback;
    private final SynchronizedObject lock;
    private TextLayoutResult _previousTextLayoutResult;
    private int _previousLastVisibleOffset;
    public static final int $stable = 8;

    public MultiWidgetSelectionDelegate(long l2, Function0<? extends LayoutCoordinates> function0, Function0<TextLayoutResult> function02) {
        Intrinsics.checkNotNullParameter(function0, (String)"");
        Intrinsics.checkNotNullParameter(function02, (String)"");
        this.selectableId = l2;
        this.coordinatesCallback = function0;
        this.layoutResultCallback = function02;
        this.lock = new SynchronizedObject();
        this._previousLastVisibleOffset = -1;
    }

    @Override
    public final long getSelectableId() {
        return this.selectableId;
    }

    private final int getLastVisibleOffset(TextLayoutResult textLayoutResult) {
        SynchronizedObject synchronizedObject = this.lock;
        SynchronizedObject synchronizedObject2 = synchronizedObject;
        synchronizedObject2 = synchronizedObject;
        synchronized (synchronizedObject) {
            if (this._previousTextLayoutResult != textLayoutResult) {
                int n2;
                int n3;
                if (!textLayoutResult.getDidOverflowHeight() || textLayoutResult.getMultiParagraph().getDidExceedMaxLines()) {
                    n3 = textLayoutResult.getLineCount() - 1;
                } else {
                    long l2 = textLayoutResult.getSize-YbymL2g();
                    for (n2 = RangesKt.coerceAtMost((int)(v462468).getLineForVerticalPosition((float)((int)l2)), (int)(textLayoutResult.getLineCount() - 1)); n2 >= 0; --n2) {
                        long l3;
                        long l4 = l2 = textLayoutResult.getSize-YbymL2g();
                        if (!(textLayoutResult.getLineTop(n2) >= (float)((int)l3))) break;
                    }
                    n3 = RangesKt.coerceAtLeast((int)n2, (int)0);
                }
                n2 = n3;
                this._previousLastVisibleOffset = textLayoutResult.getLineEnd(n2, true);
                this._previousTextLayoutResult = textLayoutResult;
            }
            int n4 = this._previousLastVisibleOffset;
            // ** MonitorExit[var2_4] (shouldn't be in output)
            return n4;
        }
    }

    @Override
    public final void appendSelectableInfoToBuilder(SelectionLayoutBuilder selectionLayoutBuilder) {
        Intrinsics.checkNotNullParameter((Object)selectionLayoutBuilder, (String)"");
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return;
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        long l2 = selectionLayoutBuilder.getContainerCoordinates().localPositionOf-R5De75A(layoutCoordinates2, Offset.Companion.getZero-F1C5BW0());
        long l3 = Offset.minus-MK-Hz9U((long)selectionLayoutBuilder.getCurrentPosition-F1C5BW0(), (long)l2);
        long l4 = selectionLayoutBuilder.getPreviousHandlePosition-F1C5BW0();
        long l5 = (l4 & 0x7FFFFFFF7FFFFFFFL) == 9205357640488583168L ? Offset.Companion.getUnspecified-F1C5BW0() : Offset.minus-MK-Hz9U((long)selectionLayoutBuilder.getPreviousHandlePosition-F1C5BW0(), (long)l2);
        MultiWidgetSelectionDelegateKt.appendSelectableInfo-Parwq6A(selectionLayoutBuilder, textLayoutResult2, l3, l5, this.getSelectableId());
    }

    @Override
    public final Selection getSelectAllSelection() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int n2 = textLayoutResult.getLayoutInput().getText().length();
        return new Selection(new Selection.AnchorInfo(textLayoutResult2.getBidiRunDirection(0), 0, this.getSelectableId()), new Selection.AnchorInfo(textLayoutResult2.getBidiRunDirection(Math.max(n2 - 1, 0)), n2, this.getSelectableId()), false);
    }

    @Override
    public final long getHandlePosition-dBAh8RU(Selection selection, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"");
        if (bl && selection.getStart().getSelectableId() != this.getSelectableId() || !bl && selection.getEnd().getSelectableId() != this.getSelectableId()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (this.getLayoutCoordinates() == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int n2 = bl ? selection.getStart().getOffset() : selection.getEnd().getOffset();
        n2 = RangesKt.coerceIn((int)n2, (int)0, (int)this.getLastVisibleOffset(textLayoutResult2));
        return TextSelectionDelegateKt.getSelectionHandleCoordinates(textLayoutResult2, n2, bl, selection.getHandlesCrossed());
    }

    @Override
    public final LayoutCoordinates getLayoutCoordinates() {
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return layoutCoordinates;
    }

    @Override
    public final TextLayoutResult textLayoutResult() {
        return (TextLayoutResult)this.layoutResultCallback.invoke();
    }

    @Override
    public final AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", null, 2, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult.getLayoutInput().getText();
    }

    @Override
    public final Rect getBoundingBox(int n2) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Rect.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int n3 = textLayoutResult.getLayoutInput().getText().length();
        if (n3 <= 0) {
            return Rect.Companion.getZero();
        }
        return textLayoutResult2.getBoundingBox(RangesKt.coerceIn((int)n2, (int)0, (int)(n3 - 1)));
    }

    @Override
    public final float getLineLeft(int n2) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return -1.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        if ((n2 = textLayoutResult.getLineForOffset(n2)) >= textLayoutResult2.getLineCount()) {
            return -1.0f;
        }
        return textLayoutResult2.getLineLeft(n2);
    }

    @Override
    public final float getLineRight(int n2) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return -1.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        if ((n2 = textLayoutResult.getLineForOffset(n2)) >= textLayoutResult2.getLineCount()) {
            return -1.0f;
        }
        return textLayoutResult2.getLineRight(n2);
    }

    @Override
    public final float getCenterYForOffset(int n2) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return -1.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        if ((n2 = textLayoutResult.getLineForOffset(n2)) >= textLayoutResult2.getLineCount()) {
            return -1.0f;
        }
        float f2 = textLayoutResult2.getLineTop(n2);
        float f3 = textLayoutResult2.getLineBottom(n2);
        return (f3 - f2) / 2.0f + f2;
    }

    @Override
    public final long getRangeOfLineContaining--jx7JFs(int n2) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int n3 = this.getLastVisibleOffset(textLayoutResult2);
        if (n3 <= 0) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        n2 = textLayoutResult2.getLineForOffset(RangesKt.coerceIn((int)n2, (int)0, (int)(n3 - 1)));
        return TextRangeKt.TextRange((int)textLayoutResult2.getLineStart(n2), (int)textLayoutResult2.getLineEnd(n2, true));
    }

    @Override
    public final int getLastVisibleOffset() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return 0;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return this.getLastVisibleOffset(textLayoutResult2);
    }

    @Override
    public final float getLineHeight(int n2) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult != null) {
            return TextLayoutHelperKt.getLineHeight(textLayoutResult, n2);
        }
        return 0.0f;
    }
}

