/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.selector;

import io.ktor.network.selector.InterestSuspensionsMap;
import io.ktor.network.selector.SelectInterest;
import io.ktor.network.selector.Selectable;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.selector.SelectorManagerSupport;
import io.ktor.network.selector.SelectorManagerSupportKt;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.k;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0011\b&\u0018\u00002\u00020\u0001:\u00018B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H$\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0086@\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0012\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000eH\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001eH\u0004\u00a2\u0006\u0004\b \u0010!J!\u0010 \u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0004\u00a2\u0006\u0004\b \u0010\"R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010*\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R,\u00107\u001a\u0004\u0018\u00010\u0004*\u00020\u000e2\b\u00102\u001a\u0004\u0018\u00010\u00048B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00069"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport;", "Lio/ktor/network/selector/SelectorManager;", "<init>", "()V", "Lio/ktor/network/selector/Selectable;", "selectable", "", "publishInterest", "(Lio/ktor/network/selector/Selectable;)V", "Lio/ktor/network/selector/SelectInterest;", "interest", "select", "(Lio/ktor/network/selector/Selectable;Lio/ktor/network/selector/SelectInterest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Ljava/nio/channels/SelectionKey;", "selectedKeys", "", "keys", "handleSelectedKeys", "(Ljava/util/Set;Ljava/util/Set;)V", "key", "handleSelectedKey", "(Ljava/nio/channels/SelectionKey;)V", "Ljava/nio/channels/Selector;", "selector", "applyInterest", "(Ljava/nio/channels/Selector;Lio/ktor/network/selector/Selectable;)V", "attachment", "notifyClosedImpl", "(Ljava/nio/channels/Selector;Ljava/nio/channels/SelectionKey;Lio/ktor/network/selector/Selectable;)V", "", "cause", "cancelAllSuspensions", "(Lio/ktor/network/selector/Selectable;Ljava/lang/Throwable;)V", "(Ljava/nio/channels/Selector;Ljava/lang/Throwable;)V", "Ljava/nio/channels/spi/SelectorProvider;", "provider", "Ljava/nio/channels/spi/SelectorProvider;", "getProvider", "()Ljava/nio/channels/spi/SelectorProvider;", "", "pending", "I", "getPending", "()I", "setPending", "(I)V", "cancelled", "getCancelled", "setCancelled", "newValue", "getSubject", "(Ljava/nio/channels/SelectionKey;)Lio/ktor/network/selector/Selectable;", "setSubject", "(Ljava/nio/channels/SelectionKey;Lio/ktor/network/selector/Selectable;)V", "subject", "ClosedSelectorCancellationException", "ktor-network"})
public abstract class SelectorManagerSupport
implements SelectorManager {
    private final SelectorProvider provider;
    private int pending;
    private int cancelled;

    public SelectorManagerSupport() {
        SelectorProvider selectorProvider = SelectorProvider.provider();
        Intrinsics.checkNotNullExpressionValue((Object)selectorProvider, (String)"");
        this.provider = selectorProvider;
    }

    @Override
    public final SelectorProvider getProvider() {
        return this.provider;
    }

    protected final int getPending() {
        return this.pending;
    }

    protected final void setPending(int n2) {
        this.pending = n2;
    }

    protected final int getCancelled() {
        return this.cancelled;
    }

    protected final void setCancelled(int n2) {
        this.cancelled = n2;
    }

    protected abstract void publishInterest(Selectable var1);

    @Override
    public final Object select(Selectable selectable, SelectInterest selectInterest, Continuation<? super Unit> k2) {
        int n2 = selectable.getInterestedOps();
        int n3 = selectInterest.getFlag();
        if (selectable.isClosed()) {
            SelectorManagerSupportKt.access$selectableIsClosed();
            throw new KotlinNothingValueException();
        }
        if ((n2 & n3) == 0) {
            SelectorManagerSupportKt.access$selectableIsInvalid(n2, n3);
            throw new KotlinNothingValueException();
        }
        k k3 = k2;
        k3 = new k(IntrinsicsKt.intercepted(k3), 1);
        k3.e();
        CancellableContinuation cancellableContinuation = (CancellableContinuation)k3;
        cancellableContinuation.a((Function1)select.2.1.INSTANCE);
        selectable.getSuspensions().addSuspension(selectInterest, (CancellableContinuation<? super Unit>)cancellableContinuation);
        if (!cancellableContinuation.c()) {
            this.publishInterest(selectable);
        }
        Object object = k3.h();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended((Continuation)k2);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    protected final void handleSelectedKeys(Set<SelectionKey> object, Set<? extends SelectionKey> object2) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        Intrinsics.checkNotNullParameter(object2, (String)"");
        int n2 = object.size();
        this.pending = object2.size() - n2;
        this.cancelled = 0;
        if (n2 <= 0) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (SelectionKey)object.next();
            this.handleSelectedKey((SelectionKey)object2);
            object.remove();
        }
    }

    protected final void handleSelectedKey(SelectionKey selectionKey) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)selectionKey, (String)"");
            try {
                int n2 = selectionKey.readyOps();
                int n3 = selectionKey.interestOps();
                Object object = this.getSubject(selectionKey);
                if (object == null) {
                    selectionKey.cancel();
                    int n4 = this.cancelled;
                    this.cancelled = n4 + 1;
                    return;
                }
                object = object.getSuspensions();
                int[] nArray = SelectInterest.Companion.getFlags();
                int n5 = nArray.length;
                for (int i = 0; i < n5; ++i) {
                    CancellableContinuation<Unit> cancellableContinuation;
                    if ((nArray[i] & n2) == 0 || ((InterestSuspensionsMap)object).removeSuspension(i) == null) continue;
                    ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                }
                int n6 = n3 & ~n2;
                if (n6 != n3) {
                    selectionKey.interestOps(n6);
                }
                if (n6 != 0) {
                    n2 = this.pending;
                    this.pending = n2 + 1;
                    return;
                }
            }
            catch (Throwable throwable) {
                selectionKey.cancel();
                int n7 = this.cancelled;
                this.cancelled = n7 + 1;
                Selectable selectable = this.getSubject(selectionKey);
                if (selectable == null) break block6;
                Selectable selectable2 = selectable;
                this.cancelAllSuspensions(selectable2, throwable);
                this.setSubject(selectionKey, null);
                return;
            }
        }
    }

    protected final void applyInterest(Selector selector, Selectable selectable) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"");
        Intrinsics.checkNotNullParameter((Object)selectable, (String)"");
        try {
            SelectableChannel selectableChannel = selectable.getChannel();
            SelectionKey selectionKey = selectableChannel.keyFor(selector);
            int n2 = selectable.getInterestedOps();
            if (selectionKey == null) {
                if (n2 != 0) {
                    selectableChannel.register(selector, n2, selectable);
                }
            } else if (selectionKey.interestOps() != n2) {
                selectionKey.interestOps(n2);
            }
            if (n2 != 0) {
                int n3 = this.pending;
                this.pending = n3 + 1;
                return;
            }
        }
        catch (Throwable throwable) {
            SelectionKey selectionKey = selectable.getChannel().keyFor(selector);
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            this.cancelAllSuspensions(selectable, throwable);
        }
    }

    protected final void notifyClosedImpl(Selector selector, SelectionKey selectionKey, Selectable selectable) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"");
        Intrinsics.checkNotNullParameter((Object)selectionKey, (String)"");
        Intrinsics.checkNotNullParameter((Object)selectable, (String)"");
        this.cancelAllSuspensions(selectable, (Throwable)new ClosedChannelException());
        this.setSubject(selectionKey, null);
        selector.wakeup();
    }

    protected final void cancelAllSuspensions(Selectable object, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"");
        object = object.getSuspensions();
        for (SelectInterest selectInterest : SelectInterest.Companion.getAllInterests()) {
            CancellableContinuation<Unit> cancellableContinuation;
            if (((InterestSuspensionsMap)object).removeSuspension(selectInterest) == null) continue;
            CancellableContinuation<Unit> cancellableContinuation2 = cancellableContinuation;
            ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
        }
    }

    protected final void cancelAllSuspensions(Selector iterator, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"");
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            throwable2 = new ClosedSelectorCancellationException();
        }
        throwable = throwable2;
        Set<SelectionKey> set = ((Selector)((Object)iterator)).keys();
        Intrinsics.checkNotNullExpressionValue(set, (String)"");
        iterator = set;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2 = iterator.next();
            object2 = (SelectionKey)object2;
            try {
                if (((SelectionKey)object2).isValid()) {
                    ((SelectionKey)object2).interestOps(0);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {}
            Selectable selectable = (object = ((SelectionKey)object2).attachment()) instanceof Selectable ? (Selectable)object : null;
            if (selectable != null) {
                object = selectable;
                this.cancelAllSuspensions((Selectable)object, throwable);
            }
            ((SelectionKey)object2).cancel();
        }
    }

    private final Selectable getSubject(SelectionKey object) {
        if ((object = ((SelectionKey)object).attachment()) instanceof Selectable) {
            return (Selectable)object;
        }
        return null;
    }

    private final void setSubject(SelectionKey selectionKey, Selectable selectable) {
        selectionKey.attach(selectable);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport$ClosedSelectorCancellationException;", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "<init>", "()V", "ktor-network"})
    public static final class ClosedSelectorCancellationException
    extends CancellationException {
        public ClosedSelectorCancellationException() {
            super("Closed selector");
        }
    }
}

