/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000fH\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lkotlinx/serialization/json/internal/JsonTreeDecoder;", "Lkotlinx/serialization/json/internal/AbstractJsonTreeDecoder;", "json", "Lkotlinx/serialization/json/Json;", "value", "Lkotlinx/serialization/json/JsonObject;", "polymorphicDiscriminator", "", "polyDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "getValue", "()Lkotlinx/serialization/json/JsonObject;", "position", "", "forceNull", "", "coerceInputValue", "descriptor", "index", "tag", "decodeElementIndex", "absenceIsNull", "decodeNotNullMark", "elementName", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "", "kotlinx-serialization-json"})
class JsonTreeDecoder
extends AbstractJsonTreeDecoder {
    private final JsonObject value;
    private final SerialDescriptor polyDescriptor;
    private int position;
    private boolean forceNull;

    public JsonTreeDecoder(Json json, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"");
        super(json, jsonObject, string, null);
        this.value = jsonObject;
        this.polyDescriptor = serialDescriptor;
    }

    public /* synthetic */ JsonTreeDecoder(Json json, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            serialDescriptor = null;
        }
        this(json, jsonObject, string, serialDescriptor);
    }

    @Override
    public JsonObject getValue() {
        return this.value;
    }

    private final boolean coerceInputValue(SerialDescriptor serialDescriptor, int n, String string) {
        Json json = this.getJson();
        boolean bl = serialDescriptor.isElementOptional(n);
        serialDescriptor = serialDescriptor.getElementDescriptor(n);
        if (bl && !serialDescriptor.isNullable() && this.currentElement(string) instanceof JsonNull) {
            return true;
        }
        if (!(!Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE) || serialDescriptor.isNullable() && this.currentElement(string) instanceof JsonNull)) {
            Object object = this.currentElement(string);
            JsonPrimitive jsonPrimitive = object instanceof JsonPrimitive ? (JsonPrimitive)object : null;
            String string2 = jsonPrimitive != null ? JsonElementKt.getContentOrNull(jsonPrimitive) : null;
            if (string2 != null) {
                boolean bl2;
                object = string2;
                int n2 = JsonNamesMapKt.getJsonNameIndex(serialDescriptor, json, (String)object);
                boolean bl3 = bl2 = !json.getConfiguration().getExplicitNulls() && serialDescriptor.isNullable();
                if (n2 == -3 && (bl || bl2)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int decodeElementIndex(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        while (this.position < serialDescriptor.getElementsCount()) {
            int n = this.position;
            this.position = n + 1;
            String string = this.getTag(serialDescriptor, n);
            n = this.position - 1;
            this.forceNull = false;
            if (!((Map)this.getValue()).containsKey(string) && !this.absenceIsNull(serialDescriptor, n) || this.configuration.getCoerceInputValues() && this.coerceInputValue(serialDescriptor, n, string)) continue;
            return n;
        }
        return -1;
    }

    private final boolean absenceIsNull(SerialDescriptor serialDescriptor, int n) {
        this.forceNull = !this.getJson().getConfiguration().getExplicitNulls() && !serialDescriptor.isElementOptional(n) && serialDescriptor.getElementDescriptor(n).isNullable();
        return this.forceNull;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.forceNull && super.decodeNotNullMark();
    }

    protected String elementName(SerialDescriptor serialDescriptor, int n) {
        Object v1;
        Object object;
        Object object2;
        String string;
        JsonNamingStrategy jsonNamingStrategy;
        block6: {
            Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
            jsonNamingStrategy = JsonNamesMapKt.namingStrategy(serialDescriptor, this.getJson());
            string = serialDescriptor.getElementName(n);
            if (jsonNamingStrategy == null) {
                if (!this.configuration.getUseAlternativeNames()) {
                    return string;
                }
                if (this.getValue().keySet().contains(string)) {
                    return string;
                }
            }
            object2 = JsonNamesMapKt.deserializationNamesMap(this.getJson(), serialDescriptor);
            object = this.getValue().keySet();
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                String string2 = (String)e;
                Integer n2 = (Integer)object2.get(string2);
                if (!(n2 != null && n2 == n)) continue;
                v1 = e;
                break block6;
            }
            v1 = null;
        }
        object2 = v1;
        if (object2 != null) {
            object = object2;
            return object;
        }
        JsonNamingStrategy jsonNamingStrategy2 = jsonNamingStrategy;
        object2 = jsonNamingStrategy2 != null ? jsonNamingStrategy2.serialNameForJson(serialDescriptor, n, string) : null;
        String string3 = object2;
        if (object2 == null) {
            string3 = string;
        }
        return string3;
    }

    @Override
    protected JsonElement currentElement(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return (JsonElement)MapsKt.getValue((Map)this.getValue(), (Object)string);
    }

    @Override
    public CompositeDecoder beginStructure(SerialDescriptor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (object == this.polyDescriptor) {
            object = this;
            JsonElement jsonElement = this.currentObject();
            Object object2 = this.polyDescriptor;
            object2 = object2.getSerialName();
            if (!(jsonElement instanceof JsonObject)) {
                object2 = new StringBuilder("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(jsonElement.getClass()).getSimpleName()).append(" as the serialized body of ").append((String)object2).append(" at element: ");
                object = AbstractJsonTreeDecoder.access$renderTagStack((AbstractJsonTreeDecoder)object);
                throw JsonExceptionsKt.JsonDecodingException(-1, ((StringBuilder)object2).append((String)object).toString(), jsonElement.toString());
            }
            return new JsonTreeDecoder(this.getJson(), (JsonObject)jsonElement, this.getPolymorphicDiscriminator(), this.polyDescriptor);
        }
        return super.beginStructure((SerialDescriptor)object);
    }

    @Override
    public void endStructure(SerialDescriptor object) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (JsonNamesMapKt.ignoreUnknownKeys((SerialDescriptor)object, this.getJson()) || object.getKind() instanceof PolymorphicKind) {
            return;
        }
        JsonNamingStrategy jsonNamingStrategy = JsonNamesMapKt.namingStrategy((SerialDescriptor)object, this.getJson());
        if (jsonNamingStrategy == null && !this.configuration.getUseAlternativeNames()) {
            set = JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)object);
        } else if (jsonNamingStrategy != null) {
            set = JsonNamesMapKt.deserializationNamesMap(this.getJson(), (SerialDescriptor)object).keySet();
        } else {
            Set set2 = JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)object);
            Map<String, Integer> map = JsonSchemaCacheKt.getSchemaCache(this.getJson()).get((SerialDescriptor)object, JsonNamesMapKt.getJsonDeserializationNamesKey());
            Set set3 = map != null ? map.keySet() : null;
            if (set3 == null) {
                set3 = SetsKt.emptySet();
            }
            set = SetsKt.plus((Set)set2, (Iterable)set3);
        }
        object = set;
        for (String string : this.getValue().keySet()) {
            if (object.contains(string) || Intrinsics.areEqual((Object)string, (Object)this.getPolymorphicDiscriminator())) continue;
            throw JsonExceptionsKt.JsonDecodingException(-1, "Encountered an unknown key '" + string + "' at element: " + this.renderTagStack() + "\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder or '@JsonIgnoreUnknownKeys' annotation to ignore unknown keys.\nJSON input: " + JsonExceptionsKt.minify$default(this.getValue().toString(), 0, 1, null));
        }
    }
}

