/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.ContextAwareKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.modules.SerializersModule;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001aS\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006\"\b\b\u0001\u0010\u0007*\u0002H\u0006\"\b\b\u0002\u0010\b*\u0002H\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"switchMode", "Lkotlinx/serialization/json/internal/WriteMode;", "Lkotlinx/serialization/json/Json;", "desc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "selectMapMode", "T", "R1", "R2", "mapDescriptor", "ifMap", "Lkotlin/Function0;", "ifList", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "carrierDescriptor", "module", "Lkotlinx/serialization/modules/SerializersModule;", "kotlinx-serialization-json"})
public final class WriteModeKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final WriteMode switchMode(Json json, SerialDescriptor serialDescriptor) {
        WriteMode writeMode;
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        SerialKind serialKind = serialDescriptor.getKind();
        if (serialKind instanceof PolymorphicKind) {
            return WriteMode.POLY_OBJ;
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            return WriteMode.LIST;
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            serialKind = (serialDescriptor = WriteModeKt.carrierDescriptor(serialDescriptor.getElementDescriptor(0), json.getSerializersModule())).getKind();
            if (serialKind instanceof PrimitiveKind || Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.ENUM.INSTANCE)) {
                writeMode = WriteMode.MAP;
                return writeMode;
            } else {
                if (!json.getConfiguration().getAllowStructuredMapKeys()) throw JsonExceptionsKt.InvalidKeyKindException(serialDescriptor);
                writeMode = WriteMode.LIST;
            }
            return writeMode;
        } else {
            writeMode = WriteMode.OBJ;
        }
        return writeMode;
    }

    public static final <T, R1 extends T, R2 extends T> T selectMapMode(Json json, SerialDescriptor serialDescriptor, Function0<? extends R1> function0, Function0<? extends R2> function02) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(function0, (String)"");
        Intrinsics.checkNotNullParameter(function02, (String)"");
        serialDescriptor = WriteModeKt.carrierDescriptor(serialDescriptor.getElementDescriptor(0), json.getSerializersModule());
        SerialKind serialKind = serialDescriptor.getKind();
        if (serialKind instanceof PrimitiveKind || Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.ENUM.INSTANCE)) {
            return (T)function0.invoke();
        }
        if (json.getConfiguration().getAllowStructuredMapKeys()) {
            return (T)function02.invoke();
        }
        throw JsonExceptionsKt.InvalidKeyKindException(serialDescriptor);
    }

    public static final SerialDescriptor carrierDescriptor(SerialDescriptor serialDescriptor, SerializersModule serializersModule) {
        SerialDescriptor serialDescriptor2;
        block2: {
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
                    Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"");
                    if (!Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)SerialKind.CONTEXTUAL.INSTANCE)) break block1;
                    serialDescriptor2 = ContextAwareKt.getContextualDescriptor((SerializersModule)serializersModule, (SerialDescriptor)serialDescriptor);
                    if (serialDescriptor2 != null && (serialDescriptor2 = WriteModeKt.carrierDescriptor(serialDescriptor2, serializersModule)) != null) break block2;
                    break block3;
                }
                if (serialDescriptor.isInline()) {
                    return WriteModeKt.carrierDescriptor(serialDescriptor.getElementDescriptor(0), serializersModule);
                }
            }
            serialDescriptor2 = serialDescriptor;
        }
        return serialDescriptor2;
    }
}

