/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.engine.BaseApplicationRequest;
import io.ktor.server.netty.NettyApplicationRequestCookies;
import io.ktor.server.request.PipelineRequest;
import io.ktor.server.request.RequestCookies;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001aR\u001a\u0010\f\u001a\u00020\u000b8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000e\u001a\u00020\r8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u001b\u0010)\u001a\u00020!8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010%R\u001a\u0010+\u001a\u00020*8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\t8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b/\u0010\u001a\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"Lio/ktor/server/netty/NettyApplicationRequest;", "Lio/ktor/server/engine/BaseApplicationRequest;", "Lkotlinx/coroutines/CoroutineScope;", "Lio/ktor/server/application/PipelineCall;", "call", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Lio/netty/channel/ChannelHandlerContext;", "context", "Lio/ktor/utils/io/ByteReadChannel;", "requestBodyChannel", "", "uri", "", "keepAlive", "<init>", "(Lio/ktor/server/application/PipelineCall;Lkotlin/coroutines/CoroutineContext;Lio/netty/channel/ChannelHandlerContext;Lio/ktor/utils/io/ByteReadChannel;Ljava/lang/String;Z)V", "", "close", "()V", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Lio/netty/channel/ChannelHandlerContext;", "getContext", "()Lio/netty/channel/ChannelHandlerContext;", "Lio/ktor/utils/io/ByteReadChannel;", "Ljava/lang/String;", "getUri", "()Ljava/lang/String;", "Z", "getKeepAlive$ktor_server_netty", "()Z", "Lio/ktor/http/Parameters;", "queryParameters", "Lio/ktor/http/Parameters;", "getQueryParameters", "()Lio/ktor/http/Parameters;", "rawQueryParameters$delegate", "Lkotlin/Lazy;", "getRawQueryParameters", "rawQueryParameters", "Lio/ktor/server/request/RequestCookies;", "cookies", "Lio/ktor/server/request/RequestCookies;", "getCookies", "()Lio/ktor/server/request/RequestCookies;", "engineReceiveChannel", "getEngineReceiveChannel", "()Lio/ktor/utils/io/ByteReadChannel;", "ktor-server-netty"})
public abstract class NettyApplicationRequest
extends BaseApplicationRequest
implements CoroutineScope {
    private final CoroutineContext coroutineContext;
    private final ChannelHandlerContext context;
    private final ByteReadChannel requestBodyChannel;
    private final String uri;
    private final boolean keepAlive;
    private final Parameters queryParameters;
    private final Lazy rawQueryParameters$delegate;
    private final RequestCookies cookies;
    private final ByteReadChannel engineReceiveChannel;

    public NettyApplicationRequest(PipelineCall pipelineCall, CoroutineContext coroutineContext, ChannelHandlerContext channelHandlerContext, ByteReadChannel byteReadChannel, String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)pipelineCall, (String)"");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)channelHandlerContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)byteReadChannel, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        super(pipelineCall);
        this.coroutineContext = coroutineContext;
        this.context = channelHandlerContext;
        this.requestBodyChannel = byteReadChannel;
        this.uri = string;
        this.keepAlive = bl;
        this.queryParameters = new Parameters(this){
            private final QueryStringDecoder decoder;
            {
                this.decoder = new QueryStringDecoder(nettyApplicationRequest.getUri(), HttpConstants.DEFAULT_CHARSET, true, 1024, true);
            }

            public final boolean getCaseInsensitiveName() {
                return true;
            }

            public final List<String> getAll(String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                return (List)this.decoder.parameters().get(string);
            }

            public final Set<String> names() {
                return this.decoder.parameters().keySet();
            }

            public final Set<Map.Entry<String, List<String>>> entries() {
                return this.decoder.parameters().entrySet();
            }

            public final boolean isEmpty() {
                return this.decoder.parameters().isEmpty();
            }

            public final String get(String string) {
                return Parameters.DefaultImpls.get((Parameters)this, (String)string);
            }

            public final boolean contains(String string) {
                return Parameters.DefaultImpls.contains((Parameters)this, (String)string);
            }

            public final boolean contains(String string, String string2) {
                return Parameters.DefaultImpls.contains((Parameters)this, (String)string, (String)string2);
            }

            public final void forEach(Function2<? super String, ? super List<String>, Unit> function2) {
                Parameters.DefaultImpls.forEach((Parameters)this, function2);
            }
        };
        this.rawQueryParameters$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> NettyApplicationRequest.rawQueryParameters_delegate$lambda$1(this));
        this.cookies = new NettyApplicationRequestCookies((PipelineRequest)this);
        this.engineReceiveChannel = this.requestBodyChannel;
    }

    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public final ChannelHandlerContext getContext() {
        return this.context;
    }

    protected final String getUri() {
        return this.uri;
    }

    public final boolean getKeepAlive$ktor_server_netty() {
        return this.keepAlive;
    }

    public final Parameters getQueryParameters() {
        return this.queryParameters;
    }

    public Parameters getRawQueryParameters() {
        Lazy lazy = this.rawQueryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    public RequestCookies getCookies() {
        return this.cookies;
    }

    protected ByteReadChannel getEngineReceiveChannel() {
        return this.engineReceiveChannel;
    }

    public final void close() {
    }

    private static final Parameters rawQueryParameters_delegate$lambda$1(NettyApplicationRequest nettyApplicationRequest) {
        Integer n = StringsKt.indexOf$default((CharSequence)nettyApplicationRequest.uri, (char)'?', (int)0, (boolean)false, (int)6, null);
        int n2 = ((Number)n).intValue();
        Integer n3 = n2 != -1 ? n : null;
        if (n3 == null) {
            return Parameters.Companion.getEmpty();
        }
        int n4 = n3;
        return QueryKt.parseQueryString$default((String)nettyApplicationRequest.uri, (int)(n4 + 1), (int)0, (boolean)false, (int)4, null);
    }
}

