/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import java.lang.reflect.Array;

public abstract class OaIdlUtil {
    public static Object toPrimitiveArray(OaIdl.SAFEARRAY sAFEARRAY, boolean bl) {
        Object object = sAFEARRAY.accessData();
        try {
            int n;
            int n2 = sAFEARRAY.getDimensionCount();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n3 = sAFEARRAY.getVarType().intValue();
            for (n = 0; n < n2; ++n) {
                nArray[n] = sAFEARRAY.getUBound(n) - sAFEARRAY.getLBound(n) + 1;
            }
            for (n = n2 - 1; n >= 0; --n) {
                nArray2[n] = n == n2 - 1 ? 1 : nArray2[n + 1] * nArray[n + 1];
            }
            if (n2 == 0) {
                throw new IllegalArgumentException("Supplied Array has no dimensions.");
            }
            n = nArray2[0] * nArray[0];
            switch (n3) {
                case 16: 
                case 17: {
                    object = object.getByteArray(0L, n);
                    break;
                }
                case 2: 
                case 11: 
                case 18: {
                    object = object.getShortArray(0L, n);
                    break;
                }
                case 3: 
                case 10: 
                case 19: 
                case 22: 
                case 23: {
                    object = object.getIntArray(0L, n);
                    break;
                }
                case 4: {
                    object = object.getFloatArray(0L, n);
                    break;
                }
                case 5: 
                case 7: {
                    object = object.getDoubleArray(0L, n);
                    break;
                }
                case 8: {
                    object = object.getPointerArray(0L, n);
                    break;
                }
                case 12: {
                    Variant.VARIANT vARIANT = new Variant.VARIANT((Pointer)object);
                    object = vARIANT.toArray(n);
                    break;
                }
                default: {
                    throw new IllegalStateException("Type not supported: " + n3);
                }
            }
            Object object2 = Array.newInstance(Object.class, nArray);
            OaIdlUtil.toPrimitiveArray(object, object2, nArray, nArray2, n3, new int[0]);
            object = object2;
            return object;
        }
        finally {
            sAFEARRAY.unaccessData();
            if (bl) {
                sAFEARRAY.destroy();
            }
        }
    }

    private static void toPrimitiveArray(Object object, Object object2, int[] nArray, int[] nArray2, int n, int[] nArray3) {
        int n2 = nArray3.length;
        int[] nArray4 = new int[nArray3.length + 1];
        System.arraycopy(nArray3, 0, nArray4, 0, n2);
        block24: for (int i = 0; i < nArray[n2]; ++i) {
            nArray4[n2] = i;
            if (n2 == nArray.length - 1) {
                int n3;
                int n4 = 0;
                for (n3 = 0; n3 < n2; ++n3) {
                    n4 += nArray2[n3] * nArray3[n3];
                }
                n4 += nArray4[n2];
                n3 = nArray4[n2];
                switch (n) {
                    case 11: {
                        Array.set(object2, n3, Array.getShort(object, n4) != 0);
                        continue block24;
                    }
                    case 16: 
                    case 17: {
                        Array.set(object2, n3, Array.getByte(object, n4));
                        continue block24;
                    }
                    case 2: 
                    case 18: {
                        Array.set(object2, n3, Array.getShort(object, n4));
                        continue block24;
                    }
                    case 3: 
                    case 19: 
                    case 22: 
                    case 23: {
                        Array.set(object2, n3, Array.getInt(object, n4));
                        continue block24;
                    }
                    case 10: {
                        Array.set(object2, n3, new WinDef.SCODE(Array.getInt(object, n4)));
                        continue block24;
                    }
                    case 4: {
                        Array.set(object2, n3, Float.valueOf(Array.getFloat(object, n4)));
                        continue block24;
                    }
                    case 5: {
                        Array.set(object2, n3, Array.getDouble(object, n4));
                        continue block24;
                    }
                    case 7: {
                        Array.set(object2, n3, new OaIdl.DATE(Array.getDouble(object, n4)).getAsJavaDate());
                        continue block24;
                    }
                    case 8: {
                        Array.set(object2, n3, new WTypes.BSTR((Pointer)Array.get(object, n4)).getValue());
                        continue block24;
                    }
                    case 12: {
                        Variant.VARIANT vARIANT = (Variant.VARIANT)((Object)Array.get(object, n4));
                        switch (vARIANT.getVarType().intValue()) {
                            case 0: 
                            case 1: {
                                Array.set(object2, n3, null);
                                continue block24;
                            }
                            case 11: {
                                Array.set(object2, n3, vARIANT.booleanValue());
                                continue block24;
                            }
                            case 16: 
                            case 17: {
                                Array.set(object2, n3, vARIANT.byteValue());
                                continue block24;
                            }
                            case 2: 
                            case 18: {
                                Array.set(object2, n3, vARIANT.shortValue());
                                continue block24;
                            }
                            case 3: 
                            case 19: 
                            case 22: 
                            case 23: {
                                Array.set(object2, n3, vARIANT.intValue());
                                continue block24;
                            }
                            case 10: {
                                Array.set(object2, n3, new WinDef.SCODE(vARIANT.intValue()));
                                continue block24;
                            }
                            case 4: {
                                Array.set(object2, n3, Float.valueOf(vARIANT.floatValue()));
                                continue block24;
                            }
                            case 5: {
                                Array.set(object2, n3, vARIANT.doubleValue());
                                continue block24;
                            }
                            case 7: {
                                Array.set(object2, n3, vARIANT.dateValue());
                                continue block24;
                            }
                            case 8: {
                                Array.set(object2, n3, vARIANT.stringValue());
                                continue block24;
                            }
                            default: {
                                throw new IllegalStateException("Type not supported: " + vARIANT.getVarType().intValue());
                            }
                        }
                    }
                    default: {
                        throw new IllegalStateException("Type not supported: " + n);
                    }
                }
            }
            OaIdlUtil.toPrimitiveArray(object, Array.get(object2, i), nArray, nArray2, n, nArray4);
        }
    }
}

