/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.ui.ComposeUiFlags;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusEnterExitScope;
import androidx.compose.ui.focus.FocusProperties;
import androidx.compose.ui.focus.FocusPropertiesModifierNode;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.focus.FocusRequesterModifierNode;
import androidx.compose.ui.focus.FocusRequesterModifierNodeKt;
import androidx.compose.ui.layout.PinnableContainer;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/focus/FocusRestorerNode;", "Landroidx/compose/ui/node/CompositionLocalConsumerModifierNode;", "Landroidx/compose/ui/focus/FocusPropertiesModifierNode;", "Landroidx/compose/ui/focus/FocusRequesterModifierNode;", "Landroidx/compose/ui/Modifier$Node;", "fallback", "Landroidx/compose/ui/focus/FocusRequester;", "<init>", "(Landroidx/compose/ui/focus/FocusRequester;)V", "getFallback", "()Landroidx/compose/ui/focus/FocusRequester;", "setFallback", "pinnedHandle", "Landroidx/compose/ui/layout/PinnableContainer$PinnedHandle;", "onExit", "Lkotlin/Function1;", "Landroidx/compose/ui/focus/FocusEnterExitScope;", "", "Lkotlin/ExtensionFunctionType;", "onEnter", "applyFocusProperties", "focusProperties", "Landroidx/compose/ui/focus/FocusProperties;", "onDetach", "ui"})
public final class FocusRestorerNode
extends Modifier.Node
implements FocusPropertiesModifierNode,
FocusRequesterModifierNode,
CompositionLocalConsumerModifierNode {
    private FocusRequester fallback;
    private PinnableContainer.PinnedHandle pinnedHandle;
    private final Function1<FocusEnterExitScope, Unit> onExit;
    private final Function1<FocusEnterExitScope, Unit> onEnter;
    public static final int $stable = 8;

    public FocusRestorerNode(FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"");
        this.fallback = focusRequester;
        this.onExit = arg_0 -> FocusRestorerNode.onExit$lambda$0(this, arg_0);
        this.onEnter = arg_0 -> FocusRestorerNode.onEnter$lambda$1(this, arg_0);
    }

    public final FocusRequester getFallback() {
        return this.fallback;
    }

    public final void setFallback(FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"");
        this.fallback = focusRequester;
    }

    @Override
    public final void applyFocusProperties(FocusProperties focusProperties) {
        Intrinsics.checkNotNullParameter((Object)focusProperties, (String)"");
        focusProperties.setOnEnter(this.onEnter);
        focusProperties.setOnExit(this.onExit);
    }

    @Override
    public final void onDetach() {
        if (!ComposeUiFlags.isNoPinningInFocusRestorationEnabled) {
            PinnableContainer.PinnedHandle pinnedHandle = this.pinnedHandle;
            if (pinnedHandle != null) {
                pinnedHandle.release();
            }
            this.pinnedHandle = null;
        }
        super.onDetach();
    }

    private static final Unit onExit$lambda$0(FocusRestorerNode focusRestorerNode, FocusEnterExitScope focusEnterExitScope) {
        Intrinsics.checkNotNullParameter((Object)focusEnterExitScope, (String)"");
        FocusRequesterModifierNodeKt.saveFocusedChild(focusRestorerNode);
        if (!ComposeUiFlags.isNoPinningInFocusRestorationEnabled) {
            PinnableContainer.PinnedHandle pinnedHandle = focusRestorerNode.pinnedHandle;
            if (pinnedHandle != null) {
                pinnedHandle.release();
            }
            focusRestorerNode.pinnedHandle = FocusRequesterModifierNodeKt.pinFocusedChild(focusRestorerNode);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEnter$lambda$1(FocusRestorerNode focusRestorerNode, FocusEnterExitScope focusEnterExitScope) {
        Intrinsics.checkNotNullParameter((Object)focusEnterExitScope, (String)"");
        if (!ComposeUiFlags.isNoPinningInFocusRestorationEnabled) {
            PinnableContainer.PinnedHandle pinnedHandle = focusRestorerNode.pinnedHandle;
            if (pinnedHandle != null) {
                pinnedHandle.release();
            }
            focusRestorerNode.pinnedHandle = null;
        }
        if (!FocusRequesterModifierNodeKt.restoreFocusedChild(focusRestorerNode) && !Intrinsics.areEqual((Object)focusRestorerNode.fallback, (Object)FocusRequester.Companion.getDefault())) {
            if (Intrinsics.areEqual((Object)focusRestorerNode.fallback, (Object)FocusRequester.Companion.getCancel())) {
                focusEnterExitScope.cancelFocusChange();
            } else {
                FocusRequester.requestFocus-3ESFkO8$default(focusRestorerNode.fallback, 0, 1, null);
            }
        }
        return Unit.INSTANCE;
    }
}

