/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.AggregationAssessor;
import ch.qos.logback.core.joran.util.StringToObjectConverter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.PropertySetterException;
import ch.qos.logback.core.util.StringUtil;
import java.lang.reflect.Method;

public class PropertySetter
extends ContextAwareBase {
    protected final Object obj;
    protected final Class<?> objClass;
    protected final BeanDescription beanDescription;
    protected final AggregationAssessor aggregationAssessor;

    public PropertySetter(BeanDescriptionCache beanDescriptionCache, Object object) {
        this.obj = object;
        this.objClass = object.getClass();
        this.beanDescription = beanDescriptionCache.getBeanDescription(this.objClass);
        this.aggregationAssessor = new AggregationAssessor(beanDescriptionCache, this.objClass);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.aggregationAssessor.setContext(context);
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        Method method = this.aggregationAssessor.findSetterMethod(string);
        if (method == null) {
            this.addWarn("No setter for property [" + string + "] in " + this.objClass.getName() + ".");
            return;
        }
        try {
            this.setProperty(method, string2);
            return;
        }
        catch (PropertySetterException propertySetterException) {
            this.addWarn("Failed to set property [" + string + "] to value \"" + string2 + "\". ", propertySetterException);
            return;
        }
    }

    private void setProperty(Method method, String object) {
        Class<?>[] classArray = method.getParameterTypes();
        try {
            object = StringToObjectConverter.convertArg(this, (String)object, classArray[0]);
        }
        catch (Throwable throwable) {
            throw new PropertySetterException("Conversion to type [" + String.valueOf(classArray[0]) + "] failed. ", throwable);
        }
        if (object == null) {
            throw new PropertySetterException("Conversion to type [" + String.valueOf(classArray[0]) + "] failed.");
        }
        try {
            method.invoke(this.obj, object);
            return;
        }
        catch (Exception exception) {
            throw new PropertySetterException(exception);
        }
    }

    public AggregationType computeAggregationType(String string) {
        return this.aggregationAssessor.computeAggregationType(string);
    }

    public Class<?> getObjClass() {
        return this.objClass;
    }

    public void addComplexProperty(String string, Object object) {
        Method method = this.aggregationAssessor.findAdderMethod(string);
        if (method != null) {
            Class<?>[] classArray = method.getParameterTypes();
            if (!this.isSanityCheckSuccessful(string, method, classArray, object)) {
                return;
            }
            this.invokeMethodWithSingleParameterOnThisObject(method, object);
            return;
        }
        this.addError("Could not find method [add" + string + "] in class [" + this.objClass.getName() + "].");
    }

    void invokeMethodWithSingleParameterOnThisObject(Method method, Object object) {
        Class<?> clazz = object.getClass();
        try {
            method.invoke(this.obj, object);
            return;
        }
        catch (Exception exception) {
            this.addError("Could not invoke method " + method.getName() + " in class " + this.obj.getClass().getName() + " with parameter of type " + clazz.getName(), exception);
            return;
        }
    }

    public void addBasicProperty(String object, String string) {
        if (string == null) {
            return;
        }
        Method method = this.aggregationAssessor.findAdderMethod((String)(object = StringUtil.capitalizeFirstLetter((String)object)));
        if (method == null) {
            this.addError("No adder for property [" + (String)object + "].");
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        this.isSanityCheckSuccessful((String)object, method, classArray, string);
        try {
            object = StringToObjectConverter.convertArg(this, string, classArray[0]);
        }
        catch (Throwable throwable) {
            this.addError("Conversion to type [" + String.valueOf(classArray[0]) + "] failed. ", throwable);
            return;
        }
        if (object != null) {
            this.invokeMethodWithSingleParameterOnThisObject(method, string);
        }
    }

    public void setComplexProperty(String string, Object object) {
        Method method = this.aggregationAssessor.findSetterMethod(string);
        if (method == null) {
            this.addWarn("Not setter method for property [" + string + "] in " + this.obj.getClass().getName());
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (!this.isSanityCheckSuccessful(string, method, classArray, object)) {
            return;
        }
        try {
            this.invokeMethodWithSingleParameterOnThisObject(method, object);
            return;
        }
        catch (Exception exception) {
            PropertySetter propertySetter = this;
            propertySetter.addError("Could not set component " + String.valueOf(propertySetter.obj) + " for parent component " + String.valueOf(this.obj), exception);
            return;
        }
    }

    private boolean isSanityCheckSuccessful(String string, Method genericDeclaration, Class<?>[] classArray, Object object) {
        genericDeclaration = object.getClass();
        if (classArray.length != 1) {
            this.addError("Wrong number of parameters in setter method for property [" + string + "] in " + this.obj.getClass().getName());
            return false;
        }
        if (!classArray[0].isAssignableFrom(object.getClass())) {
            this.addError("A \"" + ((Class)genericDeclaration).getName() + "\" object is not assignable to a \"" + classArray[0].getName() + "\" variable.");
            this.addError("The class \"" + classArray[0].getName() + "\" was loaded by ");
            this.addError("[" + String.valueOf(classArray[0].getClassLoader()) + "] whereas object of type ");
            this.addError("\"" + ((Class)genericDeclaration).getName() + "\" was loaded by [" + String.valueOf(((Class)genericDeclaration).getClassLoader()) + "].");
            return false;
        }
        return true;
    }

    public Object getObj() {
        return this.obj;
    }

    public Class<?> getClassNameViaImplicitRules(String string, AggregationType aggregationType, DefaultNestedComponentRegistry defaultNestedComponentRegistry) {
        return this.aggregationAssessor.getClassNameViaImplicitRules(string, aggregationType, defaultNestedComponentRegistry);
    }
}

