/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.InvocationGate;

public class DefaultInvocationGate
implements InvocationGate {
    static final int MASK_DECREASE_RIGHT_SHIFT_COUNT = 2;
    private static final int MAX_MASK = 65535;
    static final int DEFAULT_MASK = 15;
    private volatile long mask = 15L;
    private long invocationCounter = 0L;
    private static final long MASK_INCREASE_THRESHOLD = 100L;
    private static final long MASK_DECREASE_THRESHOLD = 800L;
    private long minDelayThreshold;
    private long maxDelayThreshold;
    long lowerLimitForMaskMatch;
    long upperLimitForNoMaskMatch;

    public DefaultInvocationGate() {
        this(100L, 800L, System.currentTimeMillis());
    }

    public DefaultInvocationGate(long l, long l2, long l3) {
        this.minDelayThreshold = l;
        this.maxDelayThreshold = l2;
        this.lowerLimitForMaskMatch = l3 + l;
        this.upperLimitForNoMaskMatch = l3 + l2;
    }

    @Override
    public final boolean isTooSoon(long l) {
        boolean bl;
        if (bl = (this.invocationCounter++ & this.mask) == this.mask) {
            if (l < this.lowerLimitForMaskMatch) {
                this.increaseMask();
            }
            this.updateLimits(l);
        } else if (l > this.upperLimitForNoMaskMatch) {
            this.decreaseMask();
            this.updateLimits(l);
            return false;
        }
        return !bl;
    }

    private void updateLimits(long l) {
        this.lowerLimitForMaskMatch = l + this.minDelayThreshold;
        this.upperLimitForNoMaskMatch = l + this.maxDelayThreshold;
    }

    long getMask() {
        return this.mask;
    }

    private void increaseMask() {
        if (this.mask >= 65535L) {
            return;
        }
        this.mask = this.mask << 1 | 1L;
    }

    private void decreaseMask() {
        this.mask >>>= 2;
    }

    public long getInvocationCounter() {
        return this.invocationCounter;
    }
}

