/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.PlatformKt;
import kotlinx.serialization.internal.PrimitivesKt;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;

@Metadata(mv={2, 1, 0}, k=5, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a+\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\b\n\u001a-\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u00062\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\b\r\u001aG\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\u000f\u0018\u00010\u0001\"\b\b\u0000\u0010\u000f*\u00020\u0002*\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\f2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00010\u0012H\u0002\u00a2\u0006\u0002\b\u0013\u001a)\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\b\u0016\u001a\u0015\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\f*\u00020\u0004H\u0002\u00a2\u0006\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"serializer", "Lkotlinx/serialization/KSerializer;", "", "type", "Ljava/lang/reflect/Type;", "serializerOrNull", "Lkotlinx/serialization/modules/SerializersModule;", "serializerByJavaTypeImpl", "failOnMissingTypeArgSerializer", "", "serializerByJavaTypeImpl$SerializersKt__SerializersJvmKt", "typeSerializer", "Ljava/lang/Class;", "typeSerializer$SerializersKt__SerializersJvmKt", "reflectiveOrContextual", "T", "jClass", "typeArgumentsSerializers", "", "reflectiveOrContextual$SerializersKt__SerializersJvmKt", "genericArraySerializer", "Ljava/lang/reflect/GenericArrayType;", "genericArraySerializer$SerializersKt__SerializersJvmKt", "prettyClass", "prettyClass$SerializersKt__SerializersJvmKt", "kotlinx-serialization-core"}, xs="kotlinx/serialization/SerializersKt")
final class SerializersKt__SerializersJvmKt {
    public static final KSerializer<Object> serializer(Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        return SerializersKt.serializer(SerializersModuleBuildersKt.EmptySerializersModule(), type);
    }

    public static final KSerializer<Object> serializerOrNull(Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        return SerializersKt.serializerOrNull(SerializersModuleBuildersKt.EmptySerializersModule(), type);
    }

    public static final KSerializer<Object> serializer(SerializersModule serializersModule, Type type) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"");
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        KSerializer<Object> kSerializer = SerializersKt__SerializersJvmKt.serializerByJavaTypeImpl$SerializersKt__SerializersJvmKt(serializersModule, type, true);
        if (kSerializer == null) {
            PlatformKt.serializerNotRegistered(SerializersKt__SerializersJvmKt.prettyClass$SerializersKt__SerializersJvmKt(type));
            throw new KotlinNothingValueException();
        }
        return kSerializer;
    }

    public static final KSerializer<Object> serializerOrNull(SerializersModule serializersModule, Type type) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"");
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        return SerializersKt__SerializersJvmKt.serializerByJavaTypeImpl$SerializersKt__SerializersJvmKt(serializersModule, type, false);
    }

    private static final KSerializer<Object> serializerByJavaTypeImpl$SerializersKt__SerializersJvmKt(SerializersModule serializersModule, Type typeArray, boolean bl) {
        Object typeArray2 = typeArray;
        if (typeArray instanceof GenericArrayType) {
            return SerializersKt__SerializersJvmKt.genericArraySerializer$SerializersKt__SerializersJvmKt(serializersModule, (GenericArrayType)typeArray, bl);
        }
        if (typeArray2 instanceof Class) {
            return SerializersKt__SerializersJvmKt.typeSerializer$SerializersKt__SerializersJvmKt(serializersModule, (Class)typeArray, bl);
        }
        if (typeArray2 instanceof ParameterizedType) {
            Iterable iterable;
            Iterable iterable2;
            Iterable<KSerializer> iterable3;
            int n;
            Iterable iterable4;
            Type[] typeArray3;
            Type type = ((ParameterizedType)typeArray).getRawType();
            Intrinsics.checkNotNull((Object)type);
            typeArray2 = (Class)type;
            typeArray = ((ParameterizedType)typeArray).getActualTypeArguments();
            if (bl) {
                Intrinsics.checkNotNull((Object)typeArray);
                typeArray3 = typeArray;
                iterable4 = new ArrayList(typeArray.length);
                n = typeArray3.length;
                for (int i = 0; i < n; ++i) {
                    Type type2;
                    Type object = type2 = typeArray3[i];
                    iterable3 = iterable4;
                    Intrinsics.checkNotNull((Object)object);
                    iterable3.add(SerializersKt.serializer(serializersModule, object));
                }
                iterable2 = (List)iterable4;
            } else {
                Intrinsics.checkNotNull((Object)typeArray);
                typeArray3 = typeArray;
                iterable4 = new ArrayList(typeArray.length);
                n = typeArray3.length;
                for (int i = 0; i < n; ++i) {
                    Type type3;
                    Type type4 = type3 = typeArray3[i];
                    iterable3 = iterable4;
                    Intrinsics.checkNotNull((Object)type4);
                    KSerializer<Object> kSerializer = SerializersKt.serializerOrNull(serializersModule, type4);
                    if (kSerializer == null) {
                        return null;
                    }
                    iterable3.add(kSerializer);
                }
                iterable2 = iterable = (List)iterable4;
            }
            if (Set.class.isAssignableFrom((Class<?>)typeArray2)) {
                KSerializer<Object> kSerializer = BuiltinSerializersKt.SetSerializer((KSerializer)iterable.get(0));
                Intrinsics.checkNotNull(kSerializer);
                return kSerializer;
            }
            if (List.class.isAssignableFrom((Class<?>)typeArray2) || Collection.class.isAssignableFrom((Class<?>)typeArray2)) {
                KSerializer<Object> kSerializer = BuiltinSerializersKt.ListSerializer((KSerializer)iterable.get(0));
                Intrinsics.checkNotNull(kSerializer);
                return kSerializer;
            }
            if (Map.class.isAssignableFrom((Class<?>)typeArray2)) {
                KSerializer<Object> kSerializer = BuiltinSerializersKt.MapSerializer((KSerializer)iterable.get(0), (KSerializer)iterable.get(1));
                Intrinsics.checkNotNull(kSerializer);
                return kSerializer;
            }
            if (Map.Entry.class.isAssignableFrom((Class<?>)typeArray2)) {
                KSerializer<Object> kSerializer = BuiltinSerializersKt.MapEntrySerializer((KSerializer)iterable.get(0), (KSerializer)iterable.get(1));
                Intrinsics.checkNotNull(kSerializer);
                return kSerializer;
            }
            if (Pair.class.isAssignableFrom((Class<?>)typeArray2)) {
                KSerializer kSerializer = BuiltinSerializersKt.PairSerializer((KSerializer)iterable.get(0), (KSerializer)iterable.get(1));
                Intrinsics.checkNotNull(kSerializer);
                return kSerializer;
            }
            if (Triple.class.isAssignableFrom((Class<?>)typeArray2)) {
                KSerializer kSerializer = BuiltinSerializersKt.TripleSerializer((KSerializer)iterable.get(0), (KSerializer)iterable.get(1), (KSerializer)iterable.get(2));
                Intrinsics.checkNotNull(kSerializer);
                return kSerializer;
            }
            iterable = iterable;
            iterable4 = iterable;
            iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            for (Object e : iterable4) {
                KSerializer kSerializer = (KSerializer)e;
                iterable3 = iterable;
                Intrinsics.checkNotNull((Object)kSerializer);
                iterable3.add(kSerializer);
            }
            iterable = (List)iterable;
            return SerializersKt__SerializersJvmKt.reflectiveOrContextual$SerializersKt__SerializersJvmKt(serializersModule, typeArray2, iterable);
        }
        if (typeArray2 instanceof WildcardType) {
            Type[] typeArray3 = ((WildcardType)typeArray).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray3, (String)"");
            Object object = ArraysKt.first((Object[])typeArray3);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
            return SerializersKt__SerializersJvmKt.serializerByJavaTypeImpl$SerializersKt__SerializersJvmKt$default(serializersModule, (Type)object, false, 2, null);
        }
        throw new IllegalArgumentException("type should be an instance of Class<?>, GenericArrayType, ParametrizedType or WildcardType, but actual argument " + typeArray + " has type " + Reflection.getOrCreateKotlinClass(typeArray.getClass()));
    }

    static /* synthetic */ KSerializer serializerByJavaTypeImpl$SerializersKt__SerializersJvmKt$default(SerializersModule serializersModule, Type type, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return SerializersKt__SerializersJvmKt.serializerByJavaTypeImpl$SerializersKt__SerializersJvmKt(serializersModule, type, bl);
    }

    private static final KSerializer<Object> typeSerializer$SerializersKt__SerializersJvmKt(SerializersModule kSerializer, Class<?> clazz, boolean bl) {
        if (clazz.isArray() && !clazz.getComponentType().isPrimitive()) {
            KSerializer<Object> kSerializer2;
            Class<?> clazz2 = clazz.getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"");
            clazz = clazz2;
            if (bl) {
                kSerializer2 = SerializersKt.serializer((SerializersModule)((Object)kSerializer), clazz);
            } else {
                kSerializer2 = SerializersKt.serializerOrNull((SerializersModule)((Object)kSerializer), clazz);
                if (kSerializer2 == null) {
                    return null;
                }
            }
            kSerializer = kSerializer2;
            KClass kClass = JvmClassMappingKt.getKotlinClass(clazz);
            Intrinsics.checkNotNull((Object)kClass);
            kSerializer = BuiltinSerializersKt.ArraySerializer(kClass, kSerializer);
            Intrinsics.checkNotNull(kSerializer);
            return kSerializer;
        }
        Intrinsics.checkNotNull(clazz);
        return SerializersKt__SerializersJvmKt.reflectiveOrContextual$SerializersKt__SerializersJvmKt((SerializersModule)((Object)kSerializer), clazz, CollectionsKt.emptyList());
    }

    private static final <T> KSerializer<T> reflectiveOrContextual$SerializersKt__SerializersJvmKt(SerializersModule serializersModule, Class<T> clazz, List<? extends KSerializer<Object>> list) {
        KSerializer[] kSerializerArray = (KSerializer[])list;
        KClass kClass = kSerializerArray;
        kClass = kSerializerArray;
        kClass = kSerializerArray.toArray(new KSerializer[0]);
        if ((kClass = PlatformKt.constructSerializerForGivenTypeArgs(clazz, Arrays.copyOf(kClass, ((KSerializer[])kClass).length))) != null) {
            return kClass;
        }
        kClass = JvmClassMappingKt.getKotlinClass(clazz);
        KSerializer kSerializer = PrimitivesKt.builtinSerializerOrNull(kClass);
        if (kSerializer == null && (kSerializer = serializersModule.getContextual(kClass, list)) == null) {
            if (clazz.isInterface()) {
                return new PolymorphicSerializer(JvmClassMappingKt.getKotlinClass(clazz));
            }
            kSerializer = null;
        }
        return kSerializer;
    }

    private static final KSerializer<Object> genericArraySerializer$SerializersKt__SerializersJvmKt(SerializersModule object, GenericArrayType type, boolean bl) {
        KClass kClass;
        KSerializer<Object> kSerializer;
        Type type2;
        if ((type = type.getGenericComponentType()) instanceof WildcardType) {
            Type[] typeArray = ((WildcardType)type).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
            type2 = (Type)ArraysKt.first((Object[])typeArray);
        } else {
            type2 = type = type;
        }
        if (bl) {
            Intrinsics.checkNotNull((Object)type);
            kSerializer = SerializersKt.serializer((SerializersModule)object, type);
        } else {
            Intrinsics.checkNotNull((Object)type);
            kSerializer = SerializersKt.serializerOrNull((SerializersModule)object, type);
            if (kSerializer == null) {
                return null;
            }
        }
        object = kSerializer;
        Type type3 = type;
        if (type3 instanceof ParameterizedType) {
            Type type4 = ((ParameterizedType)type).getRawType();
            Intrinsics.checkNotNull((Object)type4);
            kClass = JvmClassMappingKt.getKotlinClass((Class)((Class)type4));
        } else if (type3 instanceof KClass) {
            kClass = (KClass)type;
        } else {
            throw new IllegalStateException("unsupported type in GenericArray: " + Reflection.getOrCreateKotlinClass(type.getClass()));
        }
        type = kClass;
        Intrinsics.checkNotNull((Object)kClass);
        KSerializer<E[]> kSerializer2 = BuiltinSerializersKt.ArraySerializer(type, object);
        Intrinsics.checkNotNull(kSerializer2);
        return kSerializer2;
    }

    private static final Class<?> prettyClass$SerializersKt__SerializersJvmKt(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type type2 = ((ParameterizedType)type).getRawType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"");
            return SerializersKt__SerializersJvmKt.prettyClass$SerializersKt__SerializersJvmKt(type2);
        }
        if (type instanceof WildcardType) {
            Type[] typeArray = ((WildcardType)type).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
            Object object = ArraysKt.first((Object[])typeArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
            return SerializersKt__SerializersJvmKt.prettyClass$SerializersKt__SerializersJvmKt((Type)object);
        }
        if (type instanceof GenericArrayType) {
            Type type3 = ((GenericArrayType)type).getGenericComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"");
            return SerializersKt__SerializersJvmKt.prettyClass$SerializersKt__SerializersJvmKt(type3);
        }
        throw new IllegalArgumentException("type should be an instance of Class<?>, GenericArrayType, ParametrizedType or WildcardType, but actual argument " + type + " has type " + Reflection.getOrCreateKotlinClass(type.getClass()));
    }
}

