/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.JvmFunctionSignature;
import kotlin.reflect.jvm.internal.JvmPropertySignature;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KDeclarationContainerImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.RuntimeTypeMapper;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.calls.Caller;
import kotlin.reflect.jvm.internal.calls.CallerImpl;
import kotlin.reflect.jvm.internal.calls.InternalUnderlyingValOfInlineClass;
import kotlin.reflect.jvm.internal.calls.ThrowingCaller;
import kotlin.reflect.jvm.internal.calls.ValueClassAwareCallerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002\"\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"boundReceiver", "", "Lkotlin/reflect/jvm/internal/KPropertyImpl$Accessor;", "getBoundReceiver", "(Lkotlin/reflect/jvm/internal/KPropertyImpl$Accessor;)Ljava/lang/Object;", "computeCallerForAccessor", "Lkotlin/reflect/jvm/internal/calls/Caller;", "isGetter", "", "isJvmFieldPropertyInCompanionObject", "Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;", "kotlin-reflection"})
public final class KPropertyImplKt {
    public static final Object getBoundReceiver(KPropertyImpl.Accessor<?, ?> accessor) {
        Intrinsics.checkNotNullParameter(accessor, (String)"");
        return accessor.getProperty().getBoundReceiver();
    }

    private static final Caller<?> computeCallerForAccessor(KPropertyImpl.Accessor<?, ?> accessor, boolean bl) {
        Caller caller;
        if (KDeclarationContainerImpl.Companion.getLOCAL_PROPERTY_SIGNATURE$kotlin_reflection().matches((CharSequence)accessor.getProperty().getSignature())) {
            return ThrowingCaller.INSTANCE;
        }
        Object object = RuntimeTypeMapper.INSTANCE.mapPropertySignature(accessor.getProperty().getDescriptor());
        Class<?> clazz = object;
        if (object instanceof JvmPropertySignature.KotlinProperty) {
            Object object2;
            clazz = ((JvmPropertySignature.KotlinProperty)object).getSignature();
            Serializable serializable = bl ? (((JvmProtoBuf.JvmPropertySignature)((Object)clazz)).hasGetter() ? ((JvmProtoBuf.JvmPropertySignature)((Object)clazz)).getGetter() : null) : (clazz = ((JvmProtoBuf.JvmPropertySignature)((Object)clazz)).hasSetter() ? ((JvmProtoBuf.JvmPropertySignature)((Object)clazz)).getSetter() : null);
            if (serializable != null) {
                clazz = serializable;
                object2 = ((KCallableImpl)accessor.getProperty()).getContainer().findMethodBySignature(((JvmPropertySignature.KotlinProperty)object).getNameResolver().getString(((JvmProtoBuf.JvmMethodSignature)((Object)clazz)).getName()), ((JvmPropertySignature.KotlinProperty)object).getNameResolver().getString(((JvmProtoBuf.JvmMethodSignature)((Object)clazz)).getDesc()));
            } else {
                object2 = object = null;
            }
            if (object2 == null) {
                if (InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(accessor.getProperty().getDescriptor()) && Intrinsics.areEqual((Object)accessor.getProperty().getDescriptor().getVisibility(), (Object)DescriptorVisibilities.INTERNAL)) {
                    Class<?> clazz2 = ValueClassAwareCallerKt.toInlineClass(accessor.getProperty().getDescriptor().getContainingDeclaration());
                    if (clazz2 == null || (clazz2 = ValueClassAwareCallerKt.getInlineClassUnboxMethod(clazz2, accessor.getProperty().getDescriptor())) == null) {
                        throw new KotlinReflectionInternalError("Underlying property of inline class " + accessor.getProperty() + " should have a field");
                    }
                    clazz = clazz2;
                    caller = ((KCallableImpl)accessor).isBound() ? (InternalUnderlyingValOfInlineClass)new InternalUnderlyingValOfInlineClass.Bound((Method)((Object)clazz), KPropertyImplKt.getBoundReceiver(accessor)) : (InternalUnderlyingValOfInlineClass)new InternalUnderlyingValOfInlineClass.Unbound((Method)((Object)clazz));
                } else {
                    Field field = accessor.getProperty().getJavaField();
                    if (field == null) {
                        throw new KotlinReflectionInternalError("No accessors or field is found for property " + accessor.getProperty());
                    }
                    clazz = field;
                    caller = KPropertyImplKt.computeCallerForAccessor$computeFieldCaller(accessor, bl, (Field)((Object)clazz));
                }
            } else {
                caller = !Modifier.isStatic(((Method)object).getModifiers()) ? (Caller)(((KCallableImpl)accessor).isBound() ? (CallerImpl.Method)new CallerImpl.Method.BoundInstance((Method)object, KPropertyImplKt.getBoundReceiver(accessor)) : (CallerImpl.Method)new CallerImpl.Method.Instance((Method)object)) : (KPropertyImplKt.computeCallerForAccessor$isJvmStaticProperty(accessor) ? (Caller)(((KCallableImpl)accessor).isBound() ? (CallerImpl.Method)new CallerImpl.Method.BoundJvmStaticInObject((Method)object) : (CallerImpl.Method)new CallerImpl.Method.JvmStaticInObject((Method)object)) : (Caller)(((KCallableImpl)accessor).isBound() ? (CallerImpl.Method)new CallerImpl.Method.BoundStatic((Method)object, false, KPropertyImplKt.getBoundReceiver(accessor)) : (CallerImpl.Method)new CallerImpl.Method.Static((Method)object)));
            }
        } else if (clazz instanceof JvmPropertySignature.JavaField) {
            caller = KPropertyImplKt.computeCallerForAccessor$computeFieldCaller(accessor, bl, ((JvmPropertySignature.JavaField)object).getField());
        } else if (clazz instanceof JvmPropertySignature.JavaMethodProperty) {
            Method method;
            if (bl) {
                method = ((JvmPropertySignature.JavaMethodProperty)object).getGetterMethod();
            } else {
                method = ((JvmPropertySignature.JavaMethodProperty)object).getSetterMethod();
                if (method == null) {
                    throw new KotlinReflectionInternalError("No source found for setter of Java method property: " + ((JvmPropertySignature.JavaMethodProperty)object).getGetterMethod());
                }
            }
            clazz = method;
            caller = ((KCallableImpl)accessor).isBound() ? (CallerImpl.Method)new CallerImpl.Method.BoundInstance((Method)((Object)clazz), KPropertyImplKt.getBoundReceiver(accessor)) : (CallerImpl.Method)new CallerImpl.Method.Instance((Method)((Object)clazz));
        } else {
            if (clazz instanceof JvmPropertySignature.MappedKotlinProperty) {
                boolean bl2;
                JvmFunctionSignature.KotlinFunction kotlinFunction;
                if (bl) {
                    kotlinFunction = ((JvmPropertySignature.MappedKotlinProperty)object).getGetterSignature();
                } else {
                    kotlinFunction = ((JvmPropertySignature.MappedKotlinProperty)object).getSetterSignature();
                    if (kotlinFunction == null) {
                        throw new KotlinReflectionInternalError("No setter found for property " + accessor.getProperty());
                    }
                }
                clazz = kotlinFunction;
                Method method = ((KCallableImpl)accessor.getProperty()).getContainer().findMethodBySignature(((JvmFunctionSignature.KotlinFunction)((Object)clazz)).getMethodName(), ((JvmFunctionSignature.KotlinFunction)((Object)clazz)).getMethodDesc());
                if (method == null) {
                    throw new KotlinReflectionInternalError("No accessor found for property " + accessor.getProperty());
                }
                object = method;
                boolean bl3 = bl2 = !Modifier.isStatic(method.getModifiers());
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Mapped property cannot have a static accessor: " + accessor.getProperty();
                    throw new AssertionError((Object)string);
                }
                if (((KCallableImpl)accessor).isBound()) {
                    return new CallerImpl.Method.BoundInstance((Method)object, KPropertyImplKt.getBoundReceiver(accessor));
                }
                return new CallerImpl.Method.Instance((Method)object);
            }
            throw new NoWhenBranchMatchedException();
        }
        return ValueClassAwareCallerKt.createValueClassAwareCallerIfNeeded$default(caller, accessor.getDescriptor(), false, 2, null);
    }

    private static final boolean isJvmFieldPropertyInCompanionObject(PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        if (!DescriptorUtils.isCompanionObject(declarationDescriptor)) {
            return false;
        }
        return !DescriptorUtils.isInterface(declarationDescriptor2 = declarationDescriptor2.getContainingDeclaration()) && !DescriptorUtils.isAnnotationClass(declarationDescriptor2) || propertyDescriptor instanceof DeserializedPropertyDescriptor && JvmProtoBufUtil.isMovedFromInterfaceCompanion(((DeserializedPropertyDescriptor)propertyDescriptor).getProto());
    }

    private static final boolean computeCallerForAccessor$isJvmStaticProperty(KPropertyImpl.Accessor<?, ?> accessor) {
        return accessor.getProperty().getDescriptor().getAnnotations().hasAnnotation(UtilKt.getJVM_STATIC());
    }

    private static final boolean computeCallerForAccessor$isNotNullProperty(KPropertyImpl.Accessor<?, ?> accessor) {
        return !TypeUtils.isNullableType(accessor.getProperty().getDescriptor().getType());
    }

    private static final CallerImpl<Field> computeCallerForAccessor$computeFieldCaller(KPropertyImpl.Accessor<?, ?> accessor, boolean bl, Field field) {
        if (KPropertyImplKt.isJvmFieldPropertyInCompanionObject(accessor.getProperty().getDescriptor()) || !Modifier.isStatic(field.getModifiers())) {
            if (bl) {
                return ((KCallableImpl)accessor).isBound() ? (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.BoundInstance(field, KPropertyImplKt.getBoundReceiver(accessor)) : (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.Instance(field);
            }
            if (((KCallableImpl)accessor).isBound()) {
                return new CallerImpl.FieldSetter.BoundInstance(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor), KPropertyImplKt.getBoundReceiver(accessor));
            }
            return new CallerImpl.FieldSetter.Instance(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor));
        }
        if (KPropertyImplKt.computeCallerForAccessor$isJvmStaticProperty(accessor)) {
            if (bl) {
                return ((KCallableImpl)accessor).isBound() ? (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.BoundJvmStaticInObject(field) : (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.JvmStaticInObject(field);
            }
            if (((KCallableImpl)accessor).isBound()) {
                return new CallerImpl.FieldSetter.BoundJvmStaticInObject(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor));
            }
            return new CallerImpl.FieldSetter.JvmStaticInObject(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor));
        }
        if (bl) {
            return new CallerImpl.FieldGetter.Static(field);
        }
        return new CallerImpl.FieldSetter.Static(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor));
    }

    public static final /* synthetic */ Caller access$computeCallerForAccessor(KPropertyImpl.Accessor accessor, boolean bl) {
        return KPropertyImplKt.computeCallerForAccessor(accessor, bl);
    }
}

