/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"createPlatformKType", "Lkotlin/reflect/KType;", "lowerBound", "upperBound", "createMutableCollectionKType", "type", "readOnlyToMutable", "Lkotlin/reflect/jvm/internal/impl/descriptors/ClassDescriptor;", "createNothingType", "kotlin-reflection"})
public final class TypeOfImplKt {
    public static final KType createPlatformKType(KType kType, KType kType2) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kType2, (String)"");
        KotlinType kotlinType = ((KTypeImpl)kType).getType();
        Intrinsics.checkNotNull((Object)kotlinType);
        SimpleType simpleType = (SimpleType)kotlinType;
        KotlinType kotlinType2 = ((KTypeImpl)kType2).getType();
        Intrinsics.checkNotNull((Object)kotlinType2);
        return (KType)new KTypeImpl(KotlinTypeFactory.flexibleType(simpleType, (SimpleType)kotlinType2), null, 2, null);
    }

    public static final KType createMutableCollectionKType(KType object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        KotlinType kotlinType = ((KTypeImpl)object).getType();
        if (!(kotlinType instanceof SimpleType)) {
            object = "Non-simple type cannot be a mutable collection type: " + object;
            throw new IllegalArgumentException(object.toString());
        }
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            throw new IllegalArgumentException("Non-class type cannot be a mutable collection type: " + object);
        }
        object = classDescriptor;
        SimpleType simpleType = (SimpleType)kotlinType;
        TypeConstructor typeConstructor2 = TypeOfImplKt.readOnlyToMutable((ClassDescriptor)object).getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        return (KType)new KTypeImpl(KotlinTypeFactory.simpleType$default(simpleType, null, typeConstructor2, null, false, 26, null), null, 2, null);
    }

    private static final ClassDescriptor readOnlyToMutable(ClassDescriptor classDescriptor) {
        FqName fqName = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(DescriptorUtilsKt.getFqNameUnsafe(classDescriptor));
        if (fqName == null) {
            throw new IllegalArgumentException("Not a readonly collection: " + classDescriptor);
        }
        FqName fqName2 = fqName;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns(classDescriptor).getBuiltInClassByFqName(fqName2);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"");
        return classDescriptor2;
    }

    public static final KType createNothingType(KType object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        KotlinType kotlinType = ((KTypeImpl)object).getType();
        if (!(kotlinType instanceof SimpleType)) {
            object = "Non-simple type cannot be a Nothing type: " + object;
            throw new IllegalArgumentException(object.toString());
        }
        SimpleType simpleType = (SimpleType)kotlinType;
        TypeConstructor typeConstructor2 = TypeUtilsKt.getBuiltIns(kotlinType).getNothing().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        return (KType)new KTypeImpl(KotlinTypeFactory.simpleType$default(simpleType, null, typeConstructor2, null, false, 26, null), null, 2, null);
    }
}

