/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.incremental;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LocationInfo;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupTracker;
import kotlin.reflect.jvm.internal.impl.incremental.components.Position;
import kotlin.reflect.jvm.internal.impl.incremental.components.ScopeKind;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;

public final class UtilsKt {
    public static final void record(LookupTracker lookupTracker, LookupLocation object, ClassDescriptor classDescriptor, Name name) {
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        if (lookupTracker == LookupTracker.DO_NOTHING.INSTANCE) {
            return;
        }
        LocationInfo locationInfo = object.getLocation();
        if (locationInfo == null) {
            return;
        }
        object = locationInfo;
        Position position = lookupTracker.getRequiresPosition() ? object.getPosition() : Position.Companion.getNO_POSITION();
        String string = object.getFilePath();
        String string2 = DescriptorUtils.getFqName(classDescriptor).asString();
        String string3 = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        lookupTracker.record(string, position, string2, ScopeKind.CLASSIFIER, string3);
    }

    public static final void record(LookupTracker lookupTracker, LookupLocation lookupLocation, PackageFragmentDescriptor packageFragmentDescriptor, Name name) {
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        Intrinsics.checkNotNullParameter((Object)packageFragmentDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        String string = packageFragmentDescriptor.getFqName().asString();
        String string2 = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        UtilsKt.recordPackageLookup(lookupTracker, lookupLocation, string, string2);
    }

    public static final void recordPackageLookup(LookupTracker lookupTracker, LookupLocation object, String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        if (lookupTracker == LookupTracker.DO_NOTHING.INSTANCE) {
            return;
        }
        LocationInfo locationInfo = object.getLocation();
        if (locationInfo == null) {
            return;
        }
        object = locationInfo;
        Position position = lookupTracker.getRequiresPosition() ? object.getPosition() : Position.Companion.getNO_POSITION();
        lookupTracker.record(object.getFilePath(), position, string, ScopeKind.PACKAGE, string2);
    }
}

