/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMapper;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.UtilsKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.TypeParameterResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributes;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeFlexibility;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolver$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawProjectionComputer;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaArrayType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypesKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.types.ErasureProjectionComputer;
import kotlin.reflect.jvm.internal.impl.types.ErasureTypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.LazyWrappedType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeParameterUpperBoundEraser;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUsage;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class JavaTypeResolver {
    private final LazyJavaResolverContext c;
    private final TypeParameterResolver typeParameterResolver;
    private final RawProjectionComputer projectionComputer;
    private final TypeParameterUpperBoundEraser typeParameterUpperBoundEraser;

    public JavaTypeResolver(LazyJavaResolverContext lazyJavaResolverContext, TypeParameterResolver typeParameterResolver) {
        Intrinsics.checkNotNullParameter((Object)lazyJavaResolverContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeParameterResolver, (String)"");
        this.c = lazyJavaResolverContext;
        this.typeParameterResolver = typeParameterResolver;
        this.projectionComputer = new RawProjectionComputer();
        this.typeParameterUpperBoundEraser = new TypeParameterUpperBoundEraser(this.projectionComputer, null, 2, null);
    }

    public final KotlinType transformJavaType(JavaType object, JavaTypeAttributes javaTypeAttributes) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)javaTypeAttributes, (String)"");
        JavaType javaType = object;
        if (javaType instanceof JavaPrimitiveType) {
            object = (object = ((JavaPrimitiveType)object).getType()) != null ? this.c.getModule().getBuiltIns().getPrimitiveKotlinType((PrimitiveType)((Object)object)) : this.c.getModule().getBuiltIns().getUnitType();
            Intrinsics.checkNotNull((Object)object);
            return (KotlinType)object;
        }
        if (javaType instanceof JavaClassifierType) {
            return this.transformJavaClassifierType((JavaClassifierType)object, javaTypeAttributes);
        }
        if (javaType instanceof JavaArrayType) {
            return JavaTypeResolver.transformArrayType$default(this, (JavaArrayType)object, javaTypeAttributes, false, 4, null);
        }
        if (javaType instanceof JavaWildcardType) {
            object2 = ((JavaWildcardType)object).getBound();
            if (object2 == null || (object2 = this.transformJavaType((JavaType)(object = object2), javaTypeAttributes)) == null) {
                SimpleType simpleType = this.c.getModule().getBuiltIns().getDefaultBound();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                return simpleType;
            }
        } else {
            if (javaType == null) {
                SimpleType simpleType = this.c.getModule().getBuiltIns().getDefaultBound();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                return simpleType;
            }
            throw new UnsupportedOperationException("Unsupported type: " + object);
        }
        return object2;
    }

    public final KotlinType transformArrayType(JavaArrayType object, JavaTypeAttributes object2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        Object object3 = object.getComponentType();
        JavaPrimitiveType javaPrimitiveType = object3 instanceof JavaPrimitiveType ? (JavaPrimitiveType)object3 : null;
        PrimitiveType primitiveType = javaPrimitiveType != null ? javaPrimitiveType.getType() : null;
        object = new LazyJavaAnnotations(this.c, (JavaAnnotationOwner)object, true);
        if (primitiveType != null) {
            SimpleType simpleType = this.c.getModule().getBuiltIns().getPrimitiveArrayKotlinType(primitiveType);
            Intrinsics.checkNotNull((Object)simpleType);
            Annotations[] annotationsArray = new Annotations[2];
            object3 = annotationsArray;
            annotationsArray[0] = simpleType.getAnnotations();
            object3[1] = object;
            KotlinType kotlinType = TypeUtilsKt.replaceAnnotations(simpleType, new CompositeAnnotations((Annotations[])object3));
            Intrinsics.checkNotNull((Object)kotlinType);
            object3 = (SimpleType)kotlinType;
            if (((JavaTypeAttributes)object2).isForAnnotationParameter()) {
                return (KotlinType)object3;
            }
            Object object4 = object3;
            return KotlinTypeFactory.flexibleType((SimpleType)object4, ((SimpleType)object4).makeNullableAsSpecified(true));
        }
        object3 = this.transformJavaType((JavaType)object3, JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, ((JavaTypeAttributes)object2).isForAnnotationParameter(), false, null, 6, null));
        if (((JavaTypeAttributes)object2).isForAnnotationParameter()) {
            object2 = bl ? Variance.OUT_VARIANCE : Variance.INVARIANT;
            SimpleType simpleType = this.c.getModule().getBuiltIns().getArrayType((Variance)((Object)object2), (KotlinType)object3, (Annotations)object);
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
            return simpleType;
        }
        SimpleType simpleType = this.c.getModule().getBuiltIns().getArrayType(Variance.INVARIANT, (KotlinType)object3, (Annotations)object);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
        return KotlinTypeFactory.flexibleType(simpleType, this.c.getModule().getBuiltIns().getArrayType(Variance.OUT_VARIANCE, (KotlinType)object3, (Annotations)object).makeNullableAsSpecified(true));
    }

    public static /* synthetic */ KotlinType transformArrayType$default(JavaTypeResolver javaTypeResolver, JavaArrayType javaArrayType, JavaTypeAttributes javaTypeAttributes, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaTypeResolver.transformArrayType(javaArrayType, javaTypeAttributes, bl);
    }

    private final KotlinType transformJavaClassifierType(JavaClassifierType object, JavaTypeAttributes javaTypeAttributes) {
        boolean bl = !javaTypeAttributes.isForAnnotationParameter() && ((ErasureTypeAttributes)javaTypeAttributes).getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
        boolean bl2 = object.isRaw();
        if (!bl2 && !bl) {
            SimpleType simpleType = this.computeSimpleJavaClassifierType((JavaClassifierType)object, javaTypeAttributes, null);
            if (simpleType != null) {
                return simpleType;
            }
            return JavaTypeResolver.transformJavaClassifierType$errorType((JavaClassifierType)object);
        }
        SimpleType simpleType = this.computeSimpleJavaClassifierType((JavaClassifierType)object, javaTypeAttributes.withFlexibility(JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND), null);
        if (simpleType == null) {
            return JavaTypeResolver.transformJavaClassifierType$errorType((JavaClassifierType)object);
        }
        SimpleType simpleType2 = simpleType;
        SimpleType simpleType3 = this.computeSimpleJavaClassifierType((JavaClassifierType)object, javaTypeAttributes.withFlexibility(JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND), simpleType2);
        if (simpleType3 == null) {
            return JavaTypeResolver.transformJavaClassifierType$errorType((JavaClassifierType)object);
        }
        object = simpleType3;
        if (bl2) {
            return new RawTypeImpl(simpleType2, (SimpleType)object);
        }
        return KotlinTypeFactory.flexibleType(simpleType2, (SimpleType)object);
    }

    private final SimpleType computeSimpleJavaClassifierType(JavaClassifierType object, JavaTypeAttributes javaTypeAttributes, SimpleType simpleType) {
        Object object2 = simpleType;
        if (object2 == null || (object2 = ((KotlinType)object2).getAttributes()) == null) {
            object2 = TypeAttributesKt.toDefaultAttributes(new LazyJavaAnnotations(this.c, (JavaAnnotationOwner)object, false, 4, null));
        }
        Object object3 = object2;
        TypeConstructor typeConstructor2 = this.computeTypeConstructor((JavaClassifierType)object, javaTypeAttributes);
        if (typeConstructor2 == null) {
            return null;
        }
        TypeConstructor typeConstructor3 = typeConstructor2;
        boolean bl = this.isNullable(javaTypeAttributes);
        SimpleType simpleType2 = simpleType;
        if (Intrinsics.areEqual((Object)(simpleType2 != null ? simpleType2.getConstructor() : null), (Object)typeConstructor3) && !object.isRaw() && bl) {
            return simpleType.makeNullableAsSpecified(true);
        }
        object = this.computeArguments((JavaClassifierType)object, javaTypeAttributes, typeConstructor3);
        return KotlinTypeFactory.simpleType$default((TypeAttributes)object3, typeConstructor3, (List)object, bl, null, 16, null);
    }

    private final TypeConstructor computeTypeConstructor(JavaClassifierType object, JavaTypeAttributes javaTypeAttributes) {
        Object object2;
        JavaClassifier javaClassifier = object.getClassifier();
        if (javaClassifier == null) {
            return this.createNotFoundClass((JavaClassifierType)object);
        }
        JavaClassifier javaClassifier2 = javaClassifier;
        Object object3 = javaClassifier;
        if (javaClassifier instanceof JavaClass) {
            object3 = ((JavaClass)javaClassifier2).getFqName();
            if (object3 == null) {
                object = "Class type should have a FQ name: " + javaClassifier2;
                throw new AssertionError(object);
            }
            ClassDescriptor classDescriptor = this.mapKotlinClass((JavaClassifierType)object, javaTypeAttributes, (FqName)object3);
            if (classDescriptor == null) {
                classDescriptor = this.c.getComponents().getModuleClassResolver().resolveClass((JavaClass)javaClassifier2);
            }
            object3 = classDescriptor;
            object2 = classDescriptor;
            if (classDescriptor == null || (object2 = object2.getTypeConstructor()) == null) {
                return this.createNotFoundClass((JavaClassifierType)object);
            }
        } else {
            if (object3 instanceof JavaTypeParameter) {
                TypeParameterDescriptor typeParameterDescriptor = this.typeParameterResolver.resolveTypeParameter((JavaTypeParameter)javaClassifier2);
                if (typeParameterDescriptor != null) {
                    return typeParameterDescriptor.getTypeConstructor();
                }
                return null;
            }
            throw new IllegalStateException("Unknown classifier kind: " + javaClassifier2);
        }
        return object2;
    }

    private final TypeConstructor createNotFoundClass(JavaClassifierType object) {
        object = ClassId.Companion.topLevel(new FqName(object.getClassifierQualifiedName()));
        TypeConstructor typeConstructor2 = this.c.getComponents().getDeserializedDescriptorResolver().getComponents().getNotFoundClasses().getClass((ClassId)object, CollectionsKt.listOf((Object)0)).getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        return typeConstructor2;
    }

    private final ClassDescriptor mapKotlinClass(JavaClassifierType javaClassifierType, JavaTypeAttributes javaTypeAttributes, FqName object) {
        if (javaTypeAttributes.isForAnnotationParameter() && Intrinsics.areEqual((Object)object, (Object)JavaTypeResolverKt.access$getJAVA_LANG_CLASS_FQ_NAME$p())) {
            return this.c.getComponents().getReflectionTypes().getKClass();
        }
        JavaToKotlinClassMapper javaToKotlinClassMapper = JavaToKotlinClassMapper.INSTANCE;
        ClassDescriptor classDescriptor = JavaToKotlinClassMapper.mapJavaToKotlin$default(javaToKotlinClassMapper, (FqName)object, this.c.getModule().getBuiltIns(), null, 4, null);
        if (classDescriptor == null) {
            return null;
        }
        object = classDescriptor;
        if (javaToKotlinClassMapper.isReadOnly((ClassDescriptor)object) && (javaTypeAttributes.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND || ((ErasureTypeAttributes)javaTypeAttributes).getHowThisTypeIsUsed() == TypeUsage.SUPERTYPE || this.argumentsMakeSenseOnlyForMutableContainer(javaClassifierType, (ClassDescriptor)object))) {
            return javaToKotlinClassMapper.convertReadOnlyToMutable((ClassDescriptor)object);
        }
        return object;
    }

    private final boolean argumentsMakeSenseOnlyForMutableContainer(JavaClassifierType object, ClassDescriptor classDescriptor) {
        if (!JavaTypesKt.isSuperWildcard((JavaType)CollectionsKt.lastOrNull(object.getTypeArguments()))) {
            return false;
        }
        List<TypeParameterDescriptor> list = JavaToKotlinClassMapper.INSTANCE.convertReadOnlyToMutable(classDescriptor).getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        object = (TypeParameterDescriptor)CollectionsKt.lastOrNull(list);
        if (object == null || (object = object.getVariance()) == null) {
            return false;
        }
        return object != Variance.OUT_VARIANCE;
    }

    private final List<TypeProjection> computeRawTypeArguments(JavaClassifierType javaClassifierType, List<? extends TypeParameterDescriptor> iterable, TypeConstructor typeConstructor2, JavaTypeAttributes javaTypeAttributes) {
        iterable = iterable;
        Object object = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            TypeProjection typeProjection;
            Object object2 = object.next();
            object2 = (TypeParameterDescriptor)object2;
            Iterable<TypeParameterDescriptor> iterable2 = iterable;
            if (TypeUtilsKt.hasTypeParameterRecursiveBounds(object2, null, ((ErasureTypeAttributes)javaTypeAttributes).getVisitedTypeParameters())) {
                typeProjection = TypeUtils.makeStarProjection(object2, javaTypeAttributes);
            } else {
                Object object3 = javaClassifierType;
                TypeConstructor typeConstructor3 = typeConstructor2;
                JavaTypeAttributes javaTypeAttributes2 = javaTypeAttributes;
                Object object4 = object2;
                JavaTypeResolver javaTypeResolver = this;
                object3 = new LazyWrappedType(this.c.getStorageManager(), new JavaTypeResolver$$Lambda$0(javaTypeResolver, (TypeParameterDescriptor)object4, javaTypeAttributes2, typeConstructor3, (JavaClassifierType)object3));
                typeProjection = ((ErasureProjectionComputer)this.projectionComputer).computeProjection((TypeParameterDescriptor)object2, javaTypeAttributes.markIsRaw(javaClassifierType.isRaw()), this.typeParameterUpperBoundEraser, (KotlinType)object3);
            }
            iterable2.add((TypeParameterDescriptor)((Object)typeProjection));
        }
        return iterable;
    }

    /*
     * Unable to fully structure code
     */
    private final List<TypeProjection> computeArguments(JavaClassifierType var1_1, JavaTypeAttributes var2_2, TypeConstructor var3_3) {
        var4_4 = var1_1.isRaw();
        if (var4_4 != 0) ** GOTO lbl-1000
        if (var1_1.getTypeArguments().isEmpty()) {
            v0 = var3_3.getParameters();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"");
            ** if (!(((Collection)v0).isEmpty() == false)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v1 = 1;
            ** GOTO lbl11
        }
lbl-1000:
        // 2 sources

        {
            v1 = 0;
        }
lbl11:
        // 2 sources

        var4_4 = v1;
        v2 = var3_3.getParameters();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"");
        var5_6 = v2;
        if (var4_4 != 0) {
            return this.computeRawTypeArguments((JavaClassifierType)var1_1, var5_6, (TypeConstructor)var3_3, (JavaTypeAttributes)var2_2);
        }
        if (var5_6.size() != var1_1.getTypeArguments().size()) {
            var1_1 = var5_6;
            var2_2 = var1_1;
            var1_1 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var1_1, (int)10));
            var2_2 = var2_2.iterator();
            while (var2_2.hasNext()) {
                var3_3 = var2_2.next();
                var3_3 = (TypeParameterDescriptor)var3_3;
                var7_7 = var1_1;
                v3 = new String[1];
                var4_5 = v3;
                v3[0] = var3_3.getName().asString();
                var7_7.add(new TypeProjectionImpl(ErrorUtils.createErrorType(ErrorTypeKind.MISSED_TYPE_ARGUMENT_FOR_TYPE_PARAMETER, var4_5)));
            }
            return CollectionsKt.toList((Iterable)((List)var1_1));
        }
        var1_1 = CollectionsKt.withIndex((Iterable)var1_1.getTypeArguments());
        var2_2 = var1_1;
        var1_1 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var1_1, (int)10));
        var2_2 = var2_2.iterator();
        while (var2_2.hasNext()) {
            var3_3 = var2_2.next();
            var3_3 = (IndexedValue)var3_3;
            var7_8 = var1_1;
            var4_4 = var3_3.component1();
            var3_3 = (JavaType)var3_3.component2();
            v4 = var6_10 = var4_4 < var5_6.size();
            if (_Assertions.ENABLED && !var6_10) {
                var1_1 = "Argument index should be less then type parameters count, but " + var4_4 + " > " + var5_6.size();
                throw new AssertionError(var1_1);
            }
            var6_9 = var5_6.get(var4_4);
            v5 = JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, false, false, null, 7, null);
            Intrinsics.checkNotNull((Object)var6_9);
            var7_8.add(this.transformToTypeProjection((JavaType)var3_3, v5, var6_9));
        }
        return CollectionsKt.toList((Iterable)((List)var1_1));
    }

    private final TypeProjection transformToTypeProjection(JavaType object, JavaTypeAttributes object2, TypeParameterDescriptor typeParameterDescriptor) {
        if (object instanceof JavaWildcardType) {
            Variance variance;
            JavaType javaType = ((JavaWildcardType)object).getBound();
            Variance variance2 = variance = ((JavaWildcardType)object).isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
            if (javaType == null || this.isConflictingArgumentFor(variance, typeParameterDescriptor)) {
                TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor, (ErasureTypeAttributes)object2);
                Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"");
                return typeProjection;
            }
            object = UtilsKt.extractNullabilityAnnotationOnBoundedWildcard(this.c, (JavaWildcardType)object);
            object2 = this.transformJavaType(javaType, JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, false, false, null, 7, null));
            object = object != null ? TypeUtilsKt.replaceAnnotations((KotlinType)object2, Annotations.Companion.create(CollectionsKt.plus((Iterable)((KotlinType)object2).getAnnotations(), (Object)object))) : object2;
            return TypeUtilsKt.createProjection((KotlinType)object, variance, typeParameterDescriptor);
        }
        return new TypeProjectionImpl(Variance.INVARIANT, this.transformJavaType((JavaType)object, (JavaTypeAttributes)object2));
    }

    private final boolean isConflictingArgumentFor(Variance variance, TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor.getVariance() == Variance.INVARIANT) {
            return false;
        }
        return variance != typeParameterDescriptor.getVariance();
    }

    private final boolean isNullable(JavaTypeAttributes javaTypeAttributes) {
        if (javaTypeAttributes.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND) {
            return false;
        }
        return !javaTypeAttributes.isForAnnotationParameter() && ((ErasureTypeAttributes)javaTypeAttributes).getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
    }

    private static final ErrorType transformJavaClassifierType$errorType(JavaClassifierType javaClassifierType) {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = javaClassifierType.getPresentableText();
        return ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_JAVA_CLASS, stringArray2);
    }

    private static final KotlinType computeRawTypeArguments$lambda$4$lambda$3(JavaTypeResolver javaTypeResolver, TypeParameterDescriptor typeParameterDescriptor, JavaTypeAttributes javaTypeAttributes, TypeConstructor typeConstructor2, JavaClassifierType javaClassifierType) {
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        return javaTypeResolver.typeParameterUpperBoundEraser.getErasedUpperBound(typeParameterDescriptor, javaTypeAttributes.withDefaultType(classifierDescriptor != null ? classifierDescriptor.getDefaultType() : null).markIsRaw(javaClassifierType.isRaw()));
    }

    static /* synthetic */ KotlinType accessor$JavaTypeResolver$lambda0(JavaTypeResolver javaTypeResolver, TypeParameterDescriptor typeParameterDescriptor, JavaTypeAttributes javaTypeAttributes, TypeConstructor typeConstructor2, JavaClassifierType javaClassifierType) {
        return JavaTypeResolver.computeRawTypeArguments$lambda$4$lambda$3(javaTypeResolver, typeParameterDescriptor, javaTypeAttributes, typeConstructor2, javaClassifierType);
    }
}

