/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.JavaResolverSettings;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.JavaTypeQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NotNullTypeParameterImpl;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPosition;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPositionKt;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.RawType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class JavaTypeEnhancement {
    private final JavaResolverSettings javaResolverSettings;

    public JavaTypeEnhancement(JavaResolverSettings javaResolverSettings) {
        Intrinsics.checkNotNullParameter((Object)javaResolverSettings, (String)"");
        this.javaResolverSettings = javaResolverSettings;
    }

    public final KotlinType enhance(KotlinType kotlinType, Function1<? super Integer, JavaTypeQualifiers> function1, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return this.enhancePossiblyFlexible(kotlinType.unwrap(), function1, 0, bl).getType();
    }

    private final Result enhancePossiblyFlexible(UnwrappedType unwrappedType, Function1<? super Integer, JavaTypeQualifiers> object, int n, boolean bl) {
        Object object2;
        block13: {
            UnwrappedType unwrappedType2;
            SimpleResult simpleResult;
            block15: {
                boolean bl2;
                block16: {
                    UnwrappedType unwrappedType3;
                    block18: {
                        block17: {
                            block14: {
                                if (KotlinTypeKt.isError(unwrappedType)) {
                                    return new Result(null, 1);
                                }
                                object2 = unwrappedType;
                                if (!(object2 instanceof FlexibleType)) break block13;
                                bl2 = unwrappedType instanceof RawType;
                                simpleResult = this.enhanceInflexible(((FlexibleType)unwrappedType).getLowerBound(), (Function1<? super Integer, JavaTypeQualifiers>)object, n, TypeComponentPosition.FLEXIBLE_LOWER, bl2, bl);
                                object = this.enhanceInflexible(((FlexibleType)unwrappedType).getUpperBound(), (Function1<? super Integer, JavaTypeQualifiers>)object, n, TypeComponentPosition.FLEXIBLE_UPPER, bl2, bl);
                                int n2 = n = simpleResult.getSubtreeSize() == ((SimpleResult)object).getSubtreeSize() ? 1 : 0;
                                if (_Assertions.ENABLED && n == 0) {
                                    object = "Different tree sizes of bounds: lower = (" + ((FlexibleType)unwrappedType).getLowerBound() + ", " + simpleResult.getSubtreeSize() + "), upper = (" + ((FlexibleType)unwrappedType).getUpperBound() + ", " + ((SimpleResult)object).getSubtreeSize() + ')';
                                    throw new AssertionError(object);
                                }
                                if (simpleResult.getType() != null || ((SimpleResult)object).getType() != null) break block14;
                                unwrappedType2 = null;
                                break block15;
                            }
                            if (!simpleResult.getForWarnings() && !((SimpleResult)object).getForWarnings()) break block16;
                            unwrappedType3 = ((SimpleResult)object).getType();
                            if (unwrappedType3 == null) break block17;
                            object = unwrappedType3;
                            Object object3 = simpleResult.getType();
                            if (object3 == null) {
                                object3 = object;
                            }
                            if ((unwrappedType3 = KotlinTypeFactory.flexibleType((SimpleType)object3, (SimpleType)object)) != null) break block18;
                        }
                        SimpleType simpleType = simpleResult.getType();
                        Intrinsics.checkNotNull((Object)simpleType);
                        unwrappedType3 = simpleType;
                    }
                    object = unwrappedType3;
                    unwrappedType2 = TypeWithEnhancementKt.wrapEnhancement(unwrappedType, (KotlinType)object);
                    break block15;
                }
                if (bl2) {
                    SimpleType simpleType;
                    SimpleType simpleType2 = simpleResult.getType();
                    if (simpleType2 == null) {
                        simpleType2 = ((FlexibleType)unwrappedType).getLowerBound();
                    }
                    if ((simpleType = ((SimpleResult)object).getType()) == null) {
                        simpleType = ((FlexibleType)unwrappedType).getUpperBound();
                    }
                    unwrappedType2 = new RawTypeImpl(simpleType2, simpleType);
                } else {
                    SimpleType simpleType;
                    SimpleType simpleType3 = simpleResult.getType();
                    if (simpleType3 == null) {
                        simpleType3 = ((FlexibleType)unwrappedType).getLowerBound();
                    }
                    if ((simpleType = ((SimpleResult)object).getType()) == null) {
                        simpleType = ((FlexibleType)unwrappedType).getUpperBound();
                    }
                    unwrappedType2 = KotlinTypeFactory.flexibleType(simpleType3, simpleType);
                }
            }
            UnwrappedType unwrappedType4 = unwrappedType2;
            return new Result(unwrappedType4, simpleResult.getSubtreeSize());
        }
        if (object2 instanceof SimpleType) {
            object2 = JavaTypeEnhancement.enhanceInflexible$default(this, (SimpleType)unwrappedType, object, n, TypeComponentPosition.INFLEXIBLE, false, bl, 8, null);
            return new Result(((SimpleResult)object2).getForWarnings() ? TypeWithEnhancementKt.wrapEnhancement(unwrappedType, ((SimpleResult)object2).getType()) : (UnwrappedType)((SimpleResult)object2).getType(), ((SimpleResult)object2).getSubtreeSize());
        }
        throw new NoWhenBranchMatchedException();
    }

    private final SimpleResult enhanceInflexible(SimpleType simpleType, Function1<? super Integer, JavaTypeQualifiers> object, int n, TypeComponentPosition object2, boolean bl, boolean bl2) {
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        boolean bl3 = TypeComponentPositionKt.shouldEnhance((TypeComponentPosition)((Object)object2));
        boolean bl4 = bl = !bl2 || !bl;
        if (!bl3 && simpleType.getArguments().isEmpty()) {
            return new SimpleResult(null, 1, false);
        }
        ClassifierDescriptor classifierDescriptor = simpleType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new SimpleResult(null, 1, false);
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        JavaTypeQualifiers javaTypeQualifiers = (JavaTypeQualifiers)object.invoke((Object)n);
        classifierDescriptor2 = TypeEnhancementKt.access$enhanceMutability(classifierDescriptor2, javaTypeQualifiers, (TypeComponentPosition)((Object)object2));
        object2 = TypeEnhancementKt.access$getEnhancedNullability(javaTypeQualifiers, (TypeComponentPosition)((Object)object2));
        Object object7 = classifierDescriptor2;
        if (object7 == null || (object7 = object7.getTypeConstructor()) == null) {
            object7 = simpleType.getConstructor();
        }
        Object object8 = object7;
        int n2 = n + 1;
        Object object9 = simpleType.getArguments();
        List<TypeParameterDescriptor> list = object8.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Object object10 = (Object[])list;
        Object object11 = object9.iterator();
        Object object122 = object10.iterator();
        object10 = new ArrayList(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)object9, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)object10, (int)10)));
        while (object11.hasNext() && object122.hasNext()) {
            TypeProjection typeProjection;
            Result result;
            object6 = (TypeParameterDescriptor)object122.next();
            object5 = (TypeProjection)object11.next();
            object4 = object10;
            if (!bl) {
                result = new Result(null, 0);
            } else if (!object5.isStarProjection()) {
                result = this.enhancePossiblyFlexible(object5.getType().unwrap(), (Function1<? super Integer, JavaTypeQualifiers>)object, n2, bl2);
            } else if (((JavaTypeQualifiers)object.invoke((Object)n2)).getNullability() == NullabilityQualifier.FORCE_FLEXIBILITY) {
                object3 = object5.getType().unwrap();
                result = new Result(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible((KotlinType)object3).makeNullableAsSpecified(false), FlexibleTypesKt.upperIfFlexible((KotlinType)object3).makeNullableAsSpecified(true)), 1);
            } else {
                result = new Result(null, 1);
            }
            object9 = result;
            n2 += ((Result)object9).getSubtreeSize();
            if (((Result)object9).getType() != null) {
                KotlinType kotlinType = ((Result)object9).getType();
                Variance variance = object5.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
                typeProjection = TypeUtilsKt.createProjection(kotlinType, variance, (TypeParameterDescriptor)object6);
            } else if (classifierDescriptor2 != null && !object5.isStarProjection()) {
                KotlinType kotlinType = object5.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                Variance variance = object5.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
                typeProjection = TypeUtilsKt.createProjection(kotlinType, variance, (TypeParameterDescriptor)object6);
            } else {
                typeProjection = classifierDescriptor2 != null ? TypeUtils.makeStarProjection((TypeParameterDescriptor)object6) : null;
            }
            object4.add(typeProjection);
        }
        object = (List)object10;
        int n3 = n2 - n;
        if (classifierDescriptor2 == null && object2 == null) {
            boolean bl5;
            object10 = (Iterable)object;
            if (!((Collection)object10).isEmpty()) {
                for (Object object122 : object10) {
                    object10 = (TypeProjection)object122;
                    if (object10 == null) continue;
                    bl5 = false;
                    break;
                }
            } else {
                bl5 = true;
            }
            if (bl5) {
                return new SimpleResult(null, n3, false);
            }
        }
        Object[] objectArray = new Annotations[3];
        Object object13 = objectArray;
        objectArray[0] = simpleType.getAnnotations();
        object11 = TypeEnhancementKt.access$getENHANCED_MUTABILITY_ANNOTATIONS$p();
        object4 = object13;
        bl2 = classifierDescriptor2 != null;
        object4[1] = bl2 ? object11 : null;
        object11 = TypeEnhancementKt.getENHANCED_NULLABILITY_ANNOTATIONS();
        object4 = object13;
        bl2 = object2 != null;
        object4[2] = bl2 ? object11 : null;
        object10 = TypeEnhancementKt.access$compositeAnnotationsOrSingle(CollectionsKt.listOfNotNull((Object[])object13));
        object11 = (Iterable)object;
        object122 = simpleType.getArguments();
        Object object14 = object8;
        object4 = TypeAttributesKt.toDefaultAttributes((Annotations)object10);
        object6 = object11.iterator();
        object5 = object122.iterator();
        object = new ArrayList(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)object11, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)object122, (int)10)));
        while (object6.hasNext() && object5.hasNext()) {
            object3 = (TypeProjection)object5.next();
            object13 = (TypeProjection)object6.next();
            Object object15 = object;
            Object object16 = object13;
            if (object13 == null) {
                object16 = object3;
            }
            ((ArrayList)object15).add(object16);
        }
        List list2 = (List)object;
        Object object17 = object2;
        object13 = KotlinTypeFactory.simpleType$default((TypeAttributes)object4, (TypeConstructor)object14, list2, object17 != null ? ((Boolean)object17).booleanValue() : simpleType.isMarkedNullable(), null, 16, null);
        object11 = javaTypeQualifiers.getDefinitelyNotNull() ? this.notNullTypeParameter((SimpleType)object13) : object13;
        boolean bl6 = object2 != null && javaTypeQualifiers.isNullabilityQualifierForWarning();
        return new SimpleResult((SimpleType)object11, n3, bl6);
    }

    static /* synthetic */ SimpleResult enhanceInflexible$default(JavaTypeEnhancement javaTypeEnhancement, SimpleType simpleType, Function1 function1, int n, TypeComponentPosition typeComponentPosition, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        return javaTypeEnhancement.enhanceInflexible(simpleType, (Function1<? super Integer, JavaTypeQualifiers>)function1, n, typeComponentPosition, bl, bl2);
    }

    private final SimpleType notNullTypeParameter(SimpleType simpleType) {
        if (this.javaResolverSettings.getCorrectNullabilityForNotNullTypeParameter()) {
            return SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull(simpleType, true);
        }
        return new NotNullTypeParameterImpl(simpleType);
    }

    private static final class Result {
        private final KotlinType type;
        private final int subtreeSize;

        public Result(KotlinType kotlinType, int n) {
            this.type = kotlinType;
            this.subtreeSize = n;
        }

        public final KotlinType getType() {
            return this.type;
        }

        public final int getSubtreeSize() {
            return this.subtreeSize;
        }
    }

    private static final class SimpleResult {
        private final SimpleType type;
        private final int subtreeSize;
        private final boolean forWarnings;

        public SimpleResult(SimpleType simpleType, int n, boolean bl) {
            this.type = simpleType;
            this.subtreeSize = n;
            this.forWarnings = bl;
        }

        public final SimpleType getType() {
            return this.type;
        }

        public final int getSubtreeSize() {
            return this.subtreeSize;
        }

        public final boolean getForWarnings() {
            return this.forWarnings;
        }
    }
}

