/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BitEncoding;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmFlags;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;

public final class JvmProtoBufUtil {
    public static final JvmProtoBufUtil INSTANCE;
    private static final ExtensionRegistryLite EXTENSION_REGISTRY;

    private JvmProtoBufUtil() {
    }

    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(String[] stringArray, String[] stringArray2) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray2, (String)"");
        byte[] byArray = BitEncoding.decodeBytes(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        return JvmProtoBufUtil.readClassDataFrom(byArray, stringArray2);
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(byte[] object, String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        object = new ByteArrayInputStream((byte[])object);
        return new Pair((Object)INSTANCE.readNameResolver((InputStream)object, stringArray), (Object)ProtoBuf.Class.parseFrom((InputStream)object, EXTENSION_REGISTRY));
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(String[] stringArray, String[] stringArray2) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray2, (String)"");
        byte[] byArray = BitEncoding.decodeBytes(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, stringArray2);
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(byte[] object, String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        object = new ByteArrayInputStream((byte[])object);
        return new Pair((Object)INSTANCE.readNameResolver((InputStream)object, stringArray), (Object)ProtoBuf.Package.parseFrom((InputStream)object, EXTENSION_REGISTRY));
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Function> readFunctionDataFrom(String[] object, String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        object = new ByteArrayInputStream(BitEncoding.decodeBytes(object));
        return new Pair((Object)INSTANCE.readNameResolver((InputStream)object, stringArray), (Object)ProtoBuf.Function.parseFrom((InputStream)object, EXTENSION_REGISTRY));
    }

    private final JvmNameResolver readNameResolver(InputStream inputStream, String[] stringArray) {
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom(inputStream, EXTENSION_REGISTRY);
        Intrinsics.checkNotNullExpressionValue((Object)stringTableTypes, (String)"");
        return new JvmNameResolver(stringTableTypes, stringArray);
    }

    public final JvmMemberSignature.Method getJvmMethodSignature(ProtoBuf.Function object, NameResolver nameResolver, TypeTable typeTable) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)object;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.methodSignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
        Object object2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        int n2 = n = object2 != null && ((JvmProtoBuf.JvmMethodSignature)object2).hasName() ? ((JvmProtoBuf.JvmMethodSignature)object2).getName() : ((ProtoBuf.Function)object).getName();
        if (object2 != null && ((JvmProtoBuf.JvmMethodSignature)object2).hasDesc()) {
            string = nameResolver.getString(((JvmProtoBuf.JvmMethodSignature)object2).getDesc());
        } else {
            ProtoBuf.ValueParameter valueParameter;
            Object object3;
            Collection collection = CollectionsKt.listOfNotNull((Object)ProtoTypeTableUtilKt.receiverType((ProtoBuf.Function)object, typeTable));
            List<ProtoBuf.ValueParameter> list = ((ProtoBuf.Function)object).getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            object2 = list;
            Object object4 = collection;
            Object object5 = object2;
            object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            object5 = object5.iterator();
            while (object5.hasNext()) {
                object3 = object5.next();
                valueParameter = (ProtoBuf.ValueParameter)object3;
                object3 = object2;
                Intrinsics.checkNotNull((Object)valueParameter);
                object3.add((ProtoBuf.Type)ProtoTypeTableUtilKt.type(valueParameter, typeTable));
            }
            object2 = CollectionsKt.plus((Collection)object4, (Iterable)((List)object2));
            object2 = object5 = (Iterable)object2;
            object5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object5, (int)10));
            object3 = object2.iterator();
            while (object3.hasNext()) {
                valueParameter = object3.next();
                object2 = (ProtoBuf.Type)((Object)valueParameter);
                object4 = object5;
                String string2 = INSTANCE.mapTypeDefault((ProtoBuf.Type)object2, nameResolver);
                if (string2 == null) {
                    return null;
                }
                object4.add(string2);
            }
            object2 = (List)object5;
            String string3 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType((ProtoBuf.Function)object, typeTable), nameResolver);
            if (string3 == null) {
                return null;
            }
            object5 = string3;
            string = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)"", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null) + (String)object5;
        }
        object = string;
        return new JvmMemberSignature.Method(nameResolver.getString(n), (String)object);
    }

    public final JvmMemberSignature.Method getJvmConstructorSignature(ProtoBuf.Constructor object, NameResolver nameResolver, TypeTable typeTable) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)object;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Constructor, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.constructorSignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
        Iterator iterator2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        String string3 = string2 = iterator2 != null && ((JvmProtoBuf.JvmMethodSignature)((Object)iterator2)).hasName() ? nameResolver.getString(((JvmProtoBuf.JvmMethodSignature)((Object)iterator2)).getName()) : "<init>";
        if (iterator2 != null && ((JvmProtoBuf.JvmMethodSignature)((Object)iterator2)).hasDesc()) {
            string = nameResolver.getString(((JvmProtoBuf.JvmMethodSignature)((Object)iterator2)).getDesc());
        } else {
            List<ProtoBuf.ValueParameter> list = ((ProtoBuf.Constructor)object).getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            object = list;
            iterator2 = object;
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object object2 = iterator2.next();
                object2 = (ProtoBuf.ValueParameter)object2;
                Object object3 = object;
                Intrinsics.checkNotNull(object2);
                String string4 = INSTANCE.mapTypeDefault(ProtoTypeTableUtilKt.type(object2, typeTable), nameResolver);
                if (string4 == null) {
                    return null;
                }
                object3.add(string4);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)object), (CharSequence)"", (CharSequence)"(", (CharSequence)")V", (int)0, null, null, (int)56, null);
        }
        object = string;
        return new JvmMemberSignature.Method(string2, (String)object);
    }

    public final JvmMemberSignature.Field getJvmFieldSignature(ProtoBuf.Property object, NameResolver nameResolver, TypeTable typeTable, boolean bl) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)object;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
        JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (jvmPropertySignature == null) {
            return null;
        }
        GeneratedMessageLite generatedMessageLite = jvmPropertySignature;
        generatedMessageLite = jvmPropertySignature.hasField() ? ((JvmProtoBuf.JvmPropertySignature)generatedMessageLite).getField() : null;
        if (generatedMessageLite == null && bl) {
            return null;
        }
        int n2 = n = generatedMessageLite != null && ((JvmProtoBuf.JvmFieldSignature)generatedMessageLite).hasName() ? ((JvmProtoBuf.JvmFieldSignature)generatedMessageLite).getName() : ((ProtoBuf.Property)object).getName();
        if (generatedMessageLite != null && ((JvmProtoBuf.JvmFieldSignature)generatedMessageLite).hasDesc()) {
            string = nameResolver.getString(((JvmProtoBuf.JvmFieldSignature)generatedMessageLite).getDesc());
        } else {
            string = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType((ProtoBuf.Property)object, typeTable), nameResolver);
            if (string == null) {
                return null;
            }
        }
        object = string;
        return new JvmMemberSignature.Field(nameResolver.getString(n), (String)object);
    }

    public static /* synthetic */ JvmMemberSignature.Field getJvmFieldSignature$default(JvmProtoBufUtil jvmProtoBufUtil, ProtoBuf.Property property, NameResolver nameResolver, TypeTable typeTable, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return jvmProtoBufUtil.getJvmFieldSignature(property, nameResolver, typeTable, bl);
    }

    private final String mapTypeDefault(ProtoBuf.Type type, NameResolver nameResolver) {
        if (type.hasClassName()) {
            return ClassMapperLite.mapClass(nameResolver.getQualifiedClassName(type.getClassName()));
        }
        return null;
    }

    @JvmStatic
    public static final boolean isMovedFromInterfaceCompanion(ProtoBuf.Property property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        Flags.BooleanFlagField booleanFlagField = JvmFlags.INSTANCE.getIS_MOVED_FROM_INTERFACE_COMPANION();
        Integer n = property.getExtension(JvmProtoBuf.flags);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"");
        Boolean bl = booleanFlagField.get(((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
        return bl;
    }

    static {
        ExtensionRegistryLite extensionRegistryLite;
        INSTANCE = new JvmProtoBufUtil();
        ExtensionRegistryLite extensionRegistryLite2 = extensionRegistryLite = ExtensionRegistryLite.newInstance();
        JvmProtoBuf.registerAllExtensions(extensionRegistryLite);
        ExtensionRegistryLite extensionRegistryLite3 = extensionRegistryLite;
        Intrinsics.checkNotNullExpressionValue((Object)extensionRegistryLite3, (String)"");
        EXTENSION_REGISTRY = extensionRegistryLite3;
    }
}

