/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;

public final class ClassId {
    public static final Companion Companion = new Companion(null);
    private final FqName packageFqName;
    private final FqName relativeClassName;
    private final boolean isLocal;

    public ClassId(FqName fqName, FqName fqName2, boolean bl) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        this.packageFqName = fqName;
        this.relativeClassName = fqName2;
        this.isLocal = bl;
        boolean bl3 = bl2 = !this.relativeClassName.isRoot();
        if (_Assertions.ENABLED && !bl2) {
            String string = "Class name must not be root: " + this.packageFqName + (this.isLocal ? " (local)" : "");
            throw new AssertionError((Object)string);
        }
    }

    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    public final FqName getRelativeClassName() {
        return this.relativeClassName;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    public ClassId(FqName fqName, Name name) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        this(fqName, FqName.Companion.topLevel(name), false);
    }

    public final Name getShortClassName() {
        return this.relativeClassName.shortName();
    }

    public final ClassId getOuterClassId() {
        FqName fqName = this.relativeClassName.parent();
        boolean bl = !fqName.isRoot();
        if (bl) {
            return new ClassId(this.packageFqName, fqName, this.isLocal);
        }
        return null;
    }

    public final boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    public final ClassId createNestedClassId(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return new ClassId(this.packageFqName, this.relativeClassName.child(name), this.isLocal);
    }

    public final FqName asSingleFqName() {
        if (this.packageFqName.isRoot()) {
            return this.relativeClassName;
        }
        return new FqName(this.packageFqName.asString() + '.' + this.relativeClassName.asString());
    }

    public final String asString() {
        StringBuilder stringBuilder;
        if (this.packageFqName.isRoot()) {
            return ClassId.asString$escapeSlashes(this.relativeClassName);
        }
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append(StringsKt.replace$default((String)this.packageFqName.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null));
        stringBuilder2.append("/");
        stringBuilder2.append(ClassId.asString$escapeSlashes(this.relativeClassName));
        return stringBuilder.toString();
    }

    public final String toString() {
        if (this.packageFqName.isRoot()) {
            return "/" + this.asString();
        }
        return this.asString();
    }

    public final int hashCode() {
        int n = this.packageFqName.hashCode();
        n = n * 31 + this.relativeClassName.hashCode();
        n = n * 31 + Boolean.hashCode(this.isLocal);
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassId)) {
            return false;
        }
        object = (ClassId)object;
        if (!Intrinsics.areEqual((Object)this.packageFqName, (Object)((ClassId)object).packageFqName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.relativeClassName, (Object)((ClassId)object).relativeClassName)) {
            return false;
        }
        return this.isLocal == ((ClassId)object).isLocal;
    }

    private static final String asString$escapeSlashes(FqName object) {
        if (StringsKt.contains$default((CharSequence)((CharSequence)(object = ((FqName)object).asString())), (char)'/', (boolean)false, (int)2, null)) {
            return "`" + (String)object + '`';
        }
        return object;
    }

    @JvmStatic
    public static final ClassId topLevel(FqName fqName) {
        return Companion.topLevel(fqName);
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final ClassId topLevel(FqName fqName) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
            return new ClassId(fqName.parent(), fqName.shortName());
        }

        @JvmStatic
        public final ClassId fromString(String string, boolean bl) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            int n = StringsKt.indexOf$default((CharSequence)string, (char)'`', (int)0, (boolean)false, (int)6, null);
            n = StringsKt.lastIndexOf$default((CharSequence)string, (String)"/", (int)(n == -1 ? string.length() : n), (boolean)false, (int)4, null);
            if (n == -1) {
                string2 = "";
                string = StringsKt.replace$default((String)string, (String)"`", (String)"", (boolean)false, (int)4, null);
            } else {
                String string3 = string.substring(0, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                string2 = StringsKt.replace$default((String)string3, (char)'/', (char)'.', (boolean)false, (int)4, null);
                String string4 = string.substring(n + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                string = StringsKt.replace$default((String)string4, (String)"`", (String)"", (boolean)false, (int)4, null);
            }
            return new ClassId(new FqName(string2), new FqName(string), bl);
        }

        public static /* synthetic */ ClassId fromString$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.fromString(string, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

