/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.reflect.jvm.internal.impl.protobuf.FieldSet;

class SmallSortedMap<K extends Comparable<K>, V>
extends AbstractMap<K, V> {
    private final int maxArraySize;
    private List<Entry> entryList;
    private Map<K, V> overflowEntries;
    private boolean isImmutable;
    private volatile EntrySet lazyEntrySet;

    static <FieldDescriptorType extends FieldSet.FieldDescriptorLite<FieldDescriptorType>> SmallSortedMap<FieldDescriptorType, Object> newFieldMap(int n) {
        return new SmallSortedMap<FieldDescriptorType, Object>(n){

            @Override
            public final void makeImmutable() {
                if (!this.isImmutable()) {
                    List list;
                    for (int i = 0; i < this.getNumArrayEntries(); ++i) {
                        Map.Entry entry = this.getArrayEntryAt(i);
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        list = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(list));
                    }
                    for (Map.Entry entry : this.getOverflowEntries()) {
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        list = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(list));
                    }
                }
                super.makeImmutable();
            }
        };
    }

    private SmallSortedMap(int n) {
        this.maxArraySize = n;
        this.entryList = Collections.emptyList();
        this.overflowEntries = Collections.emptyMap();
    }

    public void makeImmutable() {
        if (!this.isImmutable) {
            this.overflowEntries = this.overflowEntries.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.overflowEntries);
            this.isImmutable = true;
        }
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public int getNumArrayEntries() {
        return this.entryList.size();
    }

    public Map.Entry<K, V> getArrayEntryAt(int n) {
        return this.entryList.get(n);
    }

    public Iterable<Map.Entry<K, V>> getOverflowEntries() {
        if (this.overflowEntries.isEmpty()) {
            return EmptySet.iterable();
        }
        return this.overflowEntries.entrySet();
    }

    @Override
    public int size() {
        return this.entryList.size() + this.overflowEntries.size();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.binarySearchInArray(object = (Comparable)object) >= 0 || this.overflowEntries.containsKey(object);
    }

    @Override
    public V get(Object object) {
        int n = this.binarySearchInArray(object = (Comparable)object);
        if (n >= 0) {
            return this.entryList.get(n).getValue();
        }
        return this.overflowEntries.get(object);
    }

    @Override
    public V put(K k, V v) {
        this.checkMutable();
        int n = this.binarySearchInArray(k);
        if (n >= 0) {
            return this.entryList.get(n).setValue(v);
        }
        this.ensureEntryArrayMutable();
        n = -(n + 1);
        if (n >= this.maxArraySize) {
            return this.getOverflowEntriesMutable().put(k, v);
        }
        if (this.entryList.size() == this.maxArraySize) {
            Entry entry = this.entryList.remove(this.maxArraySize - 1);
            this.getOverflowEntriesMutable().put(entry.getKey(), entry.getValue());
        }
        this.entryList.add(n, new Entry(this, k, v));
        return null;
    }

    @Override
    public void clear() {
        this.checkMutable();
        if (!this.entryList.isEmpty()) {
            this.entryList.clear();
        }
        if (!this.overflowEntries.isEmpty()) {
            this.overflowEntries.clear();
        }
    }

    @Override
    public V remove(Object object) {
        this.checkMutable();
        object = (Comparable)object;
        int n = this.binarySearchInArray(object);
        if (n >= 0) {
            return this.removeArrayEntryAt(n);
        }
        if (this.overflowEntries.isEmpty()) {
            return null;
        }
        return this.overflowEntries.remove(object);
    }

    private V removeArrayEntryAt(int n) {
        this.checkMutable();
        Object v = this.entryList.remove(n).getValue();
        if (!this.overflowEntries.isEmpty()) {
            Iterator<Map.Entry<K, V>> iterator2 = this.getOverflowEntriesMutable().entrySet().iterator();
            this.entryList.add(new Entry(this, iterator2.next()));
            iterator2.remove();
        }
        return v;
    }

    private int binarySearchInArray(K k) {
        int n;
        int n2 = 0;
        int n3 = this.entryList.size() - 1;
        if (n3 >= 0) {
            n = k.compareTo((Object)this.entryList.get(n3).getKey());
            if (n > 0) {
                return -(n3 + 2);
            }
            if (n == 0) {
                return n3;
            }
        }
        while (n2 <= n3) {
            n = (n2 + n3) / 2;
            int n4 = k.compareTo((Object)this.entryList.get(n).getKey());
            if (n4 < 0) {
                n3 = n - 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n + 1;
                continue;
            }
            return n;
        }
        return -(n2 + 1);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.lazyEntrySet == null) {
            this.lazyEntrySet = new EntrySet();
        }
        return this.lazyEntrySet;
    }

    private void checkMutable() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException();
        }
    }

    private SortedMap<K, V> getOverflowEntriesMutable() {
        this.checkMutable();
        if (this.overflowEntries.isEmpty() && !(this.overflowEntries instanceof TreeMap)) {
            this.overflowEntries = new TreeMap();
        }
        return (SortedMap)this.overflowEntries;
    }

    private void ensureEntryArrayMutable() {
        this.checkMutable();
        if (this.entryList.isEmpty() && !(this.entryList instanceof ArrayList)) {
            this.entryList = new ArrayList<Entry>(this.maxArraySize);
        }
    }

    private static class EmptySet {
        private static final Iterator<Object> ITERATOR = new Iterator<Object>(){

            @Override
            public final boolean hasNext() {
                return false;
            }

            @Override
            public final Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
        private static final Iterable<Object> ITERABLE = new Iterable<Object>(){

            @Override
            public final Iterator<Object> iterator() {
                return ITERATOR;
            }
        };

        static <T> Iterable<T> iterable() {
            return ITERABLE;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int pos = -1;
        private boolean nextCalledBeforeRemove;
        private Iterator<Map.Entry<K, V>> lazyOverflowIterator;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < SmallSortedMap.this.entryList.size() || this.getOverflowIterator().hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.nextCalledBeforeRemove = true;
            if (++this.pos < SmallSortedMap.this.entryList.size()) {
                return (Map.Entry)SmallSortedMap.this.entryList.get(this.pos);
            }
            return this.getOverflowIterator().next();
        }

        @Override
        public void remove() {
            if (!this.nextCalledBeforeRemove) {
                throw new IllegalStateException("remove() was called before next()");
            }
            this.nextCalledBeforeRemove = false;
            SmallSortedMap.this.checkMutable();
            if (this.pos < SmallSortedMap.this.entryList.size()) {
                SmallSortedMap.this.removeArrayEntryAt(this.pos--);
                return;
            }
            this.getOverflowIterator().remove();
        }

        private Iterator<Map.Entry<K, V>> getOverflowIterator() {
            if (this.lazyOverflowIterator == null) {
                this.lazyOverflowIterator = SmallSortedMap.this.overflowEntries.entrySet().iterator();
            }
            return this.lazyOverflowIterator;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SmallSortedMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            object = (Map.Entry)object;
            Object v = SmallSortedMap.this.get(object.getKey());
            return v == (object = object.getValue()) || v != null && v.equals(object);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            if (!this.contains(entry)) {
                SmallSortedMap.this.put((Comparable)entry.getKey(), entry.getValue());
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object = (Map.Entry)object)) {
                SmallSortedMap.this.remove(object.getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SmallSortedMap.this.clear();
        }
    }

    private static class Entry
    implements Comparable<Entry>,
    Map.Entry<K, V> {
        private final K key;
        private V value;
        final /* synthetic */ SmallSortedMap this$0;

        Entry(SmallSortedMap smallSortedMap, Map.Entry<K, V> entry) {
            this(smallSortedMap, (Comparable)entry.getKey(), entry.getValue());
        }

        Entry(K k, V v) {
            this.this$0 = var1_1;
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.getKey().compareTo(entry.getKey());
        }

        @Override
        public V setValue(V v) {
            this.this$0.checkMutable();
            Object v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            object = (Map.Entry)object;
            Entry entry = this;
            if (entry.equals(entry.key, object.getKey())) {
                Entry entry2 = this;
                if (entry2.equals(entry2.value, object.getValue())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.key));
            String string2 = String.valueOf(String.valueOf(this.value));
            return new StringBuilder(1 + string.length() + string2.length()).append(string).append("=").append(string2).toString();
        }

        private boolean equals(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return object.equals(object2);
        }
    }
}

