/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;

public final class ProtoBasedClassDataFinder
implements ClassDataFinder {
    private final NameResolver nameResolver;
    private final BinaryVersion metadataVersion;
    private final Function1<ClassId, SourceElement> classSource;
    private final Map<ClassId, ProtoBuf.Class> classIdToProto;

    public ProtoBasedClassDataFinder(ProtoBuf.PackageFragment iterator2, NameResolver nameResolver, BinaryVersion binaryVersion, Function1<? super ClassId, ? extends SourceElement> object) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)binaryVersion, (String)"");
        Intrinsics.checkNotNullParameter(object, (String)"");
        this.nameResolver = nameResolver;
        this.metadataVersion = binaryVersion;
        this.classSource = object;
        List<ProtoBuf.Class> list = ((ProtoBuf.PackageFragment)((Object)iterator2)).getClass_List();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        iterator2 = list;
        ProtoBasedClassDataFinder protoBasedClassDataFinder = this;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), (int)10)), (int)16);
        Map map = new LinkedHashMap(n);
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            binaryVersion = iterator2.next();
            object = (ProtoBuf.Class)((Object)binaryVersion);
            Map map2 = map;
            map2.put(NameResolverUtilKt.getClassId(this.nameResolver, ((ProtoBuf.Class)object).getFqName()), binaryVersion);
        }
        protoBasedClassDataFinder.classIdToProto = map;
    }

    public final Collection<ClassId> getAllClassIds() {
        return this.classIdToProto.keySet();
    }

    @Override
    public final ClassData findClassData(ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        ProtoBuf.Class clazz = this.classIdToProto.get(classId);
        if (clazz == null) {
            return null;
        }
        ProtoBuf.Class clazz2 = clazz;
        return new ClassData(this.nameResolver, clazz2, this.metadataVersion, (SourceElement)this.classSource.invoke((Object)classId));
    }
}

