/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.AnnotationsTypeAttributeKt;
import kotlin.reflect.jvm.internal.impl.types.DynamicType;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansion;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansionReportStrategy;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class TypeAliasExpander {
    public static final Companion Companion = new Companion(null);
    private final TypeAliasExpansionReportStrategy reportStrategy;
    private final boolean shouldCheckBounds;
    private static final TypeAliasExpander NON_REPORTING = new TypeAliasExpander(TypeAliasExpansionReportStrategy.DO_NOTHING.INSTANCE, false);

    public TypeAliasExpander(TypeAliasExpansionReportStrategy typeAliasExpansionReportStrategy, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)typeAliasExpansionReportStrategy, (String)"");
        this.reportStrategy = typeAliasExpansionReportStrategy;
        this.shouldCheckBounds = bl;
    }

    public final SimpleType expand(TypeAliasExpansion typeAliasExpansion, TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAliasExpansion, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return this.expandRecursively(typeAliasExpansion, typeAttributes, false, 0, true);
    }

    private final SimpleType expandRecursively(TypeAliasExpansion object, TypeAttributes typeAttributes, boolean bl, int n, boolean bl2) {
        boolean bl3;
        Object object2 = new TypeProjectionImpl(Variance.INVARIANT, ((TypeAliasExpansion)object).getDescriptor().getUnderlyingType());
        Object object3 = this.expandTypeProjection((TypeProjection)object2, (TypeAliasExpansion)object, null, n);
        KotlinType kotlinType = object3.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        object2 = TypeSubstitutionKt.asSimpleType(kotlinType);
        if (KotlinTypeKt.isError((KotlinType)object2)) {
            return object2;
        }
        boolean bl4 = bl3 = object3.getProjectionKind() == Variance.INVARIANT;
        if (_Assertions.ENABLED && !bl3) {
            object = "Type alias expansion: result for " + ((TypeAliasExpansion)object).getDescriptor() + " is " + (Object)((Object)object3.getProjectionKind()) + ", should be invariant";
            throw new AssertionError(object);
        }
        this.checkRepeatedAnnotations(((KotlinType)object2).getAnnotations(), AnnotationsTypeAttributeKt.getAnnotations(typeAttributes));
        object3 = this.combineAttributes((SimpleType)object2, typeAttributes);
        SimpleType simpleType = TypeUtils.makeNullableIfNeeded((SimpleType)object3, bl);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
        SimpleType simpleType2 = simpleType;
        if (bl2) {
            return SpecialTypesKt.withAbbreviation(simpleType2, this.createAbbreviation((TypeAliasExpansion)object, typeAttributes, bl));
        }
        return simpleType2;
    }

    private final SimpleType createAbbreviation(TypeAliasExpansion typeAliasExpansion, TypeAttributes typeAttributes, boolean bl) {
        TypeConstructor typeConstructor2 = typeAliasExpansion.getDescriptor().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(typeAttributes, typeConstructor2, typeAliasExpansion.getArguments(), bl, MemberScope.Empty.INSTANCE);
    }

    private final TypeProjection expandTypeProjection(TypeProjection object, TypeAliasExpansion object2, TypeParameterDescriptor typeParameterDescriptor, int n) {
        Object object3;
        Object object4;
        Object object5;
        TypeAliasExpander.Companion.assertRecursionDepth(n, ((TypeAliasExpansion)object2).getDescriptor());
        if (object.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor2);
            TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"");
            return typeProjection;
        }
        KotlinType kotlinType = object.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = kotlinType;
        TypeProjection typeProjection = ((TypeAliasExpansion)object2).getReplacement(kotlinType2.getConstructor());
        if (typeProjection == null) {
            return this.expandNonArgumentTypeProjection((TypeProjection)object, (TypeAliasExpansion)object2, n);
        }
        Object object6 = typeProjection;
        if (typeProjection.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor3);
            TypeProjection typeProjection2 = TypeUtils.makeStarProjection(typeParameterDescriptor3);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection2, (String)"");
            return typeProjection2;
        }
        UnwrappedType unwrappedType = object6.getType().unwrap();
        TypeAliasExpander typeAliasExpander = this;
        Variance variance = object6.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
        object6 = variance;
        Variance variance2 = object.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance2), (String)"");
        object = variance2;
        if (variance2 == object6) {
            object5 = object6;
        } else if (object == Variance.INVARIANT) {
            object5 = object6;
        } else if (object6 == Variance.INVARIANT) {
            object5 = object;
        } else {
            typeAliasExpander.reportStrategy.conflictingProjection(((TypeAliasExpansion)object2).getDescriptor(), typeParameterDescriptor, unwrappedType);
            object5 = object = object6;
        }
        if ((object4 = typeParameterDescriptor) == null || (object4 = object4.getVariance()) == null) {
            object4 = object6 = Variance.INVARIANT;
        }
        if (object4 == object) {
            object3 = object;
        } else if (object6 == Variance.INVARIANT) {
            object3 = object;
        } else if (object == Variance.INVARIANT) {
            object3 = Variance.INVARIANT;
        } else {
            typeAliasExpander.reportStrategy.conflictingProjection(((TypeAliasExpansion)object2).getDescriptor(), typeParameterDescriptor, unwrappedType);
            object3 = object;
        }
        object = object3;
        this.checkRepeatedAnnotations(kotlinType2.getAnnotations(), unwrappedType.getAnnotations());
        object2 = unwrappedType instanceof DynamicType ? (UnwrappedType)this.combineAttributes((DynamicType)unwrappedType, kotlinType2.getAttributes()) : (UnwrappedType)this.combineNullabilityAndAnnotations(TypeSubstitutionKt.asSimpleType(unwrappedType), kotlinType2);
        return new TypeProjectionImpl((Variance)((Object)object), (KotlinType)object2);
    }

    private final DynamicType combineAttributes(DynamicType dynamicType, TypeAttributes typeAttributes) {
        return dynamicType.replaceAttributes(this.createdCombinedAttributes(dynamicType, typeAttributes));
    }

    private final SimpleType combineAttributes(SimpleType simpleType, TypeAttributes typeAttributes) {
        if (KotlinTypeKt.isError(simpleType)) {
            return simpleType;
        }
        return TypeSubstitutionKt.replace$default(simpleType, null, this.createdCombinedAttributes(simpleType, typeAttributes), 1, null);
    }

    private final TypeAttributes createdCombinedAttributes(KotlinType kotlinType, TypeAttributes typeAttributes) {
        if (KotlinTypeKt.isError(kotlinType)) {
            return kotlinType.getAttributes();
        }
        return typeAttributes.add(kotlinType.getAttributes());
    }

    private final void checkRepeatedAnnotations(Annotations object, Annotations annotations) {
        Object object2 = (Iterable)object;
        Object object32 = new HashSet();
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = object.next();
            object2 = (AnnotationDescriptor)object2;
            Collection collection = object32;
            collection.add(object2.getFqName());
        }
        object = (HashSet)object32;
        for (Object object32 : annotations) {
            if (!((HashSet)object).contains(object32.getFqName())) continue;
            this.reportStrategy.repeatedAnnotation((AnnotationDescriptor)object32);
        }
    }

    private final SimpleType combineNullability(SimpleType simpleType, KotlinType kotlinType) {
        SimpleType simpleType2 = TypeUtils.makeNullableIfNeeded(simpleType, kotlinType.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"");
        return simpleType2;
    }

    private final SimpleType combineNullabilityAndAnnotations(SimpleType simpleType, KotlinType kotlinType) {
        TypeAliasExpander typeAliasExpander = this;
        return typeAliasExpander.combineAttributes(typeAliasExpander.combineNullability(simpleType, kotlinType), kotlinType.getAttributes());
    }

    private final TypeProjection expandNonArgumentTypeProjection(TypeProjection typeProjection, TypeAliasExpansion typeAliasExpansion, int n) {
        boolean bl;
        UnwrappedType unwrappedType = typeProjection.getType().unwrap();
        if (DynamicTypesKt.isDynamic(unwrappedType)) {
            return typeProjection;
        }
        if (KotlinTypeKt.isError(unwrappedType = TypeSubstitutionKt.asSimpleType(unwrappedType)) || !TypeUtilsKt.requiresTypeAliasExpansion(unwrappedType)) {
            return typeProjection;
        }
        Object object = unwrappedType.getConstructor();
        ClassifierDescriptor classifierDescriptor = object.getDeclarationDescriptor();
        boolean bl2 = bl = object.getParameters().size() == unwrappedType.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            object = "Unexpected malformed type: " + unwrappedType;
            throw new AssertionError(object);
        }
        Object object2 = classifierDescriptor;
        if (object2 instanceof TypeParameterDescriptor) {
            return typeProjection;
        }
        if (object2 instanceof TypeAliasDescriptor) {
            if (typeAliasExpansion.isRecursion((TypeAliasDescriptor)classifierDescriptor)) {
                this.reportStrategy.recursiveTypeAlias((TypeAliasDescriptor)classifierDescriptor);
                String[] stringArray = new String[1];
                object = stringArray;
                stringArray[0] = ((TypeAliasDescriptor)classifierDescriptor).getName().toString();
                return new TypeProjectionImpl(Variance.INVARIANT, ErrorUtils.createErrorType(ErrorTypeKind.RECURSIVE_TYPE_ALIAS, (String[])object));
            }
            Object object3 = object2 = (Iterable)unwrappedType.getArguments();
            object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            int n2 = 0;
            object3 = object3.iterator();
            while (object3.hasNext()) {
                int n3;
                Object object4 = object3.next();
                if ((n3 = n2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object4 = (TypeProjection)object4;
                Object object5 = object2;
                object5.add(this.expandTypeProjection((TypeProjection)object4, typeAliasExpansion, object.getParameters().get(n3), n + 1));
            }
            object = (List)object2;
            object2 = TypeAliasExpansion.Companion.create(typeAliasExpansion, (TypeAliasDescriptor)classifierDescriptor, (List<? extends TypeProjection>)object);
            object = this.expandRecursively((TypeAliasExpansion)object2, unwrappedType.getAttributes(), unwrappedType.isMarkedNullable(), n + 1, false);
            object3 = this.substituteArguments((SimpleType)unwrappedType, typeAliasExpansion, n);
            object2 = DynamicTypesKt.isDynamic((KotlinType)object) ? object : SpecialTypesKt.withAbbreviation((SimpleType)object, (SimpleType)object3);
            return new TypeProjectionImpl(typeProjection.getProjectionKind(), (KotlinType)object2);
        }
        object = this.substituteArguments((SimpleType)unwrappedType, typeAliasExpansion, n);
        this.checkTypeArgumentsSubstitution(unwrappedType, (KotlinType)object);
        return new TypeProjectionImpl(typeProjection.getProjectionKind(), (KotlinType)object);
    }

    private final SimpleType substituteArguments(SimpleType simpleType, TypeAliasExpansion object, int n) {
        TypeConstructor typeConstructor2 = simpleType.getConstructor();
        Iterable iterable = simpleType.getArguments();
        Object object2 = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        int n2 = 0;
        object2 = object2.iterator();
        while (object2.hasNext()) {
            int n3;
            Object object3 = object2.next();
            if ((n3 = n2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object3 = (TypeProjection)object3;
            Iterable iterable2 = iterable;
            TypeProjection typeProjection = this.expandTypeProjection((TypeProjection)object3, (TypeAliasExpansion)object, typeConstructor2.getParameters().get(n3), n + 1);
            iterable2.add(typeProjection.isStarProjection() ? typeProjection : (TypeProjection)new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.makeNullableIfNeeded(typeProjection.getType(), object3.getType().isMarkedNullable())));
        }
        object = (List)iterable;
        return TypeSubstitutionKt.replace$default(simpleType, (List)object, null, 2, null);
    }

    private final void checkTypeArgumentsSubstitution(KotlinType kotlinType, KotlinType iterator2) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create((KotlinType)((Object)iterator2));
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        iterator2 = ((KotlinType)((Object)iterator2)).getArguments();
        int n = 0;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            int n2;
            Object object = iterator2.next();
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            if ((object = (TypeProjection)object).isStarProjection()) continue;
            KotlinType kotlinType2 = object.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
            if (TypeUtilsKt.containsTypeAliasParameters(kotlinType2)) continue;
            TypeProjection typeProjection = kotlinType.getArguments().get(n2);
            TypeParameterDescriptor typeParameterDescriptor = kotlinType.getConstructor().getParameters().get(n2);
            if (!this.shouldCheckBounds) continue;
            KotlinType kotlinType3 = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
            KotlinType kotlinType4 = object.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"");
            Intrinsics.checkNotNull((Object)typeParameterDescriptor);
            this.reportStrategy.boundsViolationInSubstitution(typeSubstitutor3, kotlinType3, kotlinType4, typeParameterDescriptor);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        private final void assertRecursionDepth(int n, TypeAliasDescriptor typeAliasDescriptor) {
            if (n > 100) {
                throw new AssertionError((Object)("Too deep recursion while expanding type alias " + typeAliasDescriptor.getName()));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

