/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.HostsFileEntriesProvider;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class DefaultHostsFileEntriesResolver
implements HostsFileEntriesResolver {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHostsFileEntriesResolver.class);
    private static final long DEFAULT_REFRESH_INTERVAL = SystemPropertyUtil.getLong((String)"io.netty.hostsFileRefreshInterval", (long)0L);
    private final long refreshInterval;
    private final AtomicLong lastRefresh = new AtomicLong(System.nanoTime());
    private final HostsFileEntriesProvider.Parser hostsFileParser;
    private volatile Map<String, List<InetAddress>> inet4Entries;
    private volatile Map<String, List<InetAddress>> inet6Entries;

    public DefaultHostsFileEntriesResolver() {
        this(HostsFileEntriesProvider.parser(), DEFAULT_REFRESH_INTERVAL);
    }

    DefaultHostsFileEntriesResolver(HostsFileEntriesProvider.Parser object, long l) {
        this.hostsFileParser = object;
        this.refreshInterval = ObjectUtil.checkPositiveOrZero((long)l, (String)"refreshInterval");
        object = DefaultHostsFileEntriesResolver.parseEntries((HostsFileEntriesProvider.Parser)object);
        this.inet4Entries = ((HostsFileEntriesProvider)object).ipv4Entries();
        this.inet6Entries = ((HostsFileEntriesProvider)object).ipv6Entries();
    }

    @Override
    public final InetAddress address(String string, ResolvedAddressTypes resolvedAddressTypes) {
        return DefaultHostsFileEntriesResolver.firstAddress(this.addresses(string, resolvedAddressTypes));
    }

    public final List<InetAddress> addresses(String string, ResolvedAddressTypes object) {
        string = this.normalize(string);
        this.ensureHostsFileEntriesAreFresh();
        switch (object) {
            case IPV4_ONLY: {
                return this.inet4Entries.get(string);
            }
            case IPV6_ONLY: {
                return this.inet6Entries.get(string);
            }
            case IPV4_PREFERRED: {
                object = this.inet4Entries.get(string);
                if (object != null) {
                    return DefaultHostsFileEntriesResolver.allAddresses((List<InetAddress>)object, this.inet6Entries.get(string));
                }
                return this.inet6Entries.get(string);
            }
            case IPV6_PREFERRED: {
                object = this.inet6Entries.get(string);
                if (object != null) {
                    return DefaultHostsFileEntriesResolver.allAddresses((List<InetAddress>)object, this.inet4Entries.get(string));
                }
                return this.inet4Entries.get(string);
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)object);
    }

    private void ensureHostsFileEntriesAreFresh() {
        long l = this.refreshInterval;
        if (l == 0L) {
            return;
        }
        long l2 = this.lastRefresh.get();
        long l3 = System.nanoTime();
        if (l3 - l2 > l && this.lastRefresh.compareAndSet(l2, l3)) {
            HostsFileEntriesProvider hostsFileEntriesProvider = DefaultHostsFileEntriesResolver.parseEntries(this.hostsFileParser);
            this.inet4Entries = hostsFileEntriesProvider.ipv4Entries();
            this.inet6Entries = hostsFileEntriesProvider.ipv6Entries();
        }
    }

    final String normalize(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    private static List<InetAddress> allAddresses(List<InetAddress> list, List<InetAddress> list2) {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(list.size() + (list2 == null ? 0 : list2.size()));
        arrayList.addAll(list);
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private static InetAddress firstAddress(List<InetAddress> list) {
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private static HostsFileEntriesProvider parseEntries(HostsFileEntriesProvider.Parser parser) {
        if (PlatformDependent.isWindows()) {
            return parser.parseSilently(Charset.defaultCharset(), CharsetUtil.UTF_16, CharsetUtil.UTF_8);
        }
        return parser.parseSilently();
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.hostsFileRefreshInterval: {}", (Object)DEFAULT_REFRESH_INTERVAL);
        }
    }
}

