/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.AbstractAddressResolver;
import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class InetSocketAddressResolver
extends AbstractAddressResolver<InetSocketAddress> {
    final NameResolver<InetAddress> nameResolver;

    public InetSocketAddressResolver(EventExecutor eventExecutor, NameResolver<InetAddress> nameResolver) {
        super(eventExecutor, InetSocketAddress.class);
        this.nameResolver = nameResolver;
    }

    @Override
    protected boolean doIsResolved(InetSocketAddress inetSocketAddress) {
        return !inetSocketAddress.isUnresolved();
    }

    @Override
    protected void doResolve(final InetSocketAddress inetSocketAddress, final Promise<InetSocketAddress> promise) {
        this.nameResolver.resolve(inetSocketAddress.getHostName()).addListener((GenericFutureListener)new FutureListener<InetAddress>(){

            public void operationComplete(Future<InetAddress> future) {
                if (future.isSuccess()) {
                    promise.setSuccess((Object)new InetSocketAddress((InetAddress)future.getNow(), inetSocketAddress.getPort()));
                    return;
                }
                promise.setFailure(future.cause());
            }
        });
    }

    @Override
    protected void doResolveAll(final InetSocketAddress inetSocketAddress, final Promise<List<InetSocketAddress>> promise) {
        this.nameResolver.resolveAll(inetSocketAddress.getHostName()).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(){

            public void operationComplete(Future<List<InetAddress>> object) {
                if (object.isSuccess()) {
                    object = (List)object.getNow();
                    ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(object.size());
                    object = object.iterator();
                    while (object.hasNext()) {
                        InetAddress inetAddress = (InetAddress)object.next();
                        arrayList.add(new InetSocketAddress(inetAddress, inetSocketAddress.getPort()));
                    }
                    promise.setSuccess(arrayList);
                    return;
                }
                promise.setFailure(object.cause());
            }
        });
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

