/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.STEUtil;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;

public class PackagingDataCalculator {
    static final StackTraceElementProxy[] STEP_ARRAY_TEMPLATE = new StackTraceElementProxy[0];
    HashMap<String, ClassPackagingData> cache = new HashMap();
    private static boolean GET_CALLER_CLASS_METHOD_AVAILABLE = false;

    public void calculate(IThrowableProxy iThrowableProxy) {
        while (iThrowableProxy != null) {
            this.populateFrames(iThrowableProxy.getStackTraceElementProxyArray());
            IThrowableProxy[] iThrowableProxyArray = iThrowableProxy.getSuppressed();
            if (iThrowableProxyArray != null) {
                for (IThrowableProxy iThrowableProxy2 : iThrowableProxyArray) {
                    this.populateFrames(iThrowableProxy2.getStackTraceElementProxyArray());
                }
            }
            iThrowableProxy = iThrowableProxy.getCause();
        }
    }

    void populateFrames(StackTraceElementProxy[] stackTraceElementProxyArray) {
        StackTraceElement[] stackTraceElementArray = new Throwable("local stack reference");
        stackTraceElementArray = stackTraceElementArray.getStackTrace();
        int n = STEUtil.findNumberOfCommonFrames(stackTraceElementArray, stackTraceElementProxyArray);
        int cfr_ignored_0 = stackTraceElementArray.length;
        int n2 = stackTraceElementProxyArray.length - n;
        for (int i = 0; i < n; ++i) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[n2 + i];
            stackTraceElementProxy.ste.getClassName();
            ClassPackagingData classPackagingData = this.computeBySTEP(stackTraceElementProxy, null);
            stackTraceElementProxy.setClassPackagingData(classPackagingData);
        }
        this.populateUncommonFrames(n, stackTraceElementProxyArray, null);
    }

    void populateUncommonFrames(int n, StackTraceElementProxy[] stackTraceElementProxyArray, ClassLoader classLoader) {
        n = stackTraceElementProxyArray.length - n;
        for (int i = 0; i < n; ++i) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i];
            ClassPackagingData classPackagingData = this.computeBySTEP(stackTraceElementProxy, classLoader);
            stackTraceElementProxy.setClassPackagingData(classPackagingData);
        }
    }

    private ClassPackagingData calculateByExactType(Class<?> object) {
        String string = ((Class)object).getName();
        Object object2 = this.cache.get(string);
        if (object2 != null) {
            return object2;
        }
        object2 = this.getImplementationVersion((Class<?>)object);
        object = this.getCodeLocation((Class<?>)object);
        object2 = new ClassPackagingData((String)object, (String)object2);
        this.cache.put(string, (ClassPackagingData)object2);
        return object2;
    }

    private ClassPackagingData computeBySTEP(StackTraceElementProxy object, ClassLoader object2) {
        object = ((StackTraceElementProxy)object).ste.getClassName();
        Object object3 = this.cache.get(object);
        if (object3 != null) {
            return object3;
        }
        object2 = this.bestEffortLoadClass((ClassLoader)object2, (String)object);
        object3 = this.getImplementationVersion((Class<?>)object2);
        object2 = this.getCodeLocation((Class<?>)object2);
        object3 = new ClassPackagingData((String)object2, (String)object3, false);
        this.cache.put((String)object, (ClassPackagingData)object3);
        return object3;
    }

    String getImplementationVersion(Class<?> object) {
        if (object == null) {
            return "na";
        }
        if ((object = ((Class)object).getPackage()) != null) {
            if ((object = ((Package)object).getImplementationVersion()) == null) {
                return "na";
            }
            return object;
        }
        return "na";
    }

    String getCodeLocation(Class<?> object) {
        try {
            if (object != null && (object = ((Class)object).getProtectionDomain().getCodeSource()) != null && (object = ((CodeSource)object).getLocation()) != null) {
                String string = this.getCodeLocation((String)(object = ((URL)object).toString()), '/');
                if (string != null) {
                    return string;
                }
                return this.getCodeLocation((String)object, '\\');
            }
        }
        catch (Exception exception) {}
        return "na";
    }

    private String getCodeLocation(String string, char c) {
        int n = string.lastIndexOf(c);
        if (this.isFolder(n, string)) {
            n = string.lastIndexOf(c, n - 1);
            return string.substring(n + 1);
        }
        if (n > 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    private boolean isFolder(int n, String string) {
        return n != -1 && n + 1 == string.length();
    }

    private Class<?> loadClass(ClassLoader object, String string) {
        if (object == null) {
            return null;
        }
        try {
            return ((ClassLoader)object).loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return null;
        }
    }

    private Class<?> bestEffortLoadClass(ClassLoader object, String string) {
        Class<?> clazz = this.loadClass((ClassLoader)object, string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != object) {
            clazz = this.loadClass(classLoader, string);
        }
        if (clazz != null) {
            return clazz;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return null;
        }
    }
}

