/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Locale;

public final class NettyRuntime {
    private static final AvailableProcessorsHolder holder = new AvailableProcessorsHolder();

    public static void setAvailableProcessors(int n) {
        holder.setAvailableProcessors(n);
    }

    public static int availableProcessors() {
        return holder.availableProcessors();
    }

    private NettyRuntime() {
    }

    static class AvailableProcessorsHolder {
        private int availableProcessors;

        AvailableProcessorsHolder() {
        }

        synchronized void setAvailableProcessors(int n) {
            ObjectUtil.checkPositive(n, "availableProcessors");
            if (this.availableProcessors != 0) {
                String string = String.format(Locale.ROOT, "availableProcessors is already set to [%d], rejecting [%d]", this.availableProcessors, n);
                throw new IllegalStateException(string);
            }
            this.availableProcessors = n;
        }

        synchronized int availableProcessors() {
            if (this.availableProcessors == 0) {
                int n = SystemPropertyUtil.getInt("io.netty.availableProcessors", Runtime.getRuntime().availableProcessors());
                this.setAvailableProcessors(n);
            }
            return this.availableProcessors;
        }
    }
}

