/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.CharObjectMap;
import io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CharObjectHashMap<V>
implements CharObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private char[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Character> keySet = new KeySet();
    private final Set<Map.Entry<Character, V>> entrySet = new EntrySet();
    private final Iterable<CharObjectMap.PrimitiveEntry<V>> entries = new Iterable<CharObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<CharObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public CharObjectHashMap() {
        this(8, 0.5f);
    }

    public CharObjectHashMap(int n) {
        this(n, 0.5f);
    }

    public CharObjectHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f;
        n = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.mask = n - 1;
        this.keys = new char[n];
        Object[] objectArray = new Object[n];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n);
    }

    private static <T> T toExternal(T t) {
        assert (t != null) : "null is not a legitimate internal value. Concurrent Modification?";
        if (t == NULL_VALUE) {
            return null;
        }
        return t;
    }

    private static <T> T toInternal(T t) {
        if (t == null) {
            return (T)NULL_VALUE;
        }
        return t;
    }

    @Override
    public V get(char c) {
        int n = this.indexOf(c);
        c = (char)n;
        if (n == -1) {
            return null;
        }
        return CharObjectHashMap.toExternal(this.values[c]);
    }

    @Override
    public V put(char c, V v) {
        int n;
        int n2 = n = this.hashIndex(c);
        do {
            if (this.values[n2] == null) {
                this.keys[n2] = c;
                this.values[n2] = CharObjectHashMap.toInternal(v);
                this.growSize();
                return null;
            }
            if (this.keys[n2] != c) continue;
            V v2 = this.values[n2];
            this.values[n2] = CharObjectHashMap.toInternal(v);
            return CharObjectHashMap.toExternal(v2);
        } while ((n2 = this.probeNext(n2)) != n);
        throw new IllegalStateException("Unable to insert");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends Character, ? extends V> object) {
        if (object instanceof CharObjectHashMap) {
            void entry;
            object = (CharObjectHashMap)((Object)object);
            boolean i = false;
            while (entry < ((CharObjectHashMap)((Object)object)).values.length) {
                V v = ((CharObjectHashMap)((Object)object)).values[entry];
                if (v != null) {
                    this.put(((CharObjectHashMap)((Object)object)).keys[entry], v);
                }
                ++entry;
            }
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            this.put((Character)entry.getKey(), (V)entry.getValue());
        }
    }

    @Override
    public V remove(char c) {
        int n = this.indexOf(c);
        c = (char)n;
        if (n == -1) {
            return null;
        }
        V v = this.values[c];
        this.removeAt(c);
        return CharObjectHashMap.toExternal(v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(char c) {
        return this.indexOf(c) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        object = CharObjectHashMap.toInternal(object);
        V[] VArray = this.values;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            V v = VArray[i];
            if (v == null || !v.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<CharObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return CharObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int n = this.size;
        char[] cArray = this.keys;
        int n2 = this.keys.length;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            n ^= CharObjectHashMap.hashCode(c);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharObjectMap)) {
            return false;
        }
        if (this.size != (object = (CharObjectMap)object).size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            char c = this.keys[i];
            Object v2 = object.get(c);
            if (!(v == NULL_VALUE ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.containsKey(charObjectHashMap.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.get(charObjectHashMap.objectToKey(object));
    }

    @Override
    public V put(Character c, V v) {
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.put(charObjectHashMap.objectToKey(c), v);
    }

    @Override
    public V remove(Object object) {
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.remove(charObjectHashMap.objectToKey(object));
    }

    @Override
    public Set<Character> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Character, V>> entrySet() {
        return this.entrySet;
    }

    private char objectToKey(Object object) {
        return ((Character)object).charValue();
    }

    private int indexOf(char c) {
        int n;
        int n2 = n = this.hashIndex(c);
        do {
            if (this.values[n2] == null) {
                return -1;
            }
            if (c != this.keys[n2]) continue;
            return n2;
        } while ((n2 = this.probeNext(n2)) != n);
        return -1;
    }

    private int hashIndex(char c) {
        return CharObjectHashMap.hashCode(c) & this.mask;
    }

    private static int hashCode(char c) {
        return c;
    }

    private int probeNext(int n) {
        return n + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            CharObjectHashMap charObjectHashMap = this;
            charObjectHashMap.rehash(charObjectHashMap.keys.length << 1);
        }
    }

    private boolean removeAt(int n) {
        --this.size;
        this.keys[n] = '\u0000';
        this.values[n] = null;
        int n2 = n;
        int n3 = this.probeNext(n);
        V v = this.values[n3];
        while (v != null) {
            char c = this.keys[n3];
            int n4 = this.hashIndex(c);
            if (n3 < n4 && (n4 <= n2 || n2 <= n3) || n4 <= n2 && n2 <= n3) {
                this.keys[n2] = c;
                this.values[n2] = v;
                this.keys[n3] = '\u0000';
                this.values[n3] = null;
                n2 = n3;
            }
            n3 = this.probeNext(n3);
            v = this.values[n3];
        }
        return n2 != n;
    }

    private int calcMaxSize(int n) {
        int n2 = n - 1;
        return Math.min(n2, (int)((float)n * this.loadFactor));
    }

    private void rehash(int n) {
        char[] cArray = this.keys;
        V[] VArray = this.values;
        this.keys = new char[n];
        Object object = new Object[n];
        this.values = object;
        this.maxSize = this.calcMaxSize(n);
        this.mask = n - 1;
        block0: for (n = 0; n < VArray.length; ++n) {
            object = VArray[n];
            if (object == null) continue;
            char c = cArray[n];
            int n2 = this.hashIndex(c);
            while (true) {
                if (this.values[n2] == null) {
                    this.keys[n2] = c;
                    this.values[n2] = object;
                    continue block0;
                }
                n2 = this.probeNext(n2);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            CharObjectHashMap charObjectHashMap = this;
            stringBuilder.append(charObjectHashMap.keyToString(charObjectHashMap.keys[i])).append('=').append((Object)(v == this ? "(this Map)" : CharObjectHashMap.toExternal(v)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(char c) {
        return Character.toString(c);
    }

    final class MapEntry
    implements Map.Entry<Character, V> {
        private final int entryIndex;

        MapEntry(int n) {
            this.entryIndex = n;
        }

        @Override
        public final Character getKey() {
            this.verifyExists();
            return Character.valueOf(CharObjectHashMap.this.keys[this.entryIndex]);
        }

        @Override
        public final V getValue() {
            this.verifyExists();
            return CharObjectHashMap.toExternal(CharObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public final V setValue(V v) {
            this.verifyExists();
            Object object = CharObjectHashMap.toExternal(CharObjectHashMap.this.values[this.entryIndex]);
            ((CharObjectHashMap)CharObjectHashMap.this).values[this.entryIndex] = CharObjectHashMap.toInternal(v);
            return object;
        }

        private void verifyExists() {
            if (CharObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Character, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final Map.Entry<Character, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements CharObjectMap.PrimitiveEntry<V>,
    Iterator<CharObjectMap.PrimitiveEntry<V>> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != CharObjectHashMap.this.values.length && CharObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != CharObjectHashMap.this.values.length;
        }

        @Override
        public final CharObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public final void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (CharObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public final char key() {
            return CharObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V value() {
            return CharObjectHashMap.toExternal(CharObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public final void setValue(V v) {
            ((CharObjectHashMap)CharObjectHashMap.this).values[this.entryIndex] = CharObjectHashMap.toInternal(v);
        }
    }

    private final class KeySet
    extends AbstractSet<Character> {
        private KeySet() {
        }

        @Override
        public final int size() {
            return CharObjectHashMap.this.size();
        }

        @Override
        public final boolean contains(Object object) {
            return CharObjectHashMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return CharObjectHashMap.this.remove(object) != null;
        }

        @Override
        public final boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = CharObjectHashMap.this.entries().iterator();
            while (iterator.hasNext()) {
                CharObjectMap.PrimitiveEntry primitiveEntry = iterator.next();
                if (collection.contains(Character.valueOf(primitiveEntry.key()))) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public final void clear() {
            CharObjectHashMap.this.clear();
        }

        @Override
        public final Iterator<Character> iterator() {
            return new Iterator<Character>(){
                private final Iterator<Map.Entry<Character, V>> iter;
                {
                    this.iter = CharObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Character next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Character, V>> {
        private EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<Character, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public final int size() {
            return CharObjectHashMap.this.size();
        }
    }
}

