/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import java.util.LinkedHashSet;
import java.util.Set;

@Deprecated
public class PromiseAggregator<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private final Promise<?> aggregatePromise;
    private final boolean failPending;
    private Set<Promise<V>> pendingPromises;

    public PromiseAggregator(Promise<Void> promise, boolean bl) {
        this.aggregatePromise = ObjectUtil.checkNotNull(promise, "aggregatePromise");
        this.failPending = bl;
    }

    public PromiseAggregator(Promise<Void> promise) {
        this(promise, true);
    }

    @SafeVarargs
    public final PromiseAggregator<V, F> add(Promise<V> ... promiseArray) {
        ObjectUtil.checkNotNull(promiseArray, "promises");
        if (promiseArray.length == 0) {
            return this;
        }
        PromiseAggregator promiseAggregator = this;
        synchronized (promiseAggregator) {
            if (this.pendingPromises == null) {
                int n = promiseArray.length > 1 ? promiseArray.length : 2;
                this.pendingPromises = new LinkedHashSet<Promise<V>>(n);
            }
            Promise<V>[] promiseArray2 = promiseArray;
            int n = promiseArray.length;
            for (int i = 0; i < n; ++i) {
                Promise<V> promise = promiseArray2[i];
                if (promise == null) continue;
                this.pendingPromises.add(promise);
                promise.addListener(this);
            }
        }
        return this;
    }

    @Override
    public synchronized void operationComplete(F object) {
        if (this.pendingPromises == null) {
            this.aggregatePromise.setSuccess(null);
            return;
        }
        this.pendingPromises.remove(object);
        if (!object.isSuccess()) {
            object = object.cause();
            this.aggregatePromise.setFailure((Throwable)object);
            if (this.failPending) {
                for (Promise<V> promise : this.pendingPromises) {
                    promise.setFailure((Throwable)object);
                }
            }
            return;
        }
        if (this.pendingPromises.isEmpty()) {
            this.aggregatePromise.setSuccess(null);
        }
    }
}

