/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.BoundedInputStream;
import io.netty.util.internal.Cleaner;
import io.netty.util.internal.CleanerJava6;
import io.netty.util.internal.CleanerJava9;
import io.netty.util.internal.ConstantTimeUtils;
import io.netty.util.internal.LongAdderCounter;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.OutOfDirectMemoryError;
import io.netty.util.internal.PlatformDependent0;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadLocalRandom;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscUnboundedArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.SpscLinkedQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpmcAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscChunkedAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscUnboundedAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.SpscLinkedAtomicQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.unpadded.MpscAtomicUnpaddedArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.unpadded.MpscUnpaddedArrayQueue;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PlatformDependent {
    private static final InternalLogger logger;
    private static Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN;
    private static final boolean MAYBE_SUPER_USER;
    private static final boolean CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final boolean DIRECT_BUFFER_PREFERRED;
    private static final long MAX_DIRECT_MEMORY;
    private static final int MPSC_CHUNK_SIZE = 1024;
    private static final int MIN_MAX_MPSC_CAPACITY = 2048;
    private static final int MAX_ALLOWED_MPSC_CAPACITY = 0x40000000;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final File TMPDIR;
    private static final int BIT_MODE;
    private static final String NORMALIZED_ARCH;
    private static final String NORMALIZED_OS;
    private static final String[] ALLOWED_LINUX_OS_CLASSIFIERS;
    private static final Set<String> LINUX_OS_CLASSIFIERS;
    private static final boolean IS_WINDOWS;
    private static final boolean IS_OSX;
    private static final boolean IS_J9_JVM;
    private static final boolean IS_IVKVM_DOT_NET;
    private static final int ADDRESS_SIZE;
    private static final boolean USE_DIRECT_BUFFER_NO_CLEANER;
    private static final AtomicLong DIRECT_MEMORY_COUNTER;
    private static final long DIRECT_MEMORY_LIMIT;
    private static final ThreadLocalRandomProvider RANDOM_PROVIDER;
    private static final Cleaner CLEANER;
    private static final int UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD;
    private static final String[] OS_RELEASE_FILES;
    private static final String LINUX_ID_PREFIX = "ID=";
    private static final String LINUX_ID_LIKE_PREFIX = "ID_LIKE=";
    public static final boolean BIG_ENDIAN_NATIVE_ORDER;
    private static final Cleaner NOOP;

    static void addFilesystemOsClassifiers(Set<String> set, Set<String> set2) {
        String string;
        File file;
        boolean bl;
        String[] stringArray = OS_RELEASE_FILES;
        int n = OS_RELEASE_FILES.length;
        for (int i = 0; i < n && !(bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(file = new File(string = stringArray[i]), set, set2, string){
            final /* synthetic */ File val$file;
            final /* synthetic */ Set val$allowedClassifiers;
            final /* synthetic */ Set val$availableClassifiers;
            final /* synthetic */ String val$osReleaseFileName;
            {
                this.val$file = file;
                this.val$allowedClassifiers = set;
                this.val$availableClassifiers = set2;
                this.val$osReleaseFileName = string;
            }

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final Boolean run() {
                try {
                    String string;
                    if (!this.val$file.exists()) return Boolean.FALSE;
                    BufferedReader bufferedReader = null;
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new BoundedInputStream(new FileInputStream(this.val$file)), CharsetUtil.UTF_8));
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith(PlatformDependent.LINUX_ID_PREFIX)) {
                            string = PlatformDependent.normalizeOsReleaseVariableValue(string.substring(3));
                            PlatformDependent.addClassifier(this.val$allowedClassifiers, this.val$availableClassifiers, new String[]{string});
                            continue;
                        }
                        if (!string.startsWith(PlatformDependent.LINUX_ID_LIKE_PREFIX)) continue;
                        string = PlatformDependent.normalizeOsReleaseVariableValue(string.substring(8));
                        PlatformDependent.addClassifier(this.val$allowedClassifiers, this.val$availableClassifiers, string.split("[ ]+"));
                    }
                    try {
                        bufferedReader.close();
                        return Boolean.TRUE;
                    }
                    catch (IOException iOException) {}
                    return Boolean.TRUE;
                    catch (SecurityException securityException) {
                        logger.debug("Unable to read {}", (Object)this.val$osReleaseFileName, (Object)securityException);
                        if (bufferedReader == null) return Boolean.TRUE;
                        try {
                            bufferedReader.close();
                            return Boolean.TRUE;
                        }
                        catch (IOException iOException) {}
                        return Boolean.TRUE;
                    }
                    catch (IOException iOException) {
                        logger.debug("Error while reading content of {}", (Object)this.val$osReleaseFileName, (Object)iOException);
                        if (bufferedReader == null) return Boolean.TRUE;
                        {
                            catch (Throwable throwable) {
                                if (bufferedReader == null) throw throwable;
                                try {
                                    bufferedReader.close();
                                    throw throwable;
                                }
                                catch (IOException iOException2) {}
                                throw throwable;
                            }
                        }
                        try {
                            bufferedReader.close();
                            return Boolean.TRUE;
                        }
                        catch (IOException iOException3) {}
                        return Boolean.TRUE;
                    }
                }
                catch (SecurityException securityException) {
                    logger.debug("Unable to check if {} exists", (Object)this.val$osReleaseFileName, (Object)securityException);
                }
                return Boolean.FALSE;
            }
        }).booleanValue()); ++i) {
        }
    }

    static boolean addPropertyOsClassifiers(Set<String> set, Set<String> set2) {
        String[] stringArray = "io.netty.osClassifiers";
        String string = SystemPropertyUtil.get((String)"io.netty.osClassifiers");
        if (string == null) {
            return false;
        }
        if (string.isEmpty()) {
            return true;
        }
        String[] stringArray2 = string.split(",");
        if (stringArray2.length == 0) {
            throw new IllegalArgumentException((String)stringArray + " property is not empty, but contains no classifiers: " + string);
        }
        if (stringArray2.length > 2) {
            throw new IllegalArgumentException((String)stringArray + " property contains more than 2 classifiers: " + string);
        }
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            PlatformDependent.addClassifier(set, set2, string2);
        }
        return true;
    }

    public static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    public static boolean hasDirectBufferNoCleanerConstructor() {
        return PlatformDependent0.hasDirectBufferNoCleanerConstructor();
    }

    public static byte[] allocateUninitializedArray(int n) {
        if (UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD < 0 || UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD > n) {
            return new byte[n];
        }
        return PlatformDependent0.allocateUninitializedArray(n);
    }

    public static boolean isAndroid() {
        return PlatformDependent0.isAndroid();
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isOsx() {
        return IS_OSX;
    }

    public static boolean maybeSuperUser() {
        return MAYBE_SUPER_USER;
    }

    public static int javaVersion() {
        return PlatformDependent0.javaVersion();
    }

    public static boolean canEnableTcpNoDelayByDefault() {
        return CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    }

    public static boolean hasUnsafe() {
        return UNSAFE_UNAVAILABILITY_CAUSE == null;
    }

    public static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    public static boolean isUnaligned() {
        return PlatformDependent0.isUnaligned();
    }

    public static boolean directBufferPreferred() {
        return DIRECT_BUFFER_PREFERRED;
    }

    public static long maxDirectMemory() {
        return DIRECT_MEMORY_LIMIT;
    }

    public static long usedDirectMemory() {
        if (DIRECT_MEMORY_COUNTER != null) {
            return DIRECT_MEMORY_COUNTER.get();
        }
        return -1L;
    }

    public static File tmpdir() {
        return TMPDIR;
    }

    public static int bitMode() {
        return BIT_MODE;
    }

    public static int addressSize() {
        return ADDRESS_SIZE;
    }

    public static long allocateMemory(long l) {
        return PlatformDependent0.allocateMemory(l);
    }

    public static void freeMemory(long l) {
        PlatformDependent0.freeMemory(l);
    }

    public static long reallocateMemory(long l, long l2) {
        return PlatformDependent0.reallocateMemory(l, l2);
    }

    public static void throwException(Throwable throwable) {
        if (PlatformDependent.hasUnsafe()) {
            PlatformDependent0.throwException(throwable);
            return;
        }
        PlatformDependent.throwException0(throwable);
    }

    private static <E extends Throwable> void throwException0(Throwable throwable) {
        throw throwable;
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static LongCounter newLongCounter() {
        if (PlatformDependent.javaVersion() >= 8) {
            return new LongAdderCounter();
        }
        return new AtomicLongCounter();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n) {
        return new ConcurrentHashMap(n);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n, float f) {
        return new ConcurrentHashMap(n, f);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n, float f, int n2) {
        return new ConcurrentHashMap(n, f, n2);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> map) {
        return new ConcurrentHashMap<K, V>(map);
    }

    public static void freeDirectBuffer(ByteBuffer byteBuffer) {
        CLEANER.freeDirectBuffer(byteBuffer);
    }

    public static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.directBufferAddress(byteBuffer);
    }

    public static ByteBuffer directBuffer(long l, int n) {
        if (PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            return PlatformDependent0.newDirectBuffer(l, n);
        }
        throw new UnsupportedOperationException("sun.misc.Unsafe or java.nio.DirectByteBuffer.<init>(long, int) not available");
    }

    public static Object getObject(Object object, long l) {
        return PlatformDependent0.getObject(object, l);
    }

    public static int getInt(Object object, long l) {
        return PlatformDependent0.getInt(object, l);
    }

    static void safeConstructPutInt(Object object, long l, int n) {
        PlatformDependent0.safeConstructPutInt(object, l, n);
    }

    public static int getIntVolatile(long l) {
        return PlatformDependent0.getIntVolatile(l);
    }

    public static void putIntOrdered(long l, int n) {
        PlatformDependent0.putIntOrdered(l, n);
    }

    public static byte getByte(long l) {
        return PlatformDependent0.getByte(l);
    }

    public static short getShort(long l) {
        return PlatformDependent0.getShort(l);
    }

    public static int getInt(long l) {
        return PlatformDependent0.getInt(l);
    }

    public static long getLong(long l) {
        return PlatformDependent0.getLong(l);
    }

    public static byte getByte(byte[] byArray, int n) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent0.getByte(byArray, n);
        }
        return byArray[n];
    }

    public static byte getByte(byte[] byArray, long l) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent0.getByte(byArray, l);
        }
        return byArray[PlatformDependent.toIntExact(l)];
    }

    public static short getShort(byte[] byArray, int n) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent0.getShort(byArray, n);
        }
        return byArray[n];
    }

    public static int getInt(byte[] byArray, int n) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent0.getInt(byArray, n);
        }
        return byArray[n];
    }

    public static int getInt(int[] nArray, long l) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent0.getInt(nArray, l);
        }
        return nArray[PlatformDependent.toIntExact(l)];
    }

    public static long getLong(byte[] byArray, int n) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent0.getLong(byArray, n);
        }
        return byArray[n];
    }

    public static long getLong(long[] lArray, long l) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent0.getLong(lArray, l);
        }
        return lArray[PlatformDependent.toIntExact(l)];
    }

    private static int toIntExact(long l) {
        if (PlatformDependent.javaVersion() >= 8) {
            return PlatformDependent.toIntExact8(l);
        }
        int n = (int)l;
        if ((long)n != l) {
            throw new ArithmeticException("Cannot convert to exact int: " + l);
        }
        return n;
    }

    private static int toIntExact8(long l) {
        return Math.toIntExact(l);
    }

    private static long getLongSafe(byte[] byArray, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (long)byArray[n] << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
        }
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | (long)byArray[n + 7] << 56;
    }

    private static int getIntSafe(byte[] byArray, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    private static short getShortSafe(byte[] byArray, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (short)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
        }
        return (short)(byArray[n] & 0xFF | byArray[n + 1] << 8);
    }

    private static int hashCodeAsciiCompute(CharSequence charSequence, int n, int n2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return n2 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n + 4) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n);
        }
        return n2 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n + 4);
    }

    private static int hashCodeAsciiSanitizeInt(CharSequence charSequence, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return charSequence.charAt(n + 3) & 0x1F | (charSequence.charAt(n + 2) & 0x1F) << 8 | (charSequence.charAt(n + 1) & 0x1F) << 16 | (charSequence.charAt(n) & 0x1F) << 24;
        }
        return (charSequence.charAt(n + 3) & 0x1F) << 24 | (charSequence.charAt(n + 2) & 0x1F) << 16 | (charSequence.charAt(n + 1) & 0x1F) << 8 | charSequence.charAt(n) & 0x1F;
    }

    private static int hashCodeAsciiSanitizeShort(CharSequence charSequence, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return charSequence.charAt(n + 1) & 0x1F | (charSequence.charAt(n) & 0x1F) << 8;
        }
        return (charSequence.charAt(n + 1) & 0x1F) << 8 | charSequence.charAt(n) & 0x1F;
    }

    private static int hashCodeAsciiSanitizeByte(char c) {
        return c & 0x1F;
    }

    public static void putByte(long l, byte by) {
        PlatformDependent0.putByte(l, by);
    }

    public static void putShort(long l, short s) {
        PlatformDependent0.putShort(l, s);
    }

    public static void putInt(long l, int n) {
        PlatformDependent0.putInt(l, n);
    }

    public static void putLong(long l, long l2) {
        PlatformDependent0.putLong(l, l2);
    }

    public static void putByte(byte[] byArray, int n, byte by) {
        PlatformDependent0.putByte(byArray, n, by);
    }

    public static void putByte(Object object, long l, byte by) {
        PlatformDependent0.putByte(object, l, by);
    }

    public static void putShort(byte[] byArray, int n, short s) {
        PlatformDependent0.putShort(byArray, n, s);
    }

    public static void putInt(byte[] byArray, int n, int n2) {
        PlatformDependent0.putInt(byArray, n, n2);
    }

    public static void putLong(byte[] byArray, int n, long l) {
        PlatformDependent0.putLong(byArray, n, l);
    }

    public static void putObject(Object object, long l, Object object2) {
        PlatformDependent0.putObject(object, l, object2);
    }

    public static long objectFieldOffset(Field field) {
        return PlatformDependent0.objectFieldOffset(field);
    }

    public static void copyMemory(long l, long l2, long l3) {
        PlatformDependent0.copyMemory(l, l2, l3);
    }

    public static void copyMemory(byte[] byArray, int n, long l, long l2) {
        PlatformDependent0.copyMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, null, l, l2);
    }

    public static void copyMemory(byte[] byArray, int n, byte[] byArray2, int n2, long l) {
        PlatformDependent0.copyMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, byArray2, BYTE_ARRAY_BASE_OFFSET + (long)n2, l);
    }

    public static void copyMemory(long l, byte[] byArray, int n, long l2) {
        PlatformDependent0.copyMemory(null, l, byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, l2);
    }

    public static void setMemory(byte[] byArray, int n, long l, byte by) {
        PlatformDependent0.setMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, l, by);
    }

    public static void setMemory(long l, long l2, byte by) {
        PlatformDependent0.setMemory(l, l2, by);
    }

    public static ByteBuffer allocateDirectNoCleaner(int n) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        PlatformDependent.incrementMemoryCounter(n);
        try {
            return PlatformDependent0.allocateDirectNoCleaner(n);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n2 = n - byteBuffer.capacity();
        PlatformDependent.incrementMemoryCounter(n2);
        try {
            return PlatformDependent0.reallocateDirectNoCleaner(byteBuffer, n);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n2);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static void freeDirectNoCleaner(ByteBuffer byteBuffer) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n = byteBuffer.capacity();
        PlatformDependent0.freeMemory(PlatformDependent0.directBufferAddress(byteBuffer));
        PlatformDependent.decrementMemoryCounter(n);
    }

    public static boolean hasAlignDirectByteBuffer() {
        return PlatformDependent.hasUnsafe() || PlatformDependent0.hasAlignSliceMethod();
    }

    public static ByteBuffer alignDirectBuffer(ByteBuffer byteBuffer, int n) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Cannot get aligned slice of non-direct byte buffer.");
        }
        if (PlatformDependent0.hasAlignSliceMethod()) {
            return PlatformDependent0.alignSlice(byteBuffer, n);
        }
        if (PlatformDependent.hasUnsafe()) {
            long l = PlatformDependent.directBufferAddress(byteBuffer);
            long l2 = PlatformDependent.align(l, n);
            byteBuffer.position((int)(l2 - l));
            return byteBuffer.slice();
        }
        throw new UnsupportedOperationException("Cannot align direct buffer. Needs either Unsafe or ByteBuffer.alignSlice method available.");
    }

    public static long align(long l, int n) {
        return Pow2.align(l, n);
    }

    private static void incrementMemoryCounter(int n) {
        long l;
        if (DIRECT_MEMORY_COUNTER != null && (l = DIRECT_MEMORY_COUNTER.addAndGet(n)) > DIRECT_MEMORY_LIMIT) {
            DIRECT_MEMORY_COUNTER.addAndGet(-n);
            throw new OutOfDirectMemoryError("failed to allocate " + n + " byte(s) of direct memory (used: " + (l - (long)n) + ", max: " + DIRECT_MEMORY_LIMIT + ')');
        }
    }

    private static void decrementMemoryCounter(int n) {
        if (DIRECT_MEMORY_COUNTER != null) {
            long l = DIRECT_MEMORY_COUNTER.addAndGet(-n);
            assert (l >= 0L);
        }
    }

    public static boolean useDirectBufferNoCleaner() {
        return USE_DIRECT_BUFFER_NO_CLEANER;
    }

    public static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (PlatformDependent.javaVersion() > 8 && (n2 | n | byArray.length - n3 | byArray2.length - n3) == 0) {
            return Arrays.equals(byArray, byArray2);
        }
        if (!PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess()) {
            return PlatformDependent.equalsSafe(byArray, n, byArray2, n2, n3);
        }
        return PlatformDependent0.equals(byArray, n, byArray2, n2, n3);
    }

    public static boolean isZero(byte[] byArray, int n, int n2) {
        if (!PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess()) {
            return PlatformDependent.isZeroSafe(byArray, n, n2);
        }
        return PlatformDependent0.isZero(byArray, n, n2);
    }

    public static int equalsConstantTime(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (!PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess()) {
            return ConstantTimeUtils.equalsConstantTime(byArray, n, byArray2, n2, n3);
        }
        return PlatformDependent0.equalsConstantTime(byArray, n, byArray2, n2, n3);
    }

    public static int hashCodeAscii(byte[] byArray, int n, int n2) {
        if (!PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess()) {
            return PlatformDependent.hashCodeAsciiSafe(byArray, n, n2);
        }
        return PlatformDependent0.hashCodeAscii(byArray, n, n2);
    }

    public static int hashCodeAscii(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = n & 7;
        int n3 = -1028477387;
        if (n >= 32) {
            n -= 8;
            while (n >= n2) {
                n3 = PlatformDependent.hashCodeAsciiCompute(charSequence, n, n3);
                n -= 8;
            }
        } else if (n >= 8) {
            n3 = PlatformDependent.hashCodeAsciiCompute(charSequence, n - 8, -1028477387);
            if (n >= 16) {
                n3 = PlatformDependent.hashCodeAsciiCompute(charSequence, n - 16, n3);
                if (n >= 24) {
                    n3 = PlatformDependent.hashCodeAsciiCompute(charSequence, n - 24, n3);
                }
            }
        }
        if (n2 == 0) {
            return n3;
        }
        n = 0;
        if (n2 != 2 & n2 != 4 & n2 != 6) {
            n3 = n3 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeByte(charSequence.charAt(0));
            n = 1;
        }
        if (n2 != 1 & n2 != 4 & n2 != 5) {
            n3 = n3 * (n == 0 ? -862048943 : 461845907) + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.hashCodeAsciiSanitizeShort(charSequence, n));
            n += 2;
        }
        if (n2 >= 4) {
            return n3 * (n == 0 | n == 3 ? -862048943 : 461845907) + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n);
        }
        return n3;
    }

    public static <T> Queue<T> newMpscQueue() {
        return Mpsc.newMpscQueue();
    }

    public static <T> Queue<T> newMpscQueue(int n) {
        return Mpsc.newMpscQueue(n);
    }

    public static <T> Queue<T> newMpscQueue(int n, int n2) {
        return Mpsc.newChunkedMpscQueue(n, n2);
    }

    public static <T> Queue<T> newSpscQueue() {
        if (PlatformDependent.hasUnsafe()) {
            return new SpscLinkedQueue();
        }
        return new SpscLinkedAtomicQueue();
    }

    public static <T> Queue<T> newFixedMpscQueue(int n) {
        if (PlatformDependent.hasUnsafe()) {
            return new MpscArrayQueue(n);
        }
        return new MpscAtomicArrayQueue(n);
    }

    public static <T> Queue<T> newFixedMpscUnpaddedQueue(int n) {
        if (PlatformDependent.hasUnsafe()) {
            return new MpscUnpaddedArrayQueue(n);
        }
        return new MpscAtomicUnpaddedArrayQueue(n);
    }

    public static <T> Queue<T> newFixedMpmcQueue(int n) {
        if (PlatformDependent.hasUnsafe()) {
            return new MpmcArrayQueue(n);
        }
        return new MpmcAtomicArrayQueue(n);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        return PlatformDependent0.getClassLoader(clazz);
    }

    public static ClassLoader getContextClassLoader() {
        return PlatformDependent0.getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return PlatformDependent0.getSystemClassLoader();
    }

    public static <C> Deque<C> newConcurrentDeque() {
        if (PlatformDependent.javaVersion() < 7) {
            return new LinkedBlockingDeque();
        }
        return new ConcurrentLinkedDeque();
    }

    public static Random threadLocalRandom() {
        return RANDOM_PROVIDER.current();
    }

    private static boolean isWindows0() {
        boolean bl = "windows".equals(NORMALIZED_OS);
        if (bl) {
            logger.debug("Platform: Windows");
        }
        return bl;
    }

    private static boolean isOsx0() {
        boolean bl = "osx".equals(NORMALIZED_OS);
        if (bl) {
            logger.debug("Platform: MacOS");
        }
        return bl;
    }

    private static boolean maybeSuperUser0() {
        String string = SystemPropertyUtil.get("user.name");
        if (PlatformDependent.isWindows()) {
            return "Administrator".equals(string);
        }
        return "root".equals(string) || "toor".equals(string);
    }

    private static Throwable unsafeUnavailabilityCause0() {
        if (PlatformDependent.isAndroid()) {
            logger.debug("sun.misc.Unsafe: unavailable (Android)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (Android)");
        }
        if (PlatformDependent.isIkvmDotNet()) {
            logger.debug("sun.misc.Unsafe: unavailable (IKVM.NET)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (IKVM.NET)");
        }
        Throwable throwable = PlatformDependent0.getUnsafeUnavailabilityCause();
        if (throwable != null) {
            return throwable;
        }
        try {
            boolean bl = PlatformDependent0.hasUnsafe();
            logger.debug("sun.misc.Unsafe: {}", (Object)(bl ? "available" : "unavailable"));
            if (bl) {
                return null;
            }
            return PlatformDependent0.getUnsafeUnavailabilityCause();
        }
        catch (Throwable throwable2) {
            logger.trace("Could not determine if Unsafe is available", throwable2);
            return new UnsupportedOperationException("Could not determine if Unsafe is available", throwable2);
        }
    }

    public static boolean isJ9Jvm() {
        return IS_J9_JVM;
    }

    private static boolean isJ9Jvm0() {
        String string = SystemPropertyUtil.get("java.vm.name", "").toLowerCase();
        return string.startsWith("ibm j9") || string.startsWith("eclipse openj9");
    }

    public static boolean isIkvmDotNet() {
        return IS_IVKVM_DOT_NET;
    }

    private static boolean isIkvmDotNet0() {
        String string = SystemPropertyUtil.get("java.vm.name", "").toUpperCase(Locale.US);
        return string.equals("IKVM.NET");
    }

    private static Pattern getMaxDirectMemorySizeArgPattern() {
        Pattern pattern = MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN;
        if (pattern == null) {
            MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = pattern = Pattern.compile("\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");
        }
        return pattern;
    }

    public static long estimateMaxDirectMemory() {
        Class<?> clazz;
        Object object;
        long l = PlatformDependent0.bitsMaxDirectMemory();
        if (l > 0L) {
            return l;
        }
        Object object2 = null;
        try {
            object2 = PlatformDependent.getSystemClassLoader();
            object = SystemPropertyUtil.get("java.vm.name", "").toLowerCase();
            if (!((String)object).startsWith("ibm j9") && !((String)object).startsWith("eclipse openj9")) {
                clazz = Class.forName("sun.misc.VM", true, (ClassLoader)object2);
                object = clazz.getDeclaredMethod("maxDirectMemory", new Class[0]);
                l = ((Number)((Method)object).invoke(null, new Object[0])).longValue();
            }
        }
        catch (Throwable throwable) {}
        if (l > 0L) {
            return l;
        }
        try {
            object = Class.forName("java.lang.management.ManagementFactory", true, (ClassLoader)object2);
            clazz = Class.forName("java.lang.management.RuntimeMXBean", true, (ClassLoader)object2);
            object = ((Class)object).getDeclaredMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
            object2 = (List)clazz.getDeclaredMethod("getInputArguments", new Class[0]).invoke(object, new Object[0]);
            object = PlatformDependent.getMaxDirectMemorySizeArgPattern();
            for (int i = object2.size() - 1; i >= 0; --i) {
                Matcher matcher = ((Pattern)object).matcher((CharSequence)object2.get(i));
                if (!matcher.matches()) continue;
                l = Long.parseLong(matcher.group(1));
                switch (matcher.group(2).charAt(0)) {
                    case 'K': 
                    case 'k': {
                        l <<= 10;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        l *= 0x100000L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        l *= 0x40000000L;
                        break;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {}
        if (l <= 0L) {
            l = Runtime.getRuntime().maxMemory();
            logger.debug("maxDirectMemory: {} bytes (maybe)", (Object)l);
        } else {
            logger.debug("maxDirectMemory: {} bytes", (Object)l);
        }
        return l;
    }

    private static File tmpdir0() {
        File file;
        try {
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("io.netty.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {}", (Object)file);
                return file;
            }
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("java.io.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {} (java.io.tmpdir)", (Object)file);
                return file;
            }
            if (PlatformDependent.isWindows()) {
                file = PlatformDependent.toDirectory(System.getenv("TEMP"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} (%TEMP%)", (Object)file);
                    return file;
                }
                String string = System.getenv("USERPROFILE");
                if (string != null) {
                    file = PlatformDependent.toDirectory(string + "\\AppData\\Local\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\AppData\\Local\\Temp)", (Object)file);
                        return file;
                    }
                    file = PlatformDependent.toDirectory(string + "\\Local Settings\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\Local Settings\\Temp)", (Object)file);
                        return file;
                    }
                }
            } else {
                file = PlatformDependent.toDirectory(System.getenv("TMPDIR"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} ($TMPDIR)", (Object)file);
                    return file;
                }
            }
        }
        catch (Throwable throwable) {}
        file = PlatformDependent.isWindows() ? new File("C:\\Windows\\Temp") : new File("/tmp");
        logger.warn("Failed to get the temporary directory; falling back to: {}", (Object)file);
        return file;
    }

    private static File toDirectory(String object) {
        if (object == null) {
            return null;
        }
        object = new File((String)object);
        ((File)object).mkdirs();
        if (!((File)object).isDirectory()) {
            return null;
        }
        try {
            return ((File)object).getAbsoluteFile();
        }
        catch (Exception exception) {
            return object;
        }
    }

    private static int bitMode0() {
        int n = SystemPropertyUtil.getInt("io.netty.bitMode", 0);
        if (n > 0) {
            logger.debug("-Dio.netty.bitMode: {}", (Object)n);
            return n;
        }
        n = SystemPropertyUtil.getInt("sun.arch.data.model", 0);
        if (n > 0) {
            logger.debug("-Dio.netty.bitMode: {} (sun.arch.data.model)", (Object)n);
            return n;
        }
        n = SystemPropertyUtil.getInt("com.ibm.vm.bitmode", 0);
        if (n > 0) {
            logger.debug("-Dio.netty.bitMode: {} (com.ibm.vm.bitmode)", (Object)n);
            return n;
        }
        Object object = SystemPropertyUtil.get("os.arch", "").toLowerCase(Locale.US).trim();
        if ("amd64".equals(object) || "x86_64".equals(object)) {
            n = 64;
        } else if ("i386".equals(object) || "i486".equals(object) || "i586".equals(object) || "i686".equals(object)) {
            n = 32;
        }
        if (n > 0) {
            logger.debug("-Dio.netty.bitMode: {} (os.arch: {})", (Object)n, object);
        }
        Object object2 = SystemPropertyUtil.get("java.vm.name", "").toLowerCase(Locale.US);
        object = Pattern.compile("([1-9][0-9]+)-?bit");
        object2 = ((Pattern)object).matcher((CharSequence)object2);
        if (((Matcher)object2).find()) {
            return Integer.parseInt(((Matcher)object2).group(1));
        }
        return 64;
    }

    private static int addressSize0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1;
        }
        return PlatformDependent0.addressSize();
    }

    private static long byteArrayBaseOffset0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1L;
        }
        return PlatformDependent0.byteArrayBaseOffset();
    }

    private static boolean equalsSafe(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        n3 = n + n3;
        while (n < n3) {
            if (byArray[n] != byArray2[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    private static boolean isZeroSafe(byte[] byArray, int n, int n2) {
        n2 = n + n2;
        while (n < n2) {
            if (byArray[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static int hashCodeAsciiSafe(byte[] byArray, int n, int n2) {
        int n3 = -1028477387;
        int n4 = n2 & 7;
        int n5 = n + n4;
        for (n2 = n - 8 + n2; n2 >= n5; n2 -= 8) {
            n3 = PlatformDependent0.hashCodeAsciiCompute(PlatformDependent.getLongSafe(byArray, n2), n3);
        }
        switch (n4) {
            case 7: {
                return ((n3 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n + 1))) * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n + 3));
            }
            case 6: {
                return (n3 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n + 2));
            }
            case 5: {
                return (n3 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n + 1));
            }
            case 4: {
                return n3 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n));
            }
            case 3: {
                return (n3 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n + 1));
            }
            case 2: {
                return n3 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n));
            }
            case 1: {
                return n3 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n]);
            }
        }
        return n3;
    }

    public static String normalizedArch() {
        return NORMALIZED_ARCH;
    }

    public static String normalizedOs() {
        return NORMALIZED_OS;
    }

    public static Set<String> normalizedLinuxClassifiers() {
        return LINUX_OS_CLASSIFIERS;
    }

    public static File createTempFile(String object, String string, File file) {
        if (PlatformDependent.javaVersion() >= 7) {
            if (file == null) {
                return Files.createTempFile((String)object, string, new FileAttribute[0]).toFile();
            }
            return Files.createTempFile(file.toPath(), (String)object, string, new FileAttribute[0]).toFile();
        }
        object = file == null ? File.createTempFile((String)object, string) : File.createTempFile((String)object, string, file);
        if (!((File)object).setReadable(false, false)) {
            throw new IOException("Failed to set permissions on temporary file " + object);
        }
        if (!((File)object).setReadable(true, true)) {
            throw new IOException("Failed to set permissions on temporary file " + object);
        }
        return object;
    }

    private static void addClassifier(Set<String> set, Set<String> set2, String ... stringArray) {
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            set2.add(string);
        }
    }

    private static String normalizeOsReleaseVariableValue(String string) {
        return string.trim().replaceAll("[\"']", "");
    }

    private static String normalize(String string) {
        return string.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static String normalizeArch(String string) {
        if ((string = PlatformDependent.normalize(string)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (string.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (string.matches("^(ia64|itanium64)$")) {
            return "itanium_64";
        }
        if (string.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (string.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (string.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(string)) {
            return "aarch_64";
        }
        if ("riscv64".equals(string)) {
            return "riscv64";
        }
        if (string.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if ("ppc64".equals(string)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(string)) {
            return "ppcle_64";
        }
        if ("s390".equals(string)) {
            return "s390_32";
        }
        if ("s390x".equals(string)) {
            return "s390_64";
        }
        if ("loongarch64".equals(string)) {
            return "loongarch_64";
        }
        return "unknown";
    }

    private static String normalizeOs(String string) {
        if ((string = PlatformDependent.normalize(string)).startsWith("aix")) {
            return "aix";
        }
        if (string.startsWith("hpux")) {
            return "hpux";
        }
        if (string.startsWith("os400") && (string.length() <= 5 || !Character.isDigit(string.charAt(5)))) {
            return "os400";
        }
        if (string.startsWith("linux")) {
            return "linux";
        }
        if (string.startsWith("macosx") || string.startsWith("osx") || string.startsWith("darwin")) {
            return "osx";
        }
        if (string.startsWith("freebsd")) {
            return "freebsd";
        }
        if (string.startsWith("openbsd")) {
            return "openbsd";
        }
        if (string.startsWith("netbsd")) {
            return "netbsd";
        }
        if (string.startsWith("solaris") || string.startsWith("sunos")) {
            return "sunos";
        }
        if (string.startsWith("windows")) {
            return "windows";
        }
        return "unknown";
    }

    private PlatformDependent() {
    }

    static {
        LinkedHashSet<String> linkedHashSet;
        Set<String> set;
        logger = InternalLoggerFactory.getInstance(PlatformDependent.class);
        CAN_ENABLE_TCP_NODELAY_BY_DEFAULT = !PlatformDependent.isAndroid();
        UNSAFE_UNAVAILABILITY_CAUSE = PlatformDependent.unsafeUnavailabilityCause0();
        MAX_DIRECT_MEMORY = PlatformDependent.estimateMaxDirectMemory();
        BYTE_ARRAY_BASE_OFFSET = PlatformDependent.byteArrayBaseOffset0();
        TMPDIR = PlatformDependent.tmpdir0();
        BIT_MODE = PlatformDependent.bitMode0();
        NORMALIZED_ARCH = PlatformDependent.normalizeArch(SystemPropertyUtil.get("os.arch", ""));
        NORMALIZED_OS = PlatformDependent.normalizeOs(SystemPropertyUtil.get("os.name", ""));
        ALLOWED_LINUX_OS_CLASSIFIERS = new String[]{"fedora", "suse", "arch"};
        IS_WINDOWS = PlatformDependent.isWindows0();
        IS_OSX = PlatformDependent.isOsx0();
        IS_J9_JVM = PlatformDependent.isJ9Jvm0();
        IS_IVKVM_DOT_NET = PlatformDependent.isIkvmDotNet0();
        ADDRESS_SIZE = PlatformDependent.addressSize0();
        OS_RELEASE_FILES = new String[]{"/etc/os-release", "/usr/lib/os-release"};
        BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        NOOP = new Cleaner(){

            @Override
            public final void freeDirectBuffer(ByteBuffer byteBuffer) {
            }
        };
        RANDOM_PROVIDER = PlatformDependent.javaVersion() >= 7 ? new ThreadLocalRandomProvider(){

            @Override
            public final Random current() {
                return java.util.concurrent.ThreadLocalRandom.current();
            }
        } : new ThreadLocalRandomProvider(){

            @Override
            public final Random current() {
                return ThreadLocalRandom.current();
            }
        };
        long l = SystemPropertyUtil.getLong("io.netty.maxDirectMemory", -1L);
        if (l == 0L || !PlatformDependent.hasUnsafe() || !PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            USE_DIRECT_BUFFER_NO_CLEANER = false;
            DIRECT_MEMORY_COUNTER = null;
        } else {
            USE_DIRECT_BUFFER_NO_CLEANER = true;
            DIRECT_MEMORY_COUNTER = l < 0L ? ((l = MAX_DIRECT_MEMORY) <= 0L ? null : new AtomicLong()) : new AtomicLong();
        }
        logger.debug("-Dio.netty.maxDirectMemory: {} bytes", (Object)l);
        DIRECT_MEMORY_LIMIT = l >= 1L ? l : MAX_DIRECT_MEMORY;
        int n = SystemPropertyUtil.getInt("io.netty.uninitializedArrayAllocationThreshold", 1024);
        UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD = PlatformDependent.javaVersion() >= 9 && PlatformDependent0.hasAllocateArrayMethod() ? n : -1;
        logger.debug("-Dio.netty.uninitializedArrayAllocationThreshold: {}", (Object)UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD);
        MAYBE_SUPER_USER = PlatformDependent.maybeSuperUser0();
        CLEANER = !PlatformDependent.isAndroid() ? (PlatformDependent.javaVersion() >= 9 ? (CleanerJava9.isSupported() ? new CleanerJava9() : NOOP) : (CleanerJava6.isSupported() ? new CleanerJava6() : NOOP)) : NOOP;
        boolean bl = DIRECT_BUFFER_PREFERRED = CLEANER != NOOP && !SystemPropertyUtil.getBoolean("io.netty.noPreferDirect", false);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noPreferDirect: {}", (Object)(!DIRECT_BUFFER_PREFERRED ? 1 : 0));
        }
        if (CLEANER == NOOP && !PlatformDependent0.isExplicitNoUnsafe()) {
            logger.info("Your platform does not provide complete low-level API for accessing direct buffers reliably. Unless explicitly requested, heap buffer will always be preferred to avoid potential system instability.");
        }
        if (!PlatformDependent.addPropertyOsClassifiers(set = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ALLOWED_LINUX_OS_CLASSIFIERS))), linkedHashSet = new LinkedHashSet<String>())) {
            PlatformDependent.addFilesystemOsClassifiers(set, linkedHashSet);
        }
        LINUX_OS_CLASSIFIERS = Collections.unmodifiableSet(linkedHashSet);
    }

    private static interface ThreadLocalRandomProvider {
        public Random current();
    }

    private static final class AtomicLongCounter
    extends AtomicLong
    implements LongCounter {
        private static final long serialVersionUID = 4074772784610639305L;

        private AtomicLongCounter() {
        }

        @Override
        public final void add(long l) {
            this.addAndGet(l);
        }

        @Override
        public final void increment() {
            this.incrementAndGet();
        }

        @Override
        public final void decrement() {
            this.decrementAndGet();
        }

        @Override
        public final long value() {
            return this.get();
        }
    }

    private static final class Mpsc {
        private static final boolean USE_MPSC_CHUNKED_ARRAY_QUEUE;

        private Mpsc() {
        }

        static <T> Queue<T> newMpscQueue(int n) {
            n = Math.max(Math.min(n, 0x40000000), 2048);
            return Mpsc.newChunkedMpscQueue(1024, n);
        }

        static <T> Queue<T> newChunkedMpscQueue(int n, int n2) {
            if (USE_MPSC_CHUNKED_ARRAY_QUEUE) {
                return new MpscChunkedArrayQueue(n, n2);
            }
            return new MpscChunkedAtomicArrayQueue(n, n2);
        }

        static <T> Queue<T> newMpscQueue() {
            if (USE_MPSC_CHUNKED_ARRAY_QUEUE) {
                return new MpscUnboundedArrayQueue(1024);
            }
            return new MpscUnboundedAtomicArrayQueue(1024);
        }

        static {
            Object object = null;
            if (PlatformDependent.hasUnsafe()) {
                object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public final Object run() {
                        return UnsafeAccess.UNSAFE;
                    }
                });
            }
            if (object == null) {
                logger.debug("org.jctools-core.MpscChunkedArrayQueue: unavailable");
                USE_MPSC_CHUNKED_ARRAY_QUEUE = false;
            } else {
                logger.debug("org.jctools-core.MpscChunkedArrayQueue: available");
                USE_MPSC_CHUNKED_ARRAY_QUEUE = true;
            }
        }
    }
}

